/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.Nullable;

public final class StringUtil {
    private static final int BUFFER_SIZE = 4096;

    private StringUtil() {
    }

    public static String getFirstLine(@Nullable String s) {
        if (s == null) {
            return null;
        }
        int index = s.indexOf("\n");
        if (index == -1) {
            return s;
        }
        return s.substring(0, index);
    }

    public static synchronized String decode(String str2decode) {
        if (str2decode.length() == 0) {
            return "";
        }
        try {
            Base64 base64 = new Base64();
            byte[] passwordBytes = base64.decode(str2decode.getBytes("UTF-8"));
            if (passwordBytes == null || passwordBytes.length == 0) {
                throw new IllegalArgumentException("Cannot decode string due to not supported characters or becuase it is not encoded");
            }
            return new String(passwordBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 is not supported", e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Cannot decode string due to not supported characters or becuase it is not encoded", e);
        }
    }

    public static synchronized String encode(String str2encode) {
        try {
            Base64 base64 = new Base64();
            byte[] bytes = base64.encode(str2encode.getBytes("UTF-8"));
            return new String(bytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 is not supported", e);
        }
    }

    public static String slurp(InputStream in) throws IOException {
        StringBuilder out = new StringBuilder();
        byte[] b = new byte[4096];
        int n = in.read(b);
        while (n != -1) {
            out.append(new String(b, 0, n));
            n = in.read(b);
        }
        return out.toString();
    }

    public static String removeLeadingAndTrailingSlashes(String text) {
        if (text == null) {
            return null;
        }
        text = StringUtil.removePrefixSlashes(text);
        text = StringUtil.removeSuffixSlashes(text);
        return text;
    }

    /*
     * Unable to fully structure code
     */
    public static String removePrefixSlashes(String text) {
        if (text != null) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            text = text.substring(1, text.length());
lbl4:
            // 2 sources

            ** while (text.startsWith((String)"/"))
        }
lbl5:
        // 1 sources

        return text;
    }

    /*
     * Unable to fully structure code
     */
    public static String removeSuffixSlashes(String text) {
        if (text != null) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            text = text.substring(0, text.length() - 1);
lbl4:
            // 2 sources

            ** while (text.endsWith((String)"/"))
        }
lbl5:
        // 1 sources

        return text;
    }

    public static String generateJiraLogTimeString(long secondsSpent) {
        StringBuilder timeLog = new StringBuilder();
        long totalSeconds = secondsSpent;
        long remainingTime = 0L;
        long weeks = totalSeconds / 604800L;
        remainingTime = totalSeconds - weeks * 604800L;
        long days = remainingTime / 86400L;
        long hours = (remainingTime -= days * 86400L) / 3600L;
        long minutes = (remainingTime -= hours * 3600L) / 60L;
        if (weeks > 0L) {
            timeLog.append(" ").append(weeks).append("w");
        }
        if (days > 0L) {
            timeLog.append(" ").append(days).append("d");
        }
        if (hours > 0L) {
            timeLog.append(" ").append(hours).append("h");
        }
        if (minutes > 0L) {
            timeLog.append(" ").append(minutes).append("m");
        }
        return timeLog.toString().trim();
    }
}

