/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.thirdparty.apache;

import com.atlassian.theplugin.commons.thirdparty.apache.EasyX509TrustManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.HttpClientError;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class EasySSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    public static final int SSL_PORT = 443;
    private SSLContext sslcontext = null;

    private SSLContext createEasySSLContext() {
        KeyManagerFactory kmf = null;
        try {
            KeyStore keyStore = EasySSLProtocolSocketFactory.getKeyStore();
            String p = System.getProperty("javax.net.ssl.keyStorePassword");
            if (keyStore != null && p != null) {
                kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(keyStore, p.toCharArray());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(keyStore);
            }
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {}
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(kmf != null ? kmf.getKeyManagers() : null, new TrustManager[]{this.getTrustManager()}, kmf != null ? new SecureRandom() : null);
            return context;
        }
        catch (Exception e) {
            throw new HttpClientError(e.toString());
        }
    }

    public static KeyStore getKeyStore() {
        KeyStore keyJKSStore;
        block5: {
            keyJKSStore = EasySSLProtocolSocketFactory.getKeyJKSStore(System.getProperty("javax.net.ssl.keyStore"), System.getProperty("javax.net.ssl.keyStorePassword"));
            KeyStore trust = EasySSLProtocolSocketFactory.getKeyJKSStore(System.getProperty("javax.net.ssl.trustStore"), System.getProperty("javax.net.ssl.trustStorePassword"));
            try {
                if (trust == null || keyJKSStore == null || trust.size() <= 0 || keyJKSStore.size() <= 0) break block5;
                try {
                    while (trust.aliases().hasMoreElements()) {
                        String alias = trust.aliases().nextElement();
                        keyJKSStore.setCertificateEntry(alias, trust.getCertificate(alias));
                        trust.deleteEntry(alias);
                    }
                }
                catch (KeyStoreException keyStoreException) {}
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
        }
        return keyJKSStore;
    }

    private static KeyStore getKeyJKSStore(String keyStoreFileName, String keyStorePassword) {
        KeyStore jKeyStore = null;
        try {
            if (keyStorePassword != null && keyStorePassword.length() > 0 && keyStoreFileName != null && keyStoreFileName.length() > 0) {
                jKeyStore = KeyStore.getInstance("JKS");
                File file = new File(keyStoreFileName);
                FileInputStream inStream = new FileInputStream(file);
                jKeyStore.load(inStream, keyStorePassword.toCharArray());
            }
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (CertificateException certificateException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (IOException iOException) {}
        return jKeyStore;
    }

    protected X509TrustManager getTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        return new EasyX509TrustManager(EasySSLProtocolSocketFactory.getKeyStore());
    }

    private SSLContext getSSLContext() {
        if (this.sslcontext == null) {
            this.sslcontext = this.createEasySSLContext();
        }
        return this.sslcontext;
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(host, port, clientHost, clientPort);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        SSLSocketFactory socketfactory = this.getSSLContext().getSocketFactory();
        if (timeout == 0) {
            return socketfactory.createSocket(host, port, localAddress, localPort);
        }
        Socket socket = socketfactory.createSocket();
        InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        socket.bind(localaddr);
        socket.connect(remoteaddr, timeout);
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(host, port);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(EasySSLProtocolSocketFactory.class);
    }

    public int hashCode() {
        return EasySSLProtocolSocketFactory.class.hashCode();
    }
}

