/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.fisheye.api.rest;

import com.atlassian.connector.commons.api.ConnectionCfg;
import com.atlassian.theplugin.commons.crucible.api.rest.CrucibleRestXmlHelper;
import com.atlassian.theplugin.commons.fisheye.api.FishEyeSession;
import com.atlassian.theplugin.commons.fisheye.api.model.FisheyePathHistoryItem;
import com.atlassian.theplugin.commons.fisheye.api.model.changeset.Changeset;
import com.atlassian.theplugin.commons.fisheye.api.model.changeset.ChangesetIdList;
import com.atlassian.theplugin.commons.fisheye.api.model.changeset.FileRevisionKey;
import com.atlassian.theplugin.commons.remoteapi.CaptchaRequiredException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiLoginException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiLoginFailedException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiMalformedUrlException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiSessionExpiredException;
import com.atlassian.theplugin.commons.remoteapi.rest.AbstractHttpSession;
import com.atlassian.theplugin.commons.remoteapi.rest.HttpSessionCallback;
import com.atlassian.theplugin.commons.util.LoggerImpl;
import com.atlassian.theplugin.commons.util.MiscUtil;
import com.atlassian.theplugin.commons.util.UrlUtil;
import com.atlassian.theplugin.commons.util.XmlUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FishEyeRestSession
extends AbstractHttpSession
implements FishEyeSession {
    private static final String REST_BASE_URL = "/api/rest/";
    static final String LOGIN_ACTION = "/api/rest/login";
    static final String LOGOUT_ACTION = "/api/rest/logout";
    static final String LIST_REPOSITORIES_ACTION = "/api/rest/repositories";
    public static final String REVISION_DATA = "/rest-service-fe/revisionData-v1/";
    public static final String LIST_HISTORY_ACTION = "/rest-service-fe/revisionData-v1/pathHistory/";
    public static final String CHANGESET_LIST_ACTION = "/rest-service-fe/revisionData-v1/changesetList/";
    public static final String CHANGESET_ACTION = "/rest-service-fe/revisionData-v1/changeset/";
    private String authToken;
    private boolean loggedIn;
    private static final String EXCEPTION_ENCOUNTERED_WHILE_LOGOUT = "Exception encountered while logout:";
    private static final String CALLING_METHOD_WITHOUT_CALLING_LOGIN_FIRST = "Calling method without calling login() first";
    public static final String SERVER_RETURNED_MALFORMED_RESPONSE = "Server returned malformed response";
    private static final DateTimeFormatter CHANGESET_TIME_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ");
    private static final DateTimeFormatter CHANGESET1_TIME_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public FishEyeRestSession(ConnectionCfg server, HttpSessionCallback callback) throws RemoteApiMalformedUrlException {
        super(server, callback);
    }

    @Override
    protected void adjustHttpHeader(HttpMethod method) {
    }

    @Override
    protected void preprocessResult(Document doc) throws JDOMException, RemoteApiSessionExpiredException {
    }

    @Override
    protected void preprocessMethodResult(HttpMethod method) {
    }

    @Override
    public void login(String name, char[] aPassword) throws RemoteApiLoginException {
        if (StringUtils.isBlank((String)name) && (aPassword == null || aPassword.length == 0)) {
            this.loggedIn = true;
            this.authToken = null;
            return;
        }
        if (name == null || aPassword == null) {
            throw new RemoteApiLoginException("Corrupted configuration. Username or Password null");
        }
        String loginUrl = String.valueOf(this.getBaseUrl()) + LOGIN_ACTION + "?username=" + UrlUtil.encodeUrl(name) + "&password=" + UrlUtil.encodeUrl(String.valueOf(aPassword));
        try {
            Document doc = this.retrieveGetResponse(loginUrl);
            String exception = FishEyeRestSession.getExceptionMessages(doc);
            if (exception != null) {
                if (exception.contains("maximum")) {
                    throw new CaptchaRequiredException(null);
                }
                throw new RemoteApiLoginFailedException(exception);
            }
            List elements = XPath.newInstance((String)"/response/string").selectNodes((Object)doc);
            if (elements == null || elements.size() == 0) {
                throw new RemoteApiLoginException("Server did not return any authentication token");
            }
            if (elements.size() != 1) {
                throw new RemoteApiLoginException("Server returned unexpected number of authentication tokens (" + elements.size() + ")");
            }
            this.authToken = ((Element)elements.get(0)).getText();
            this.loggedIn = true;
        }
        catch (MalformedURLException e) {
            throw new RemoteApiLoginException("Malformed server URL: " + this.getBaseUrl(), e);
        }
        catch (UnknownHostException e) {
            throw new RemoteApiLoginException("Unknown host: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RemoteApiLoginException(e.getMessage(), e);
        }
        catch (JDOMException e) {
            throw new RemoteApiLoginException(SERVER_RETURNED_MALFORMED_RESPONSE, e);
        }
        catch (RemoteApiSessionExpiredException e) {
            throw new RemoteApiLoginException("Session expired", e);
        }
        catch (IllegalArgumentException e) {
            throw new RemoteApiLoginException("Malformed server URL: " + this.getBaseUrl(), e);
        }
    }

    private static String getExceptionMessages(Document doc) throws JDOMException {
        if (doc.getRootElement() != null && doc.getRootElement().getName().equals("error")) {
            return doc.getRootElement().getText();
        }
        return null;
    }

    @Override
    public void logout() {
        if (!this.isLoggedIn() || this.authToken == null) {
            return;
        }
        try {
            String logoutUrl = String.valueOf(this.getBaseUrl()) + LOGOUT_ACTION + "?auth=" + UrlUtil.encodeUrl(this.authToken);
            this.retrieveGetResponse(logoutUrl);
        }
        catch (IOException e) {
            LoggerImpl.getInstance().error(EXCEPTION_ENCOUNTERED_WHILE_LOGOUT + e.getMessage(), e);
        }
        catch (JDOMException e) {
            LoggerImpl.getInstance().error(EXCEPTION_ENCOUNTERED_WHILE_LOGOUT + e.getMessage(), e);
        }
        catch (RemoteApiSessionExpiredException e) {
            LoggerImpl.getInstance().debug(EXCEPTION_ENCOUNTERED_WHILE_LOGOUT + e.getMessage(), e);
        }
        this.authToken = null;
        this.loggedIn = false;
    }

    @Override
    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public List<String> getRepositories() throws RemoteApiException {
        if (!this.isLoggedIn()) {
            throw new IllegalStateException(CALLING_METHOD_WITHOUT_CALLING_LOGIN_FIRST);
        }
        String requestUrl = String.valueOf(this.getBaseUrl()) + LIST_REPOSITORIES_ACTION;
        try {
            Document doc = this.retrieveGetResponse(requestUrl);
            XPath xpath = XPath.newInstance((String)"/response/string");
            List elements = xpath.selectNodes((Object)doc);
            ArrayList<String> myRepositories = new ArrayList<String>();
            if (elements != null && !elements.isEmpty()) {
                for (Element element : elements) {
                    myRepositories.add(element.getText());
                }
            }
            return myRepositories;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + SERVER_RETURNED_MALFORMED_RESPONSE, e);
        }
    }

    @Override
    public Collection<FisheyePathHistoryItem> getPathHistory(String repo, String path) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            throw new IllegalStateException(CALLING_METHOD_WITHOUT_CALLING_LOGIN_FIRST);
        }
        String requestUrl = String.valueOf(this.getBaseUrl()) + LIST_HISTORY_ACTION + repo + "?path=" + UrlUtil.encodeUrl(path);
        try {
            Document doc = this.retrieveGetResponse(requestUrl);
            XPath xpath = XPath.newInstance((String)"/fileRevisionList");
            List elements = xpath.selectNodes((Object)doc);
            if (elements == null || elements.size() != 1) {
                throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + SERVER_RETURNED_MALFORMED_RESPONSE);
            }
            xpath = XPath.newInstance((String)"/fileRevisionList/fileRevision");
            elements = xpath.selectNodes((Object)doc);
            ArrayList<FisheyePathHistoryItem> list = new ArrayList<FisheyePathHistoryItem>();
            if (elements != null && !elements.isEmpty()) {
                for (Element element : elements) {
                    list.add(new FisheyePathHistoryItem(element));
                }
            }
            return list;
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + SERVER_RETURNED_MALFORMED_RESPONSE, e);
        }
    }

    @Override
    public ChangesetIdList getChangesetList(String repository, String path, Date start, Date end, Integer maxReturn) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            throw new IllegalStateException(CALLING_METHOD_WITHOUT_CALLING_LOGIN_FIRST);
        }
        String requestUrl = String.valueOf(this.getBaseUrl()) + CHANGESET_LIST_ACTION + repository + "?";
        if (path != null) {
            requestUrl = String.valueOf(requestUrl) + "path=" + path + "&";
        }
        if (start != null) {
            requestUrl = String.valueOf(requestUrl) + "start=" + DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(start) + "&";
        }
        if (end != null) {
            requestUrl = String.valueOf(requestUrl) + "end=" + DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(end) + "&";
        }
        if (maxReturn != null) {
            requestUrl = String.valueOf(requestUrl) + "maxReturn=" + maxReturn + "&";
        }
        try {
            Document doc = this.retrieveGetResponse(requestUrl);
            XPath xpath = XPath.newInstance((String)"/changesetIdList");
            List elements = xpath.selectNodes((Object)doc);
            if (elements == null || elements.size() != 1) {
                throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + SERVER_RETURNED_MALFORMED_RESPONSE);
            }
            xpath = XPath.newInstance((String)"/changesetIdList/csid");
            elements = xpath.selectNodes((Object)doc);
            ArrayList<String> list = MiscUtil.buildArrayList();
            if (elements != null && !elements.isEmpty()) {
                for (Element element : elements) {
                    list.add(element.getTextNormalize());
                }
            }
            return new ChangesetIdList(list);
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + SERVER_RETURNED_MALFORMED_RESPONSE, e);
        }
    }

    @Override
    public Changeset getChangeset(String repository, String csid) throws RemoteApiException {
        if (!this.isLoggedIn()) {
            throw new IllegalStateException(CALLING_METHOD_WITHOUT_CALLING_LOGIN_FIRST);
        }
        String requestUrl = String.valueOf(this.getBaseUrl()) + CHANGESET_ACTION + repository + "/" + csid;
        try {
            Document doc = this.retrieveGetResponse(requestUrl);
            XPath xpath = XPath.newInstance((String)"/changeset");
            Element changesetElement = (Element)xpath.selectSingleNode((Object)doc);
            if (changesetElement == null) {
                throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + SERVER_RETURNED_MALFORMED_RESPONSE);
            }
            return this.parseChangeset(changesetElement);
        }
        catch (IOException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            throw new RemoteApiException(String.valueOf(this.getBaseUrl()) + ": " + SERVER_RETURNED_MALFORMED_RESPONSE, e);
        }
    }

    private Changeset parseChangeset(Element changesetElement) {
        String csid = changesetElement.getAttributeValue("csid");
        String author = changesetElement.getAttributeValue("author");
        String comment = CrucibleRestXmlHelper.getChildText(changesetElement, "comment");
        Date date = FishEyeRestSession.parseDateTime(changesetElement.getAttributeValue("date"));
        String branch = changesetElement.getAttributeValue("branch");
        ArrayList<FileRevisionKey> keys = MiscUtil.buildArrayList();
        for (Element element : XmlUtil.getChildElements(changesetElement, "fileRevisionKey")) {
            keys.add(this.parseFileRevisionKey(element));
        }
        return new Changeset(date, csid, branch, author, comment, keys);
    }

    private FileRevisionKey parseFileRevisionKey(Element element) {
        return new FileRevisionKey(element.getAttributeValue("rev"), element.getAttributeValue("path"));
    }

    public static Date parseDateTime(String date) {
        if (date != null && !date.equals("")) {
            try {
                return CHANGESET_TIME_FORMAT.parseDateTime(date).toDate();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return CHANGESET1_TIME_FORMAT.parseDateTime(date).toDate();
            }
        }
        return null;
    }
}

