/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.commons.jira;

import com.atlassian.connector.commons.FieldValueGeneratorFactory;
import com.atlassian.connector.commons.jira.FieldValueGenerator;
import com.atlassian.connector.commons.jira.JIRAActionField;
import com.atlassian.connector.commons.jira.JIRAIssue;
import com.atlassian.connector.commons.jira.beans.AbstractJIRAConstantBean;
import com.atlassian.jira.rest.client.domain.input.FieldInput;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JIRAActionFieldBean
extends AbstractJIRAConstantBean
implements JIRAActionField {
    private String fieldId;
    private List<String> fieldValues = new ArrayList<String>();
    private static FieldValueGeneratorFactory generatorFactory;

    public JIRAActionFieldBean(String fieldId, String name) {
        super(fieldId.hashCode(), name, null);
        this.fieldId = fieldId;
    }

    public JIRAActionFieldBean(JIRAActionField other) {
        this(other.getFieldId(), other.getName());
    }

    public static void setGeneratorFactory(FieldValueGeneratorFactory generatorFactory) {
        JIRAActionFieldBean.generatorFactory = generatorFactory;
    }

    @Override
    public String getFieldId() {
        return this.fieldId;
    }

    @Override
    public void addValue(String val) {
        this.fieldValues.add(val);
    }

    @Override
    public List<String> getValues() {
        return this.fieldValues;
    }

    @Override
    public void setValues(List<String> values) {
        this.fieldValues = values;
    }

    @Override
    public String getQueryStringFragment() {
        return String.valueOf(this.fieldId) + "=";
    }

    @Override
    public JIRAActionFieldBean getClone() {
        return new JIRAActionFieldBean(this);
    }

    @Override
    public FieldInput generateFieldValue(JIRAIssue issue, JSONObject fieldDef) throws JSONException, RemoteApiException {
        if (generatorFactory == null) {
            throw new RemoteApiException("Field Value Generator Factory not set");
        }
        FieldValueGenerator generator = generatorFactory.get(this, fieldDef);
        return generator.generateJrJcFieldValue(issue, this, fieldDef);
    }
}

