/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.projectconfig.filters;

import java.util.ArrayList;
import java.util.List;
import net.sf.eclipsecs.core.projectconfig.filters.AbstractFilter;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonSrcDirsFilter
extends AbstractFilter {
    private IProject mCurrentProject;
    private List<IPath> mCurrentSourcePaths;

    @Override
    public boolean accept(Object element) {
        boolean goesThrough = false;
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            IProject project = resource.getProject();
            if (this.mCurrentProject != project) {
                this.mCurrentSourcePaths = this.getSourceDirPaths(project);
                this.mCurrentProject = project;
            }
            for (IPath sourcePath : this.mCurrentSourcePaths) {
                if (!sourcePath.isPrefixOf(resource.getFullPath())) continue;
                goesThrough = true;
                break;
            }
        }
        return goesThrough;
    }

    private List<IPath> getSourceDirPaths(IProject project) {
        ArrayList<IPath> sourceDirs = new ArrayList<IPath>();
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IClasspathEntry[] cp = javaProject.getResolvedClasspath(true);
                int i = 0;
                while (i < cp.length) {
                    if (cp[i].getEntryKind() == 3) {
                        sourceDirs.add(cp[i].getPath());
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException e) {
            CheckstyleLog.log(e);
        }
        catch (CoreException e) {
            CheckstyleLog.log(e);
        }
        return sourceDirs;
    }
}

