/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.sf.eclipsecs.core.CheckstylePlugin;
import net.sf.eclipsecs.core.Messages;
import net.sf.eclipsecs.core.config.CheckConfiguration;
import net.sf.eclipsecs.core.config.GlobalCheckConfigurationWorkingSet;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.ICheckConfigurationWorkingSet;
import net.sf.eclipsecs.core.config.ResolvableProperty;
import net.sf.eclipsecs.core.config.configtypes.ConfigurationTypes;
import net.sf.eclipsecs.core.config.configtypes.IConfigurationType;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ObjectUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CheckConfigurationFactory {
    protected static final String CHECKSTYLE_CONFIG_FILE = "checkstyle-config.xml";
    private static final String VERSION_5_0_0 = "5.0.0";
    protected static final String CURRENT_CONFIG_FILE_FORMAT_VERSION = "5.0.0";
    private static final String CONFIGS_EXTENSION_POINT = "net.sf.eclipsecs.core.configurations";
    private static List<ICheckConfiguration> sConfigurations = Collections.synchronizedList(new ArrayList());
    private static ICheckConfiguration sDefaultCheckConfig;

    static {
        CheckConfigurationFactory.refresh();
    }

    private CheckConfigurationFactory() {
    }

    public static ICheckConfiguration getByName(String name) {
        for (ICheckConfiguration config : sConfigurations) {
            if (!config.getName().equals(name)) continue;
            return config;
        }
        return null;
    }

    public static List<ICheckConfiguration> getCheckConfigurations() {
        return Collections.unmodifiableList(sConfigurations);
    }

    public static ICheckConfiguration getDefaultCheckConfiguration() {
        if (sDefaultCheckConfig != null) {
            return sDefaultCheckConfig;
        }
        if (sConfigurations.size() > 0) {
            return sConfigurations.get(0);
        }
        return null;
    }

    public static ICheckConfigurationWorkingSet newWorkingSet() {
        return new GlobalCheckConfigurationWorkingSet(sConfigurations, CheckConfigurationFactory.getDefaultCheckConfiguration());
    }

    public static void refresh() {
        try {
            sConfigurations.clear();
            CheckConfigurationFactory.loadBuiltinConfigurations();
            CheckConfigurationFactory.loadFromPersistence();
        }
        catch (CheckstylePluginException e) {
            CheckstyleLog.log(e);
        }
    }

    public static void copyConfiguration(ICheckConfiguration source, ICheckConfiguration target) throws CheckstylePluginException {
        File sourceFile;
        File targetFile = FileUtils.toFile((URL)target.getResolvedConfigurationFileURL());
        if (ObjectUtils.equals((Object)targetFile, (Object)(sourceFile = FileUtils.toFile((URL)source.getResolvedConfigurationFileURL())))) {
            return;
        }
        CheckConfigurationFactory.exportConfiguration(targetFile, source);
    }

    public static void exportConfiguration(File file, ICheckConfiguration config) throws CheckstylePluginException {
        block5: {
            ByteArrayInputStream in = null;
            BufferedOutputStream out = null;
            try {
                try {
                    in = config.getCheckstyleConfiguration().getCheckConfigFileStream();
                    out = new BufferedOutputStream(new FileOutputStream(file));
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                catch (Exception e) {
                    CheckstylePluginException.rethrow(e);
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly(out);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    private static void loadFromPersistence() throws CheckstylePluginException {
        block12: {
            Element root;
            BufferedInputStream inStream;
            block11: {
                File configFile;
                block10: {
                    inStream = null;
                    IPath configPath = CheckstylePlugin.getDefault().getStateLocation();
                    configPath = configPath.append(CHECKSTYLE_CONFIG_FILE);
                    configFile = configPath.toFile();
                    if (configFile.exists()) break block10;
                    IOUtils.closeQuietly(inStream);
                    return;
                }
                inStream = new BufferedInputStream(new FileInputStream(configFile));
                SAXReader reader = new SAXReader();
                Document document = reader.read((InputStream)inStream);
                root = document.getRootElement();
                String version = root.attributeValue("file-format-version");
                if ("5.0.0".equals(version)) break block11;
                CheckstyleLog.log(null, "eclipse-cs version 3.x type configuration files are not supported anymore.");
                IOUtils.closeQuietly((InputStream)inStream);
                return;
            }
            try {
                String defaultConfigName = root.attributeValue("default-check-configuration");
                sConfigurations.addAll(CheckConfigurationFactory.getGlobalCheckConfigurations(root));
                for (ICheckConfiguration config : sConfigurations) {
                    if (!config.getName().equals(defaultConfigName)) continue;
                    sDefaultCheckConfig = config;
                }
            }
            catch (IOException e) {
                CheckstylePluginException.rethrow(e, Messages.errorLoadingConfigFile);
                IOUtils.closeQuietly(inStream);
                break block12;
            }
            catch (DocumentException e) {
                try {
                    CheckstylePluginException.rethrow(e, Messages.errorLoadingConfigFile);
                    break block12;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IOUtils.closeQuietly(inStream);
                }
            }
            IOUtils.closeQuietly((InputStream)inStream);
        }
    }

    private static void loadBuiltinConfigurations() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = pluginRegistry.getConfigurationElementsFor(CONFIGS_EXTENSION_POINT);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement[] propEls;
            String name = elements[i].getAttribute("name");
            String description = elements[i].getAttribute("description");
            String location = elements[i].getAttribute("location");
            IConfigurationType configType = ConfigurationTypes.getByInternalName("builtin");
            HashMap<String, String> additionalData = new HashMap<String, String>();
            additionalData.put("contributor", elements[i].getContributor().getName());
            ArrayList<ResolvableProperty> props = new ArrayList<ResolvableProperty>();
            IConfigurationElement[] iConfigurationElementArray = propEls = elements[i].getChildren("property");
            int n = propEls.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement propEl = iConfigurationElementArray[n2];
                props.add(new ResolvableProperty(propEl.getAttribute("name"), propEl.getAttribute("value")));
                ++n2;
            }
            CheckConfiguration checkConfig = new CheckConfiguration(name, location, description, configType, true, props, additionalData);
            sConfigurations.add(checkConfig);
            ++i;
        }
    }

    private static List<ICheckConfiguration> getGlobalCheckConfigurations(Element root) {
        ArrayList<ICheckConfiguration> configs = new ArrayList<ICheckConfiguration>();
        List configElements = root.elements("check-configuration");
        for (Element configEl : configElements) {
            String name = configEl.attributeValue("name");
            String description = configEl.attributeValue("description");
            String location = configEl.attributeValue("location");
            String type = configEl.attributeValue("type");
            IConfigurationType configType = ConfigurationTypes.getByInternalName(type);
            ArrayList<ResolvableProperty> props = new ArrayList<ResolvableProperty>();
            List propertiesElements = configEl.elements("property");
            for (Element propsEl : propertiesElements) {
                ResolvableProperty prop = new ResolvableProperty(propsEl.attributeValue("name"), propsEl.attributeValue("value"));
                props.add(prop);
            }
            HashMap<String, String> additionalData = new HashMap<String, String>();
            List dataElements = configEl.elements("additional-data");
            for (Element dataEl : dataElements) {
                additionalData.put(dataEl.attributeValue("name"), dataEl.attributeValue("value"));
            }
            CheckConfiguration checkConfig = new CheckConfiguration(name, location, description, configType, true, props, additionalData);
            configs.add(checkConfig);
        }
        return configs;
    }
}

