/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public class LineLengthExtendedCheck
extends Check {
    private static final int DEFAULT_MAX_COLUMNS = 80;
    private int mMax = 80;
    private Pattern mIgnorePattern;
    private String[] mLines;
    private boolean mIgnoreField;
    private boolean mIgnoreMethod;
    private boolean mIgnoreConstructor;
    private boolean mIgnoreClass;

    public void setIgnoreField(boolean aValue) {
        this.mIgnoreField = aValue;
    }

    public void setIgnoreMethod(boolean aValue) {
        this.mIgnoreMethod = aValue;
    }

    public void setIgnoreConstructor(boolean aValue) {
        this.mIgnoreConstructor = aValue;
    }

    public void setIgnoreClass(boolean aValue) {
        this.mIgnoreClass = aValue;
    }

    public LineLengthExtendedCheck() {
        this.setIgnorePattern("^$");
    }

    public int[] getDefaultTokens() {
        ArrayList<Integer> tokens = new ArrayList<Integer>();
        if (this.mIgnoreClass) {
            tokens.add(14);
        }
        if (this.mIgnoreConstructor) {
            tokens.add(8);
        }
        if (this.mIgnoreField) {
            tokens.add(10);
        }
        if (this.mIgnoreMethod) {
            tokens.add(9);
        }
        int[] returnTokens = new int[tokens.size()];
        for (int index = 0; index < tokens.size(); ++index) {
            returnTokens[index] = (Integer)tokens.get(index);
        }
        return returnTokens;
    }

    public void visitToken(DetailAST aAST) {
        DetailAST endOfIgnoreLine = aAST.findFirstToken(7);
        if (null != aAST.getParent() && aAST.getParent().getType() == 6 || aAST.getType() == 14) {
            int mNumberOfLine = aAST.getLineNo();
            if (null == endOfIgnoreLine) {
                this.mLines[mNumberOfLine - 1] = null;
            } else {
                for (int mEndNumberOfLine = endOfIgnoreLine.getLineNo(); mEndNumberOfLine >= mNumberOfLine; --mEndNumberOfLine) {
                    this.mLines[mEndNumberOfLine - 1] = null;
                }
            }
        }
    }

    public void beginTree(DetailAST aRootAST) {
        this.mLines = this.getLines();
    }

    public void finishTree(DetailAST aRootAST) {
        for (int i = 0; i < this.mLines.length; ++i) {
            String line;
            int realLength;
            if (null == this.mLines[i] || (realLength = Utils.lengthExpandedTabs((String)(line = this.mLines[i]), (int)line.length(), (int)this.getTabWidth())) <= this.mMax || this.mIgnorePattern.matcher(line).find()) continue;
            this.log(i + 1, "maxLineLen", new Object[]{this.mMax});
        }
    }

    public void setMax(int aLength) {
        this.mMax = aLength;
    }

    public void setIgnorePattern(String aFormat) throws ConversionException {
        try {
            this.mIgnorePattern = Utils.getPattern((String)aFormat);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, (Throwable)e);
        }
    }
}

