/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.design;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildBlockLengthCheck
extends Check {
    private static final double PERCENTS_FACTOR = 100.0;
    private static final String MSG_KEY = "child.block.length";
    private static final double DEFAULT_MAX_CHILD_BLOCK_PERCENTAGE = 80.0;
    private static final int DEFAULT_IGNORE_BLOCK_LINESCOUNT = 50;
    private int[] mBlockTypes;
    private double mMaxChildBlockPercentage = 80.0;
    private int mIgnoreBlockLinesCount = 50;

    public void setBlockTypes(String[] aBlockTypes) {
        this.mBlockTypes = new int[aBlockTypes.length];
        for (int i = 0; i < aBlockTypes.length; ++i) {
            this.mBlockTypes[i] = TokenTypes.getTokenId((String)aBlockTypes[i]);
        }
    }

    public void setMaxChildBlockPercentage(int aMaxChildBlockPercentage) {
        this.mMaxChildBlockPercentage = aMaxChildBlockPercentage;
    }

    public void setIgnoreBlockLinesCount(int aIgnoreBlockLinesCount) {
        this.mIgnoreBlockLinesCount = aIgnoreBlockLinesCount;
    }

    public int[] getDefaultTokens() {
        return this.mBlockTypes;
    }

    public void visitToken(DetailAST aAst) {
        block4: {
            DetailAST aClosingBrace;
            int parentBlockSize;
            DetailAST aOpeningBrace = ChildBlockLengthCheck.openingBrace(aAst);
            if (aOpeningBrace == null || (parentBlockSize = ChildBlockLengthCheck.linesCount(aOpeningBrace, aClosingBrace = ChildBlockLengthCheck.closingBrace(aAst))) <= this.mIgnoreBlockLinesCount) break block4;
            List<DetailAST> childBlocks = this.getChildBlocks(aOpeningBrace, aClosingBrace);
            List<DetailAST> badChildBlocks = this.getBadChildBlocks(childBlocks, parentBlockSize);
            if (badChildBlocks.size() == 0) {
                for (DetailAST childBlock : childBlocks) {
                    this.visitToken(childBlock);
                }
            } else {
                for (DetailAST badBlock : badChildBlocks) {
                    int blockSize = ChildBlockLengthCheck.linesCount(badBlock);
                    double allowedBlockSize = (int)((double)parentBlockSize * this.mMaxChildBlockPercentage / 100.0);
                    this.log(badBlock, MSG_KEY, new Object[]{blockSize, allowedBlockSize});
                }
            }
        }
    }

    private List<DetailAST> getChildBlocks(DetailAST aBlockOpeningBrace, DetailAST aBlockClosingBrace) {
        LinkedList childBlocks = Lists.newLinkedList();
        DetailAST curNode = aBlockOpeningBrace;
        while (curNode != null && curNode != aBlockClosingBrace) {
            if (this.isAllowedBlockType(curNode.getType())) {
                childBlocks.add(curNode);
            }
            DetailAST nextNode = curNode.getFirstChild();
            int type = curNode.getType();
            if (type == 9 || type == 14) {
                nextNode = curNode.getNextSibling();
            }
            while (curNode != null && nextNode == null) {
                nextNode = curNode.getNextSibling();
                if (nextNode != null) continue;
                curNode = curNode.getParent();
            }
            curNode = nextNode;
        }
        return childBlocks;
    }

    private boolean isAllowedBlockType(int aBlockType) {
        boolean result = false;
        for (int type : this.mBlockTypes) {
            if (type != aBlockType) continue;
            result = true;
            break;
        }
        return result;
    }

    private List<DetailAST> getBadChildBlocks(List<DetailAST> aBlocksList, int aParentBlockSize) {
        LinkedList<DetailAST> result = new LinkedList<DetailAST>();
        for (DetailAST block : aBlocksList) {
            if (!this.isChildBlockBad(block, aParentBlockSize)) continue;
            result.add(block);
        }
        return result;
    }

    private boolean isChildBlockBad(DetailAST aChildBlock, int aParentBlockSize) {
        boolean result = false;
        DetailAST openingBrace = ChildBlockLengthCheck.openingBrace(aChildBlock);
        if (openingBrace != null) {
            DetailAST closingBrace = ChildBlockLengthCheck.closingBrace(aChildBlock);
            int childBlockSize = ChildBlockLengthCheck.linesCount(openingBrace, closingBrace);
            result = this.getPercentage(aParentBlockSize, childBlockSize);
        }
        return result;
    }

    private boolean getPercentage(int aParentBlockSize, int aChildBlockSize) {
        double percentage = (double)aChildBlockSize / (double)aParentBlockSize * 100.0;
        return percentage > this.mMaxChildBlockPercentage;
    }

    private static DetailAST openingBrace(DetailAST aParentBlock) {
        return aParentBlock.getType() == 89 ? aParentBlock.findFirstToken(72) : aParentBlock.findFirstToken(7);
    }

    private static DetailAST closingBrace(DetailAST aParentBlockNode) {
        int aParentBlockType = aParentBlockNode.getType();
        return aParentBlockType == 89 ? aParentBlockNode.getLastChild() : ChildBlockLengthCheck.openingBrace(aParentBlockNode).getLastChild();
    }

    private static int linesCount(DetailAST aBlockAst) {
        return ChildBlockLengthCheck.linesCount(ChildBlockLengthCheck.openingBrace(aBlockAst), ChildBlockLengthCheck.closingBrace(aBlockAst));
    }

    private static int linesCount(DetailAST aOpeningBrace, DetailAST aClosingBrace) {
        int result = aClosingBrace.getLineNo() - aOpeningBrace.getLineNo();
        if (result != 0) {
            --result;
        }
        return result;
    }
}

