/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoNullForCollectionReturnCheck
extends Check {
    private static final String DEFAULT_COLLECTIONS = "AbstractCollection AbstractList AbstractQueue AbstractSequentialList AbstractSet ArrayBlockingQueue ArrayDeque ArrayList AttributeList BeanContextServicesSupport BeanContextSupport ConcurrentLinkedDeque ConcurrentLinkedQueue ConcurrentSkipListSet CopyOnWriteArrayList CopyOnWriteArraySet DelayQueue EnumSet HashSet JobStateReasons LinkedBlockingDeque LinkedBlockingQueue LinkedHashSet LinkedList LinkedTransferQueue PriorityBlockingQueue PriorityQueue RoleList RoleUnresolvedList Stack SynchronousQueue TreeSet Vector Collection List Map Set";
    private HashSet<String> mCollectionList = new HashSet();
    private boolean mSearchThroughMethodBody = false;
    private LinkedList<DetailAST> mMethodDefs = new LinkedList();

    public NoNullForCollectionReturnCheck() {
        this.setCollectionList(DEFAULT_COLLECTIONS);
    }

    public void setCollectionList(String aCollectionList) {
        this.mCollectionList.clear();
        for (String currentCollection : aCollectionList.split("\\s+")) {
            this.mCollectionList.add(currentCollection);
        }
    }

    public void setSearchThroughMethodBody(boolean aSearchThroughMethodBody) {
        this.mSearchThroughMethodBody = aSearchThroughMethodBody;
    }

    public int[] getDefaultTokens() {
        return new int[]{9, 88};
    }

    public void beginTree(DetailAST aRootAST) {
        this.mMethodDefs.clear();
    }

    public void visitToken(DetailAST aDetailAST) {
        switch (aDetailAST.getType()) {
            case 9: {
                if (!this.isReturnCollection(aDetailAST)) break;
                this.mMethodDefs.push(aDetailAST);
                break;
            }
            case 88: {
                DetailAST currentMethodDef;
                if (this.mMethodDefs.isEmpty() || !this.mMethodDefs.contains(currentMethodDef = NoNullForCollectionReturnCheck.getMethodDef(aDetailAST)) || !NoNullForCollectionReturnCheck.hasNullLiteralInReturn(aDetailAST) && (!this.mSearchThroughMethodBody || !NoNullForCollectionReturnCheck.isReturnedValueBeNull(aDetailAST))) break;
                this.log(aDetailAST.getLineNo(), "no.null.for.collections", new Object[0]);
            }
        }
    }

    private boolean isReturnCollection(DetailAST aMethodDef) {
        DetailAST methodType = aMethodDef.findFirstToken(13);
        return (methodType = methodType.getFirstChild()).getType() == 17 || this.mCollectionList.contains(methodType.getText());
    }

    private static boolean hasNullLiteralInReturn(DetailAST aReturnLit) {
        DetailAST returnExpression = aReturnLit.findFirstToken(28);
        boolean result = false;
        if (returnExpression != null) {
            DetailAST ternary = returnExpression.getFirstChild();
            if (109 == ternary.getType()) {
                returnExpression = ternary;
            }
            result = returnExpression.getChildCount(135) > 0;
        }
        return result;
    }

    private static boolean isReturnedValueBeNull(DetailAST aReturnLit) {
        DetailAST variable;
        boolean result = false;
        DetailAST returnedExpression = aReturnLit.getFirstChild();
        if (returnedExpression.getType() != 45 && (variable = returnedExpression.findFirstToken(58)) != null) {
            String variableName = variable.getText();
            DetailAST methodDef = NoNullForCollectionReturnCheck.getMethodDef(aReturnLit);
            LinkedList<DetailAST> subblocks = NoNullForCollectionReturnCheck.getAllSubblocks(methodDef);
            subblocks.addFirst(methodDef);
            result = NoNullForCollectionReturnCheck.hasNullInDefinition(subblocks, variableName);
            if (result) {
                for (DetailAST subblock : subblocks) {
                    List<DetailAST> expressions = NoNullForCollectionReturnCheck.getChildren(NoNullForCollectionReturnCheck.getBlockBody(subblock), 28);
                    for (DetailAST expression : expressions) {
                        DetailAST assign = expression.findFirstToken(80);
                        if (assign == null || !variableName.equals(assign.findFirstToken(58).getText()) || assign.branchContains(135)) continue;
                        result = false;
                        break;
                    }
                    if (result) continue;
                    break;
                }
            }
        }
        return result;
    }

    private static LinkedList<DetailAST> getAllSubblocks(DetailAST aBlockDef) {
        DetailAST blockBody = NoNullForCollectionReturnCheck.getBlockBody(aBlockDef);
        LinkedList<DetailAST> subblocks = new LinkedList<DetailAST>();
        subblocks.addAll(NoNullForCollectionReturnCheck.getChildren(blockBody, 83));
        LinkedList<DetailAST> elseBlocks = new LinkedList<DetailAST>();
        for (DetailAST currentIf : subblocks) {
            if (currentIf.getChildCount(92) <= 0) continue;
            elseBlocks.add(currentIf.findFirstToken(92));
        }
        if (!elseBlocks.isEmpty()) {
            subblocks.addAll(elseBlocks);
        }
        subblocks.addAll(NoNullForCollectionReturnCheck.getChildren(blockBody, 84));
        subblocks.addAll(NoNullForCollectionReturnCheck.getChildren(blockBody, 85));
        subblocks.addAll(NoNullForCollectionReturnCheck.getChildren(blockBody, 91));
        subblocks.addAll(NoNullForCollectionReturnCheck.getChildren(blockBody, 95));
        LinkedList<DetailAST> nestedSubblocks = new LinkedList<DetailAST>();
        for (DetailAST currentSubblock : subblocks) {
            if (!currentSubblock.branchContains(7)) continue;
            nestedSubblocks.addAll(NoNullForCollectionReturnCheck.getAllSubblocks(currentSubblock));
        }
        subblocks.addAll(nestedSubblocks);
        return subblocks;
    }

    private static boolean hasNullInDefinition(List<DetailAST> aSubblocks, String aVariableName) {
        boolean result = false;
        for (DetailAST subblock : aSubblocks) {
            List<DetailAST> variableDefs = NoNullForCollectionReturnCheck.getChildren(NoNullForCollectionReturnCheck.getBlockBody(subblock), 10);
            boolean isFinded = false;
            for (DetailAST currentDef : variableDefs) {
                DetailAST variable = currentDef.findFirstToken(58);
                if (!aVariableName.equals(variable.getText())) continue;
                DetailAST variableDef = currentDef;
                DetailAST variableValue = variableDef.findFirstToken(80);
                result = variableValue != null ? (variableValue = variableValue.findFirstToken(28)).getFirstChild().getType() == 135 : true;
                isFinded = true;
                break;
            }
            if (!isFinded) continue;
            break;
        }
        return result;
    }

    private static List<DetailAST> getChildren(DetailAST aRoot, int aType) {
        LinkedList<DetailAST> children = new LinkedList<DetailAST>();
        DetailAST currentChild = aRoot.findFirstToken(aType);
        if (currentChild != null) {
            children.add(currentChild);
        }
        while (children.size() < aRoot.getChildCount(aType)) {
            if ((currentChild = currentChild.getNextSibling()).getType() != aType) continue;
            children.add(currentChild);
        }
        return children;
    }

    private static DetailAST getMethodDef(DetailAST aReturnLit) {
        DetailAST methodDef = aReturnLit;
        while (methodDef.getType() != 9) {
            methodDef = methodDef.getParent();
        }
        return methodDef;
    }

    private static DetailAST getBlockBody(DetailAST aBlockDef) {
        DetailAST blockBody = aBlockDef.findFirstToken(7);
        if (blockBody == null) {
            blockBody = aBlockDef;
        }
        return blockBody;
    }
}

