/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class MultipleStringLiteralsExtendedCheck
extends Check {
    private final Map<String, List<StringInfo>> mStringMap = Maps.newHashMap();
    private final BitSet mIgnoreOccurrenceContext = new BitSet();
    private int mAllowedDuplicates = 1;
    private boolean mHighlightAllDuplicates = false;
    private Pattern mPattern;

    public void setAllowedDuplicates(int aAllowedDuplicates) {
        this.mAllowedDuplicates = aAllowedDuplicates;
    }

    public MultipleStringLiteralsExtendedCheck() {
        this.setIgnoreStringsRegexp("^\"\"$");
        this.mIgnoreOccurrenceContext.set(159);
    }

    public void setIgnoreStringsRegexp(String aIgnoreStringsRegexp) {
        this.mPattern = aIgnoreStringsRegexp != null && aIgnoreStringsRegexp.length() > 0 ? Utils.getPattern((String)aIgnoreStringsRegexp) : null;
    }

    public final void setHighlightAllDuplicates(boolean aHighlightAllDuplicates) {
        this.mHighlightAllDuplicates = aHighlightAllDuplicates;
    }

    public final void setIgnoreOccurrenceContext(String[] aStrRep) {
        this.mIgnoreOccurrenceContext.clear();
        for (String s : aStrRep) {
            int type = TokenTypes.getTokenId((String)s);
            this.mIgnoreOccurrenceContext.set(type);
        }
    }

    public int[] getDefaultTokens() {
        return new int[]{139};
    }

    public void visitToken(DetailAST aAST) {
        if (this.isInIgnoreOccurrenceContext(aAST)) {
            return;
        }
        String currentString = aAST.getText();
        if (this.mPattern == null || !this.mPattern.matcher(currentString).find()) {
            ArrayList hitList = this.mStringMap.get(currentString);
            if (hitList == null) {
                hitList = Lists.newArrayList();
                this.mStringMap.put(currentString, hitList);
            }
            int line = aAST.getLineNo();
            int col = aAST.getColumnNo();
            hitList.add(new StringInfo(line, col));
        }
    }

    private boolean isInIgnoreOccurrenceContext(DetailAST aAST) {
        DetailAST token = aAST;
        while (token.getParent() != null) {
            int type = token.getType();
            if (this.mIgnoreOccurrenceContext.get(type)) {
                return true;
            }
            token = token.getParent();
        }
        return false;
    }

    public void beginTree(DetailAST aRootAST) {
        super.beginTree(aRootAST);
        this.mStringMap.clear();
    }

    public void finishTree(DetailAST aRootAST) {
        Set<String> keys = this.mStringMap.keySet();
        for (String key : keys) {
            List<StringInfo> hits = this.mStringMap.get(key);
            if (hits.size() <= this.mAllowedDuplicates) continue;
            int hitsSize = 1;
            if (this.mHighlightAllDuplicates) {
                hitsSize = hits.size();
            }
            for (int index = 0; index < hitsSize; ++index) {
                StringInfo firstFinding = hits.get(index);
                int line = firstFinding.getLine();
                int col = firstFinding.getCol();
                this.log(line, col, "multiple.string.literal", new Object[]{key, hits.size()});
            }
        }
    }

    private static final class StringInfo {
        private final int mLine;
        private final int mCol;

        private StringInfo(int aLine, int aCol) {
            this.mLine = aLine;
            this.mCol = aCol;
        }

        private int getLine() {
            return this.mLine;
        }

        private int getCol() {
            return this.mCol;
        }
    }
}

