/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class EitherLogOrThrowCheck
extends Check {
    public static final String MSG_KEY = "either.log.or.throw";
    private String mLoggerFullyQualifiedClassName = "org.slf4j.Logger";
    private String mLoggerSimpleClassName = "Logger";
    private List<String> mLoggingMethodNames = Arrays.asList("error", "warn", "info", "debug");
    private List<String> mLoggerFieldNames = new LinkedList<String>();
    private boolean mHasLoggerClassInImports;
    private static final Pattern PRINT_STACK_TRACE_METHOD_PATTERN = Pattern.compile(".+\\.printStackTrace");
    private DetailAST mCurrentClassDefAst;
    private DetailAST mCurrentMethodDefAst;
    private List<String> mCurrentLocalLoggerVariableNames = new ArrayList<String>();

    public void setLoggerFullyQualifiedClassName(String aLoggerFullyQualifiedClassName) {
        this.mLoggerSimpleClassName = this.mLoggerFullyQualifiedClassName = aLoggerFullyQualifiedClassName;
        int lastDotIndex = this.mLoggerFullyQualifiedClassName.lastIndexOf(46);
        if (lastDotIndex != -1) {
            this.mLoggerSimpleClassName = this.mLoggerFullyQualifiedClassName.substring(lastDotIndex + 1);
        }
    }

    public void setLoggingMethodNames(String[] aLoggingMethodNames) {
        this.mLoggingMethodNames = Arrays.asList(aLoggingMethodNames);
    }

    public int[] getDefaultTokens() {
        return new int[]{30, 14, 96, 10, 9};
    }

    public void visitToken(DetailAST aAst) {
        switch (aAst.getType()) {
            case 30: {
                if (this.mHasLoggerClassInImports || !this.isLoggerImport(aAst)) break;
                this.mHasLoggerClassInImports = true;
                break;
            }
            case 14: {
                if (this.isInnerClass(aAst)) break;
                this.mCurrentClassDefAst = aAst;
                this.collectLoggerFieldNames(aAst);
                break;
            }
            case 9: {
                if (!this.isMethodOfCurrentClass(aAst)) break;
                this.mCurrentMethodDefAst = aAst;
                this.mCurrentLocalLoggerVariableNames.clear();
                DetailAST parametersAst = this.mCurrentMethodDefAst.findFirstToken(20);
                this.collectLoggersFromParameters(parametersAst);
                break;
            }
            case 10: {
                DetailAST methodDefAst = aAst.getParent().getParent();
                if (methodDefAst.getType() != 9 || methodDefAst != this.mCurrentMethodDefAst || !this.isLoggerVariableDefinition(aAst)) break;
                this.mCurrentLocalLoggerVariableNames.add(EitherLogOrThrowCheck.getIdentifier(aAst));
                break;
            }
            case 96: {
                this.processCatchNode(aAst);
                break;
            }
            default: {
                throw new IllegalArgumentException("Non-correct AST node.");
            }
        }
    }

    private boolean isLoggerImport(DetailAST aImportAst) {
        String importIdentifier = FullIdent.createFullIdent((DetailAST)aImportAst.getFirstChild()).getText();
        return this.mLoggerFullyQualifiedClassName.equals(importIdentifier);
    }

    private boolean isInnerClass(DetailAST aClassDefAst) {
        boolean result = false;
        for (DetailAST parentAst = aClassDefAst.getParent(); parentAst != null; parentAst = parentAst.getParent()) {
            if (parentAst != this.mCurrentClassDefAst) continue;
            result = true;
            break;
        }
        return result;
    }

    private void collectLoggersFromParameters(DetailAST aParametersAst) {
        for (DetailAST currentParameterAst = aParametersAst.findFirstToken(21); currentParameterAst != null; currentParameterAst = currentParameterAst.getNextSibling()) {
            DetailAST parameterTypeAst = currentParameterAst.findFirstToken(13);
            String className = EitherLogOrThrowCheck.getIdentifier(parameterTypeAst);
            if (className == null || !this.isLoggerClassName(className)) continue;
            this.mCurrentLocalLoggerVariableNames.add(EitherLogOrThrowCheck.getIdentifier(currentParameterAst));
        }
    }

    private boolean isMethodOfCurrentClass(DetailAST aMethodDefAst) {
        DetailAST classDefAst = aMethodDefAst.getParent().getParent();
        return classDefAst == this.mCurrentClassDefAst;
    }

    private void collectLoggerFieldNames(DetailAST aClassDefAst) {
        DetailAST objBlockAst = aClassDefAst.findFirstToken(6);
        for (DetailAST variableDefAst = objBlockAst.findFirstToken(10); variableDefAst != null; variableDefAst = variableDefAst.getNextSibling()) {
            if (variableDefAst.getType() != 10 || !this.isLoggerVariableDefinition(variableDefAst)) continue;
            this.mLoggerFieldNames.add(EitherLogOrThrowCheck.getIdentifier(variableDefAst));
        }
    }

    private void processCatchNode(DetailAST aCatchAst) {
        boolean isLoggingExceptionFound = false;
        int loggingExceptionLineNumber = 0;
        LinkedList<String> exceptionVariableNames = new LinkedList<String>();
        String catchParameterName = EitherLogOrThrowCheck.getCatchParameterName(aCatchAst);
        DetailAST statementsAst = aCatchAst.findFirstToken(7);
        block5: for (DetailAST currentStatementAst = statementsAst.getFirstChild(); currentStatementAst != null; currentStatementAst = currentStatementAst.getNextSibling()) {
            switch (currentStatementAst.getType()) {
                case 10: {
                    if (this.isLoggerVariableDefinition(currentStatementAst)) {
                        this.mCurrentLocalLoggerVariableNames.add(EitherLogOrThrowCheck.getIdentifier(currentStatementAst));
                        continue block5;
                    }
                    DetailAST assignAst = currentStatementAst.findFirstToken(80);
                    if (assignAst == null || !EitherLogOrThrowCheck.isInstanceCreationBasedOnException(assignAst.getFirstChild(), catchParameterName)) continue block5;
                    exceptionVariableNames.add(EitherLogOrThrowCheck.getIdentifier(currentStatementAst));
                    continue block5;
                }
                case 28: {
                    if (isLoggingExceptionFound || !this.isLoggingExceptionArgument(currentStatementAst, catchParameterName) && !EitherLogOrThrowCheck.isPrintStackTrace(currentStatementAst, catchParameterName)) continue block5;
                    isLoggingExceptionFound = true;
                    loggingExceptionLineNumber = currentStatementAst.getLineNo();
                    continue block5;
                }
                case 90: {
                    if (!isLoggingExceptionFound) continue block5;
                    exceptionVariableNames.add(catchParameterName);
                    DetailAST thrownExceptionAst = currentStatementAst.getFirstChild();
                    if (!exceptionVariableNames.contains(EitherLogOrThrowCheck.getIdentifier(thrownExceptionAst)) && !EitherLogOrThrowCheck.isInstanceCreationBasedOnException(thrownExceptionAst, catchParameterName)) continue block5;
                    this.log(loggingExceptionLineNumber, MSG_KEY, new Object[0]);
                    continue block5;
                }
            }
        }
    }

    private boolean isLoggerVariableDefinition(DetailAST aVariableDefAst) {
        DetailAST variableTypeAst = aVariableDefAst.findFirstToken(13).getFirstChild();
        String variableTypeName = FullIdent.createFullIdent((DetailAST)variableTypeAst).getText();
        return this.isLoggerClassName(variableTypeName);
    }

    private boolean isLoggerClassName(String aClassName) {
        return this.mHasLoggerClassInImports && aClassName.equals(this.mLoggerSimpleClassName) || aClassName.equals(this.mLoggerFullyQualifiedClassName);
    }

    private static String getCatchParameterName(DetailAST aCatchAst) {
        DetailAST parameterDefAst = aCatchAst.findFirstToken(21);
        return EitherLogOrThrowCheck.getIdentifier(parameterDefAst);
    }

    private static String getIdentifier(DetailAST aAST) {
        DetailAST identAst;
        String result = null;
        if (aAST != null && (identAst = aAST.findFirstToken(58)) != null) {
            result = identAst.getText();
        }
        return result;
    }

    private static boolean isInstanceCreationBasedOnException(DetailAST aExpressionAst, String aExceptionArgumentName) {
        DetailAST parametersAst;
        boolean result = false;
        DetailAST literalNewAst = aExpressionAst.findFirstToken(136);
        if (literalNewAst != null && (parametersAst = literalNewAst.findFirstToken(34)) != null) {
            result = EitherLogOrThrowCheck.containsExceptionParameter(parametersAst, aExceptionArgumentName);
        }
        return result;
    }

    private boolean isLoggingExceptionArgument(DetailAST aExpressionAst, String aExceptionVariableName) {
        boolean result = false;
        if (this.isLoggingExpression(aExpressionAst)) {
            DetailAST loggingMethodCallAst = aExpressionAst.getFirstChild();
            DetailAST loggerParametersAst = loggingMethodCallAst.findFirstToken(34);
            result = EitherLogOrThrowCheck.containsExceptionParameter(loggerParametersAst, aExceptionVariableName);
        }
        return result;
    }

    private boolean isLoggingExpression(DetailAST aExpressionAst) {
        boolean result = false;
        DetailAST methodCallAst = aExpressionAst.getFirstChild();
        if (methodCallAst.getType() == 27 && EitherLogOrThrowCheck.hasChildToken(methodCallAst, 59)) {
            DetailAST dotAst = methodCallAst.getFirstChild();
            DetailAST loggerObjectAst = dotAst.getFirstChild();
            DetailAST invokedMethodAst = loggerObjectAst.getNextSibling();
            String loggerObjectIdentifier = FullIdent.createFullIdent((DetailAST)loggerObjectAst).getText();
            String invokedMethodIdentifier = invokedMethodAst.getText();
            result = (this.mCurrentLocalLoggerVariableNames.contains(loggerObjectIdentifier) || this.mLoggerFieldNames.contains(loggerObjectIdentifier)) && this.mLoggingMethodNames.contains(invokedMethodIdentifier);
        }
        return result;
    }

    private static boolean containsExceptionParameter(DetailAST aParametersAst, String aExceptionVariableName) {
        boolean result = false;
        for (DetailAST parameterAst = aParametersAst.getFirstChild(); parameterAst != null; parameterAst = parameterAst.getNextSibling()) {
            if (aExceptionVariableName.equals(EitherLogOrThrowCheck.getIdentifier(parameterAst))) {
                result = true;
                break;
            }
            DetailAST methodCallAst = parameterAst.getFirstChild();
            if (!EitherLogOrThrowCheck.isInstanceMethodCall(aExceptionVariableName, methodCallAst)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean isPrintStackTrace(DetailAST aExpressionAst, String aExceptionVariableName) {
        String methodCallStr;
        boolean result = false;
        DetailAST methodCallAst = aExpressionAst.getFirstChild();
        if (EitherLogOrThrowCheck.isInstanceMethodCall(aExceptionVariableName, methodCallAst) && PRINT_STACK_TRACE_METHOD_PATTERN.matcher(methodCallStr = FullIdent.createFullIdentBelow((DetailAST)methodCallAst).getText()).matches()) {
            result = true;
        }
        return result;
    }

    private static boolean isInstanceMethodCall(String aUsedInstanseName, DetailAST aMethodCallAst) {
        String usedObjectName;
        String methodCallIdent;
        int firstDotIndex;
        boolean result = false;
        if (aMethodCallAst != null && aMethodCallAst.getType() == 27 && (firstDotIndex = (methodCallIdent = FullIdent.createFullIdentBelow((DetailAST)aMethodCallAst).getText()).indexOf(46)) != -1 && (usedObjectName = methodCallIdent.substring(0, firstDotIndex)).equals(aUsedInstanseName)) {
            result = true;
        }
        return result;
    }

    private static boolean hasChildToken(DetailAST aAST, int aTokenType) {
        return aAST.findFirstToken(aTokenType) != null;
    }
}

