/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.annotation;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ForbidAnnotationCheck
extends Check {
    public static final String MSG_KEY = "annotation.incorrect.target";
    private Set<String> mAnnotationNames = new HashSet<String>();
    private int[] mAnnotationTargets = new int[0];

    public void setAnnotationNames(String[] aNames) {
        if (aNames != null) {
            for (String name : aNames) {
                this.mAnnotationNames.add(name);
            }
        }
    }

    public void setAnnotationTargets(String[] aTargets) {
        if (aTargets != null) {
            this.mAnnotationTargets = new int[aTargets.length];
            for (int i = 0; i < aTargets.length; ++i) {
                this.mAnnotationTargets[i] = TokenTypes.getTokenId((String)aTargets[i]);
            }
            Arrays.sort(this.mAnnotationTargets);
        }
    }

    public int[] getDefaultTokens() {
        return new int[]{159};
    }

    public void visitToken(DetailAST aAnnotation) {
        String annotationName = ForbidAnnotationCheck.getAnnotationName(aAnnotation);
        DetailAST annotationTarget = aAnnotation.getParent().getParent();
        int targetType = annotationTarget.getType();
        if (this.isRequiredAnnotationName(annotationName) && this.isForbiddenAnnotationTarget(targetType)) {
            String currentTarget = annotationTarget.getText();
            this.log(aAnnotation.getLineNo(), MSG_KEY, new Object[]{currentTarget, annotationName});
        }
    }

    private static String getAnnotationName(DetailAST aAnnotation) {
        DetailAST directname = aAnnotation.findFirstToken(58);
        if (directname != null) {
            return directname.getText();
        }
        return aAnnotation.findFirstToken(59).getLastChild().getText();
    }

    private boolean isRequiredAnnotationName(String aAnnotationName) {
        return aAnnotationName != null && this.mAnnotationNames.contains(aAnnotationName);
    }

    private boolean isForbiddenAnnotationTarget(int aTargetType) {
        return Arrays.binarySearch(this.mAnnotationTargets, aTargetType) > -1;
    }
}

