/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.cpd;

import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.TokenEntry;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class CPDViewLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        TreeNode node = (TreeNode)element;
        Object value = node.getValue();
        switch (columnIndex) {
            case 1: {
                if (value instanceof Match) {
                    image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                    break;
                }
                if (!(value instanceof TokenEntry)) break;
                image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OPEN_MARKER");
            }
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        TreeNode node = (TreeNode)element;
        Object value = node.getValue();
        String result = "";
        switch (columnIndex) {
            case 2: {
                if (value instanceof Match) {
                    Match match = (Match)value;
                    StringBuilder buffer = new StringBuilder(50);
                    buffer.append("Found suspect cut & paste (");
                    buffer.append(match.getMarkCount()).append(" matches,");
                    buffer.append(match.getLineCount());
                    if (match.getLineCount() == 1) {
                        buffer.append(" line)");
                    } else {
                        buffer.append(" lines)");
                    }
                    result = buffer.toString();
                    break;
                }
                if (!(value instanceof TokenEntry)) break;
                TokenEntry entry = (TokenEntry)value;
                Match match = (Match)node.getParent().getValue();
                int startLine = entry.getBeginLine();
                int endLine = entry.getBeginLine() + match.getLineCount() - 1;
                IPath path = Path.fromOSString((String)entry.getTokenSrcID());
                StringBuilder buffer = new StringBuilder(100);
                if (startLine == endLine) {
                    buffer.append("line ").append(startLine);
                } else {
                    buffer.append("lines ").append(startLine).append('-').append(endLine);
                }
                buffer.append(" in file ").append(path.lastSegment());
                result = buffer.toString();
                break;
            }
            case 3: {
                if (!(value instanceof TokenEntry)) break;
                TokenEntry entry = (TokenEntry)value;
                IPath path = Path.fromOSString((String)entry.getTokenSrcID());
                IContainer resource = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(path);
                if (resource == null) break;
                result = resource.getProjectRelativePath().removeFileExtension().toString().replace('/', '.');
            }
        }
        return result;
    }
}

