/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.plugin.UISettings;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.ui.LabelProvider;
import net.sourceforge.pmd.eclipse.ui.ShapePicker;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ImplementationType;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleFieldAccessor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleSelection;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleUtil;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleVisitor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.SWTUtil;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.TypeText;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.AbstractRulePanelManager;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.EditorUsageMode;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.RuleTarget;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.rule.XPathRule;
import net.sourceforge.pmd.util.StringUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class RulePanelManager
extends AbstractRulePanelManager {
    private RuleTarget target;
    private Text nameField;
    private TypeText implementationClassField;
    private Combo ruleSetNameField;
    private Button ruleReferenceButton;
    private Combo languageCombo;
    private Combo priorityCombo;
    private ShapePicker priorityDisplay;
    private Label minLanguageLabel;
    private Label maxLanguageLabel;
    private Combo minLanguageVersionCombo;
    private Combo maxLanguageVersionCombo;
    private Combo implementationTypeCombo;
    private Button usesTypeResolutionButton;
    private Button usesDfaButton;
    private List<Label> labels;
    private boolean inSetup;
    private Set<String> currentRuleNames;
    public static final String ID = "rule";
    public static final Comparator<RuleSet> byNameComparator = new Comparator<RuleSet>(){

        @Override
        public int compare(RuleSet rsA, RuleSet rsB) {
            return rsA.getName().compareTo(rsB.getName());
        }
    };

    public RulePanelManager(String theTitle, EditorUsageMode theMode, ValueChangeListener theListener, RuleTarget theRuleSource) {
        this(ID, theTitle, theMode, theListener, theRuleSource);
    }

    public RulePanelManager(String theId, String theTitle, EditorUsageMode theMode, ValueChangeListener theListener, RuleTarget theRuleSource) {
        super(theId, theTitle, theMode, theListener);
        this.target = theRuleSource;
    }

    @Override
    public void showControls(boolean flag) {
        this.nameField.setVisible(flag);
        this.implementationTypeCombo.setVisible(flag);
        this.implementationClassField.setVisible(flag);
        this.ruleSetNameField.setVisible(flag);
        this.languageCombo.setVisible(flag);
        this.priorityCombo.setVisible(flag);
        this.priorityDisplay.setVisible(flag);
        this.minLanguageVersionCombo.setVisible(flag);
        this.maxLanguageVersionCombo.setVisible(flag);
        this.usesDfaButton.setVisible(flag);
        this.usesTypeResolutionButton.setVisible(flag);
        for (Label label : this.labels) {
            label.setVisible(flag);
        }
    }

    @Override
    protected void clearControls() {
        this.nameField.setText("");
        this.ruleSetNameField.select(-1);
        this.implementationClassField.setType(null);
        this.ruleSetNameField.setText("");
        this.languageCombo.select(-1);
        this.priorityCombo.select(-1);
        this.priorityDisplay.setItems(null);
        this.usesDfaButton.setSelection(false);
        this.usesTypeResolutionButton.setSelection(false);
        this.clearLanguageVersionCombos();
    }

    private void clearLanguageVersionCombos() {
        SWTUtil.deselectAll(this.minLanguageVersionCombo);
        SWTUtil.deselectAll(this.maxLanguageVersionCombo);
    }

    private void showLanguageVersionFields(Language language) {
        int versionCount = language == null ? 0 : language.getVersions().size();
        boolean hasVersions = versionCount > 1;
        this.minLanguageLabel.setVisible(hasVersions);
        this.maxLanguageLabel.setVisible(hasVersions);
        this.minLanguageVersionCombo.setVisible(hasVersions);
        this.maxLanguageVersionCombo.setVisible(hasVersions);
        if (hasVersions) {
            ArrayList<LanguageVersion> versions = new ArrayList<LanguageVersion>();
            versions.add(null);
            versions.addAll(language.getVersions());
            this.populate(this.minLanguageVersionCombo, versions);
            this.populate(this.maxLanguageVersionCombo, versions);
        }
    }

    private void populate(Combo field, List<LanguageVersion> versions) {
        field.removeAll();
        for (LanguageVersion version : versions) {
            field.add(version == null ? "" : version.getName());
        }
    }

    private Set<Comparable<?>> uniquePriorities() {
        if (this.rules == null) {
            return Collections.emptySet();
        }
        return RuleUtil.uniqueAspects(this.rules, RuleFieldAccessor.priority);
    }

    private String commonLanguageMinVersionName() {
        if (this.rules == null) {
            return null;
        }
        LanguageVersion version = RuleUtil.commonLanguageMinVersion(this.rules);
        return version == null ? null : version.getName();
    }

    private String commonLanguageMaxVersionName() {
        if (this.rules == null) {
            return null;
        }
        LanguageVersion version = (LanguageVersion)RuleUtil.commonAspect(this.rules, RuleFieldAccessor.maxLanguageVersion);
        return version == null ? null : version.getName();
    }

    private String commonPriorityName() {
        if (this.rules == null) {
            return null;
        }
        RulePriority priority = RuleUtil.commonPriority(this.rules);
        return priority == null ? null : UISettings.labelFor(priority);
    }

    private boolean allRulesUseTypeResolution() {
        return this.rules != null && RuleUtil.allUseTypeResolution(this.rules);
    }

    private boolean allRulesUseDfa() {
        return this.rules != null && RuleUtil.allUseDfa(this.rules);
    }

    @Override
    protected void adapt() {
        this.show(this.ruleSetNameField, RuleUtil.commonRuleset(this.rules));
        Language language = RuleUtil.commonLanguage(this.rules);
        this.show(this.languageCombo, language == null ? "" : language.getName());
        ImplementationType impType = this.rules == null ? ImplementationType.Mixed : this.rules.implementationType();
        this.implementationType(impType);
        this.implementationTypeCombo.setEnabled(this.creatingNewRule());
        Class<Rule> impClass = RuleUtil.commonImplementationClass(this.rules);
        this.show(this.implementationClassField, impClass);
        this.implementationClassField.setEnabled(impClass != null);
        this.show(this.priorityCombo, this.commonPriorityName());
        this.priorityDisplay.setItems(this.uniquePriorities().toArray());
        this.show(this.usesTypeResolutionButton, this.allRulesUseTypeResolution());
        this.show(this.usesDfaButton, this.allRulesUseDfa());
        this.showLanguageVersionFields(language);
        this.show(this.minLanguageVersionCombo, this.commonLanguageMinVersionName());
        this.show(this.maxLanguageVersionCombo, this.commonLanguageMaxVersionName());
        Rule soleRule = this.soleRule();
        if (soleRule == null) {
            this.shutdown(this.nameField);
        } else {
            this.show(this.nameField, this.asCleanString(soleRule.getName()));
        }
        this.validate();
    }

    @Override
    protected boolean canManageMultipleRules() {
        return true;
    }

    @Override
    public Control setupOn(Composite parent) {
        this.inSetup = true;
        this.labels = new ArrayList<Label>();
        Composite dlgArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        dlgArea.setLayout((Layout)gridLayout);
        if (!this.creatingNewRule()) {
            this.buildPriorityControls(dlgArea);
        }
        Label nameLabel = this.buildLabel(dlgArea, "preference.ruleedit.label.name");
        GridData data = new GridData();
        data.horizontalSpan = 1;
        nameLabel.setLayoutData((Object)data);
        this.nameField = this.buildNameText(dlgArea);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 5;
        data.grabExcessHorizontalSpace = true;
        this.nameField.setLayoutData((Object)data);
        Label ruleSetNameLabel = this.buildLabel(dlgArea, "preference.ruleedit.label.ruleset_name");
        data = new GridData();
        data.horizontalSpan = 1;
        ruleSetNameLabel.setLayoutData((Object)data);
        this.ruleSetNameField = this.buildRuleSetNameField(dlgArea);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 5;
        data.grabExcessHorizontalSpace = true;
        this.ruleSetNameField.setLayoutData((Object)data);
        Label implTypeLabel = this.buildLabel(dlgArea, "preference.ruleedit.label.implemented_by");
        data = new GridData();
        data.horizontalSpan = 1;
        implTypeLabel.setLayoutData((Object)data);
        this.implementationTypeCombo = this.buildImplementationTypeCombo(dlgArea);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 5;
        data.grabExcessHorizontalSpace = true;
        this.implementationTypeCombo.setLayoutData((Object)data);
        Label implementationClassLabel = this.buildLabel(dlgArea, "preference.ruleedit.label.implementation_class");
        data = new GridData();
        data.horizontalSpan = 1;
        implementationClassLabel.setLayoutData((Object)data);
        this.implementationClassField = this.buildImplementationClassField(dlgArea);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 5;
        data.grabExcessHorizontalSpace = true;
        this.implementationClassField.setLayoutData(data);
        this.buildLabel(dlgArea, null);
        this.usesTypeResolutionButton = this.buildUsesTypeResolutionButton(dlgArea);
        this.usesDfaButton = this.buildUsesDfaButton(dlgArea);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 4;
        data.grabExcessHorizontalSpace = true;
        this.usesDfaButton.setLayoutData((Object)data);
        Label languageLabel = this.buildLabel(dlgArea, "preference.ruleedit.label.language");
        data = new GridData();
        data.horizontalSpan = 1;
        languageLabel.setLayoutData((Object)data);
        this.languageCombo = this.buildLanguageCombo(dlgArea);
        data = new GridData();
        data.horizontalAlignment = 1;
        data.horizontalSpan = 1;
        data.grabExcessHorizontalSpace = false;
        this.languageCombo.setLayoutData((Object)data);
        GridData lblGD = new GridData();
        lblGD.horizontalSpan = 1;
        lblGD.horizontalAlignment = 0x1000008;
        GridData cmboGD = new GridData();
        cmboGD.horizontalAlignment = 4;
        cmboGD.horizontalSpan = 1;
        cmboGD.grabExcessHorizontalSpace = true;
        this.minLanguageLabel = this.buildLabel(dlgArea, "preference.ruleedit.label.language.version.min");
        this.minLanguageLabel.setAlignment(131072);
        this.minLanguageLabel.setLayoutData((Object)lblGD);
        this.minLanguageVersionCombo = this.buildLanguageVersionCombo(dlgArea, true);
        this.minLanguageVersionCombo.setLayoutData((Object)cmboGD);
        this.maxLanguageLabel = this.buildLabel(dlgArea, "preference.ruleedit.label.language.version.max");
        this.maxLanguageLabel.setAlignment(131072);
        this.maxLanguageLabel.setLayoutData((Object)lblGD);
        this.maxLanguageVersionCombo = this.buildLanguageVersionCombo(dlgArea, false);
        this.maxLanguageVersionCombo.setLayoutData((Object)cmboGD);
        if (this.creatingNewRule()) {
            this.buildPriorityControls(dlgArea);
            this.implementationType(ImplementationType.XPath);
        }
        this.setControl((Control)dlgArea);
        this.validate();
        this.inSetup = false;
        return dlgArea;
    }

    private Button buildRuleReferenceButton(Composite parent) {
        Button button = new Button(parent, 32);
        button.setText(SWTUtil.stringFor("preference.ruleedit.button.rule_reference"));
        button.setEnabled(false);
        return button;
    }

    private Label buildLabel(Composite parent, String msgKey) {
        Label label = new Label(parent, 0);
        label.setText(msgKey == null ? "" : SWTUtil.stringFor(msgKey));
        this.labels.add(label);
        return label;
    }

    private Text buildNameText(Composite parent) {
        int style = this.creatingNewRule() ? 2052 : 2056;
        Text nameField = new Text(parent, style);
        nameField.setFocus();
        Listener validateListener = new Listener(){

            public void handleEvent(Event event) {
                RulePanelManager.this.validateRuleParams();
            }
        };
        nameField.addListener(24, validateListener);
        nameField.addListener(14, validateListener);
        return nameField;
    }

    private Combo buildRuleSetNameField(Composite parent) {
        int style = this.creatingNewRule() ? 2048 : 8;
        Combo field = new Combo(parent, style);
        Set<RuleSet> rs = PMDPlugin.getDefault().getRuleSetManager().getRegisteredRuleSets();
        RuleSet[] ruleSets = rs.toArray(new RuleSet[rs.size()]);
        Arrays.sort(ruleSets, byNameComparator);
        RuleSet[] ruleSetArray = ruleSets;
        int n = ruleSets.length;
        int n2 = 0;
        while (n2 < n) {
            RuleSet ruleSet = ruleSetArray[n2];
            field.add(ruleSet.getName().trim());
            ++n2;
        }
        Listener validateListener = new Listener(){

            public void handleEvent(Event event) {
                RulePanelManager.this.validateRuleParams();
            }
        };
        field.addListener(24, validateListener);
        field.addListener(14, validateListener);
        return field;
    }

    private void implementationType(ImplementationType type) {
        switch (type) {
            case XPath: {
                this.implementationClassField.setEnabled(false);
                this.usesTypeResolutionButton.setEnabled(false);
                this.usesTypeResolutionButton.setSelection(true);
                this.usesDfaButton.setEnabled(false);
                this.usesDfaButton.setSelection(false);
                this.implementationTypeCombo.select(0);
                if (!this.creatingNewRule()) break;
                this.implementationClassField.setType(XPathRule.class);
                break;
            }
            case Java: {
                this.implementationClassField.setEnabled(true);
                this.usesTypeResolutionButton.setEnabled(true);
                this.usesTypeResolutionButton.setSelection(true);
                this.usesDfaButton.setEnabled(true);
                this.usesDfaButton.setSelection(false);
                this.implementationTypeCombo.select(1);
                if (!this.creatingNewRule()) break;
                this.implementationClassField.setType(null);
                break;
            }
            case Mixed: {
                this.implementationTypeCombo.deselectAll();
            }
        }
        this.validateRuleParams();
    }

    private Combo buildImplementationTypeCombo(Composite parent) {
        final Combo combo = new Combo(parent, 8);
        combo.add("XPath script");
        combo.add("Java class");
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int idx = combo.getSelectionIndex();
                switch (idx) {
                    case 0: {
                        RulePanelManager.this.implementationType(ImplementationType.XPath);
                        break;
                    }
                    case 1: {
                        RulePanelManager.this.implementationType(ImplementationType.Java);
                        break;
                    }
                    case -1: {
                        RulePanelManager.this.implementationType(ImplementationType.Mixed);
                    }
                }
            }
        });
        combo.select(0);
        return combo;
    }

    private Combo buildLanguageCombo(Composite parent) {
        final List languages = Language.findWithRuleSupport();
        final Combo combo = new Combo(parent, 8);
        Language deflt = Language.getDefaultLanguage();
        int selectionIndex = -1;
        int i = 0;
        while (i < languages.size()) {
            if (languages.get(i) == deflt) {
                selectionIndex = i;
            }
            combo.add(((Language)languages.get(i)).getName());
            ++i;
        }
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (RulePanelManager.this.rules == null) {
                    return;
                }
                Language language = (Language)languages.get(combo.getSelectionIndex());
                RulePanelManager.this.rules.setLanguage(language);
                RulePanelManager.this.updateLanguageVersionComboSelections(language);
                RulePanelManager.this.changed(null, language.getName());
            }
        });
        combo.select(selectionIndex);
        return combo;
    }

    private void updateLanguageVersionComboSelections(Language language) {
        List versions = language.getVersions();
        if (versions.size() > 1) {
            this.showLanguageVersionFields(language);
            this.show(this.minLanguageVersionCombo, this.commonLanguageMinVersionName());
            this.show(this.maxLanguageVersionCombo, this.commonLanguageMaxVersionName());
        } else {
            this.showLanguageVersionFields(null);
        }
    }

    private Language selectedLanguage() {
        int index = this.languageCombo.getSelectionIndex();
        if (index < 0) {
            return null;
        }
        return (Language)Language.findWithRuleSupport().get(index);
    }

    private LanguageVersion selectedVersionIn(Combo versionCombo) {
        int index = versionCombo.getSelectionIndex();
        if (index < 0) {
            return null;
        }
        return (LanguageVersion)this.selectedLanguage().getVersions().get(index);
    }

    private Combo buildLanguageVersionCombo(Composite parent, final boolean isMinVersion) {
        int style = this.creatingNewRule() ? 2052 : 2056;
        final Combo combo = new Combo(parent, style);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (RulePanelManager.this.rules == null) {
                    return;
                }
                int selIdx = combo.getSelectionIndex();
                final LanguageVersion version = selIdx == 0 ? null : (LanguageVersion)RulePanelManager.this.selectedLanguage().getVersions().get(selIdx - 1);
                RuleVisitor visitor = new RuleVisitor(){

                    @Override
                    public boolean accept(Rule rule) {
                        if (isMinVersion) {
                            rule.setMinimumLanguageVersion(version);
                        } else {
                            rule.setMaximumLanguageVersion(version);
                        }
                        return true;
                    }
                };
                RulePanelManager.this.rules.rulesDo(visitor);
                RulePanelManager.this.valueChanged(null, version == null ? "" : version.getName());
            }
        });
        return combo;
    }

    private Combo buildPriorityCombo(Composite parent) {
        RulePriority[] priorities;
        final Combo combo = new Combo(parent, 2056);
        RulePriority[] rulePriorityArray = priorities = RulePriority.values();
        int n = priorities.length;
        int n2 = 0;
        while (n2 < n) {
            RulePriority rulePriority = rulePriorityArray[n2];
            combo.add(UISettings.labelFor(rulePriority));
            ++n2;
        }
        if (this.rules != null) {
            RulePriority priority = RuleUtil.commonPriority(this.rules);
            int index = priority == null ? -1 : priority.getPriority() - 1;
            combo.select(index);
        }
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RulePanelManager.this.setPriority(priorities[combo.getSelectionIndex()]);
                RulePanelManager.this.validateRuleParams();
            }
        });
        combo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        return combo;
    }

    private void setPriority(RulePriority priority) {
        this.priorityDisplay.setItems(new Object[]{priority});
        if (this.rules != null) {
            this.rules.setPriority(priority);
        }
        this.valueChanged(null, priority);
    }

    private Button buildUsesTypeResolutionButton(Composite parent) {
        Button button = new Button(parent, 32);
        button.setText(SWTUtil.stringFor("preference.ruleedit.button.uses_type_resolution"));
        return button;
    }

    private Button buildUsesDfaButton(Composite parent) {
        Button button = new Button(parent, 32);
        button.setText(SWTUtil.stringFor("preference.ruleedit.button.uses_dfa"));
        return button;
    }

    private boolean hasValidRuleType() {
        if (!this.implementationClassField.isEnabled()) {
            return true;
        }
        Class<?> newType = this.implementationClassField.getType(false);
        return newType != null && Rule.class.isAssignableFrom(newType);
    }

    private String nameFieldValue() {
        return this.nameField.getText().trim();
    }

    private void buildPriorityControls(Composite parent) {
        Label priorityLabel = this.buildLabel(parent, "preference.ruleedit.label.priority");
        GridData data = new GridData();
        data.horizontalSpan = 1;
        priorityLabel.setLayoutData((Object)data);
        this.priorityCombo = this.buildPriorityCombo(parent);
        this.priorityDisplay = new ShapePicker(parent, 0, 14);
        this.priorityDisplay.setLayoutData(new GridData(16384, 0x1000000, true, false, 4, 1));
        this.priorityDisplay.setShapeMap(UISettings.shapesByPriority());
        this.priorityDisplay.tooltipProvider(new LabelProvider(){

            @Override
            public String labelFor(Object item) {
                return UISettings.labelFor((RulePriority)item);
            }
        });
        this.priorityDisplay.setSize(120, 25);
    }

    private boolean hasValidRuleName() {
        if (this.creatingNewRule() && !RulePanelManager.isValidRuleName(this.nameFieldValue())) {
            return false;
        }
        if (this.rules == null || this.rules.hasMultipleRules()) {
            return true;
        }
        return RulePanelManager.isValidRuleName(this.nameFieldValue());
    }

    private boolean hasExistingRuleName() {
        if (this.currentRuleNames == null) {
            this.currentRuleNames = MarkerUtil.currentRuleNames();
        }
        return this.currentRuleNames.contains(this.nameFieldValue());
    }

    private boolean hasValidRulesetName() {
        String name = this.ruleSetNameField.getText();
        return RulePanelManager.isValidRulesetName(name);
    }

    private static boolean hasNoSelection(Combo combo) {
        return combo.getSelectionIndex() < 0;
    }

    private boolean hasValidChoice(Combo combo) {
        if (this.creatingNewRule() && RulePanelManager.hasNoSelection(combo)) {
            return false;
        }
        if (this.rules == null || this.rules.hasMultipleRules()) {
            return true;
        }
        return this.priorityCombo.getSelectionIndex() >= 0;
    }

    @Override
    protected List<String> fieldErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.hasValidRuleType()) {
            errors.add("Invalid rule class");
        }
        if (!this.hasValidRuleName()) {
            errors.add("Invalid rule name");
        }
        if (this.creatingNewRule() && this.hasExistingRuleName()) {
            errors.add("Rule name is already in use");
        }
        if (!this.hasValidRulesetName()) {
            errors.add("Invalid ruleset name");
        }
        if (!this.hasValidChoice(this.priorityCombo)) {
            errors.add("No priority selected");
        }
        if (!this.hasValidChoice(this.languageCombo)) {
            errors.add("No language selected");
        }
        return errors;
    }

    private void validateRuleParams() {
        boolean isOk = this.validate();
        if (isOk && this.creatingNewRule()) {
            this.populateRuleInstance();
        }
        if (this.inSetup) {
            return;
        }
        if (this.target != null) {
            this.target.rule(isOk ? this.rules.soleRule() : null);
        }
    }

    private void copyLocalValuesTo(Rule rule) {
        rule.setName(this.nameFieldValue());
        rule.setRuleSetName(this.ruleSetNameField.getText());
        Language language = this.selectedLanguage();
        rule.setLanguage(language);
        rule.setPriority(RulePriority.valueOf((int)(this.priorityCombo.getSelectionIndex() + 1)));
        if (this.usesTypeResolutionButton.getSelection()) {
            rule.setUsesTypeResolution();
        }
        if (this.usesDfaButton.getSelection()) {
            rule.setUsesDFA();
        }
        rule.setMinimumLanguageVersion(this.selectedVersionIn(this.minLanguageVersionCombo));
        rule.setMaximumLanguageVersion(this.selectedVersionIn(this.maxLanguageVersionCombo));
    }

    private void populateRuleInstance() {
        Class<?> ruleType = this.implementationClassField.getType(true);
        try {
            Rule newRule = (Rule)ruleType.newInstance();
            if (this.rules == null) {
                this.rules = new RuleSelection(newRule);
            } else if (newRule.getClass() != this.soleRule().getClass()) {
                this.rules.soleRule(newRule);
            }
            this.copyLocalValuesTo(this.rules.soleRule());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private TypeText buildImplementationClassField(Composite parent) {
        int style = this.creatingNewRule() ? 2052 : 2056;
        TypeText classField = new TypeText(parent, style, true, "");
        classField.setEnabled(false);
        Listener validateListener = new Listener(){

            public void handleEvent(Event event) {
                RulePanelManager.this.validateRuleParams();
            }
        };
        classField.addListener(16, validateListener);
        classField.addListener(14, validateListener);
        return classField;
    }

    private static boolean isValidRuleName(String candidateName) {
        return !StringUtil.isEmpty((String)candidateName);
    }

    private static boolean isValidRulesetName(String candidateName) {
        return !StringUtil.isEmpty((String)candidateName);
    }
}

