/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.editors;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.AbstractMultiValueEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.TypeEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.TypeText;
import net.sourceforge.pmd.lang.rule.properties.PropertyDescriptorWrapper;
import net.sourceforge.pmd.lang.rule.properties.TypeMultiProperty;
import net.sourceforge.pmd.util.ClassUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.StringUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class MultiTypeEditorFactory
extends AbstractMultiValueEditorFactory {
    public static final MultiTypeEditorFactory instance = new MultiTypeEditorFactory();

    private MultiTypeEditorFactory() {
    }

    @Override
    public PropertyDescriptor<?> createDescriptor(String name, String optionalDescription, Control[] otherData) {
        return new TypeMultiProperty(name, "Type value " + name, new Class[]{String.class}, new String[]{"java.lang"}, 0.0f);
    }

    public static String[] shortNamesFor(Class<?>[] types) {
        String[] typeNames = new String[types.length];
        int i = 0;
        while (i < typeNames.length) {
            typeNames[i] = ClassUtil.asShortestName(types[i]);
            ++i;
        }
        return typeNames;
    }

    @Override
    protected void fillWidget(Text textWidget, PropertyDescriptor<?> desc, PropertySource source) {
        Class[] values = (Class[])this.valueFor(source, desc);
        if (values == null) {
            textWidget.setText("");
            return;
        }
        textWidget.setText(values == null ? "" : this.asString(values));
        this.adjustRendering(source, desc, (Control)textWidget);
    }

    private String asString(Class<?>[] types) {
        Object[] typeNames = MultiTypeEditorFactory.shortNamesFor(types);
        return StringUtil.asString((Object[])typeNames, (String)", ");
    }

    private Class<?>[] currentTypes(Text textWidget) {
        String[] typeNames = this.textWidgetValues(textWidget);
        if (typeNames.length == 0) {
            return ClassUtil.EMPTY_CLASS_ARRAY;
        }
        ArrayList types = new ArrayList(typeNames.length);
        String[] stringArray = typeNames;
        int n = typeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String typeName = stringArray[n2];
            Class<?> newType = TypeEditorFactory.typeFor(typeName);
            if (newType != null) {
                types.add(newType);
            }
            ++n2;
        }
        return types.toArray(new Class[types.size()]);
    }

    private static TypeMultiProperty multiTypePropertyFrom(PropertyDescriptor<?> desc) {
        if (desc instanceof PropertyDescriptorWrapper) {
            return (TypeMultiProperty)((PropertyDescriptorWrapper)desc).getPropertyDescriptor();
        }
        return (TypeMultiProperty)desc;
    }

    @Override
    protected Control addWidget(Composite parent, Object value, PropertyDescriptor<?> desc, PropertySource source) {
        TypeText typeWidget = new TypeText(parent, 2052, true, "Enter type name");
        this.setValue((Control)typeWidget, value);
        return typeWidget;
    }

    @Override
    protected void setValue(Control widget, Object value) {
        Class type = (Class)value;
        ((TypeText)widget).setType(type);
    }

    @Override
    protected void configure(final Text textWidget, final PropertyDescriptor<?> desc, final PropertySource source, final ValueChangeListener listener) {
        final TypeMultiProperty tmp = MultiTypeEditorFactory.multiTypePropertyFrom(desc);
        textWidget.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                Object[] newValue = MultiTypeEditorFactory.this.currentTypes(textWidget);
                Object[] existingValue = (Class[])MultiTypeEditorFactory.this.valueFor(source, (PropertyDescriptor<?>)tmp);
                if (CollectionUtil.areSemanticEquals((Object[])existingValue, (Object[])newValue)) {
                    return;
                }
                source.setProperty((PropertyDescriptor)tmp, (Object)newValue);
                MultiTypeEditorFactory.this.fillWidget(textWidget, desc, source);
                listener.changed(source, desc, (Object)newValue);
                MultiTypeEditorFactory.this.adjustRendering(source, desc, (Control)textWidget);
            }
        });
    }

    @Override
    protected void update(PropertySource source, PropertyDescriptor<?> desc, List<Object> newValues) {
        source.setProperty((PropertyDescriptor)((TypeMultiProperty)desc), (Object)newValues.toArray(new Class[newValues.size()]));
    }

    @Override
    protected Object addValueIn(Control widget, PropertyDescriptor<?> desc, PropertySource source) {
        Class[] newValues;
        Class<?> enteredValue = ((TypeText)widget).getType(true);
        if (enteredValue == null) {
            return null;
        }
        Object[] currentValues = (Class[])this.valueFor(source, desc);
        if (currentValues.length == (newValues = (Class[])CollectionUtil.addWithoutDuplicates((Object[])currentValues, enteredValue)).length) {
            return null;
        }
        source.setProperty((PropertyDescriptor)((TypeMultiProperty)desc), (Object)newValues);
        return enteredValue;
    }

    @Override
    protected Object valueFrom(Control valueControl) {
        return null;
    }
}

