/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.editors;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.AbstractMultiValueEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.MethodEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.MethodPicker;
import net.sourceforge.pmd.eclipse.util.Util;
import net.sourceforge.pmd.lang.rule.properties.MethodMultiProperty;
import net.sourceforge.pmd.util.ClassUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class MultiMethodEditorFactory
extends AbstractMultiValueEditorFactory {
    public static final MultiMethodEditorFactory instance = new MultiMethodEditorFactory();

    private MultiMethodEditorFactory() {
    }

    @Override
    public PropertyDescriptor<?> createDescriptor(String name, String optionalDescription, Control[] otherData) {
        return new MethodMultiProperty(name, "Method value " + name, new Method[]{MethodEditorFactory.stringLength}, new String[]{"java.lang"}, 0.0f);
    }

    public static String[] signaturesFor(Method[] methods) {
        String[] typeNames = new String[methods.length];
        int i = 0;
        while (i < typeNames.length) {
            typeNames[i] = Util.signatureFor(methods[i], MethodEditorFactory.UnwantedPrefixes);
            ++i;
        }
        return typeNames;
    }

    private static String asString(Map<String, List<Method>> methodGroups) {
        if (methodGroups.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<String, List<Method>>> iter = methodGroups.entrySet().iterator();
        Map.Entry<String, List<Method>> entry = iter.next();
        sb.append(entry.getKey()).append('[');
        MultiMethodEditorFactory.allSignaturesOn(sb, entry.getValue(), ",");
        sb.append(']');
        while (iter.hasNext()) {
            entry = iter.next();
            sb.append("  ").append(entry.getKey()).append('[');
            MultiMethodEditorFactory.allSignaturesOn(sb, entry.getValue(), ", ");
            sb.append(']');
        }
        return sb.toString();
    }

    private static void allSignaturesOn(StringBuilder sb, List<Method> methods, String delimiter) {
        sb.append(Util.signatureFor(methods.get(0), MethodEditorFactory.UnwantedPrefixes));
        int i = 1;
        while (i < methods.size()) {
            sb.append(delimiter).append(Util.signatureFor(methods.get(i), MethodEditorFactory.UnwantedPrefixes));
            ++i;
        }
    }

    @Override
    protected void fillWidget(Text textWidget, PropertyDescriptor<?> desc, PropertySource source) {
        Method[] values = (Method[])this.valueFor(source, desc);
        if (values == null) {
            textWidget.setText("");
            return;
        }
        Map methodMap = ClassUtil.asMethodGroupsByTypeName((Method[])values);
        textWidget.setText(values == null ? "" : MultiMethodEditorFactory.asString(methodMap));
        this.adjustRendering(source, desc, (Control)textWidget);
    }

    @Override
    protected Control addWidget(Composite parent, Object value, PropertyDescriptor<?> desc, PropertySource source) {
        MethodPicker widget = new MethodPicker(parent, 2052, MethodEditorFactory.UnwantedPrefixes);
        this.setValue((Control)widget, value);
        return widget;
    }

    @Override
    protected void setValue(Control widget, Object value) {
        Method method = value == null ? null : (Method)value;
        ((MethodPicker)widget).setMethod(method);
    }

    @Override
    protected void configure(Text textWidget, PropertyDescriptor<?> desc, PropertySource source, ValueChangeListener listener) {
        textWidget.setEditable(false);
    }

    @Override
    protected void update(PropertySource source, PropertyDescriptor<?> desc, List<Object> newValues) {
        source.setProperty((PropertyDescriptor)((MethodMultiProperty)desc), (Object)newValues.toArray(new Method[newValues.size()]));
    }

    @Override
    protected Object addValueIn(Control widget, PropertyDescriptor<?> desc, PropertySource source) {
        Method[] newValues;
        Method newValue = ((MethodPicker)widget).getMethod();
        if (newValue == null) {
            return null;
        }
        Object[] currentValues = (Method[])this.valueFor(source, desc);
        if (currentValues.length == (newValues = (Method[])CollectionUtil.addWithoutDuplicates((Object[])currentValues, (Object)newValue)).length) {
            return null;
        }
        source.setProperty((PropertyDescriptor)((MethodMultiProperty)desc), (Object)newValues);
        return newValue;
    }

    @Override
    protected Object valueFrom(Control valueControl) {
        return null;
    }
}

