/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.editors;

import java.lang.reflect.Method;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.eclipse.ui.preferences.br.SizeChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.AbstractEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.MethodPicker;
import net.sourceforge.pmd.lang.rule.properties.MethodProperty;
import net.sourceforge.pmd.lang.rule.properties.PropertyDescriptorWrapper;
import net.sourceforge.pmd.util.ClassUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MethodEditorFactory
extends AbstractEditorFactory {
    public static final MethodEditorFactory instance = new MethodEditorFactory();
    public static final String[] UnwantedPrefixes = new String[]{"java.lang.reflect.", "java.lang.", "java.util."};
    public static final Method stringLength = ClassUtil.methodFor(String.class, (String)"length", (Class[])ClassUtil.EMPTY_CLASS_ARRAY);

    private MethodEditorFactory() {
    }

    @Override
    public PropertyDescriptor<?> createDescriptor(String name, String optionalDescription, Control[] otherData) {
        return new MethodProperty(name, "Method value " + name, stringLength, new String[]{"java.lang"}, 0.0f);
    }

    @Override
    protected Object valueFrom(Control valueControl) {
        return ((MethodPicker)valueControl).getMethod();
    }

    protected void fillWidget(MethodPicker widget, PropertyDescriptor<?> desc, PropertySource source) {
        Method method = (Method)this.valueFor(source, desc);
        widget.setMethod(method);
        this.adjustRendering(source, desc, (Control)widget);
    }

    private static MethodProperty methodPropertyFrom(PropertyDescriptor<?> desc) {
        if (desc instanceof PropertyDescriptorWrapper) {
            return (MethodProperty)((PropertyDescriptorWrapper)desc).getPropertyDescriptor();
        }
        return (MethodProperty)desc;
    }

    @Override
    public Control newEditorOn(Composite parent, final PropertyDescriptor<?> desc, final PropertySource source, final ValueChangeListener listener, SizeChangeListener sizeListener) {
        final MethodPicker picker = new MethodPicker(parent, 2052, UnwantedPrefixes);
        picker.setLayoutData(new GridData(768));
        this.fillWidget(picker, desc, source);
        final MethodProperty mp = MethodEditorFactory.methodPropertyFrom(desc);
        picker.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Method newValue = picker.getMethod();
                if (newValue == null) {
                    return;
                }
                Method existingValue = (Method)MethodEditorFactory.this.valueFor(source, (PropertyDescriptor<?>)mp);
                if (existingValue == newValue) {
                    return;
                }
                source.setProperty((PropertyDescriptor)mp, (Object)newValue);
                MethodEditorFactory.this.fillWidget(picker, desc, source);
                listener.changed(source, desc, (Object)newValue);
            }
        });
        return picker;
    }
}

