/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.br;

import java.lang.reflect.Method;
import java.util.Date;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.eclipse.plugin.UISettings;
import net.sourceforge.pmd.eclipse.ui.preferences.br.BasicValueFormatter;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.MethodEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.MultiTypeEditorFactory;
import net.sourceforge.pmd.eclipse.util.Util;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.util.ClassUtil;

public interface ValueFormatter {
    public static final ValueFormatter StringFormatter = new BasicValueFormatter(null){

        @Override
        public void format(Object value, StringBuilder target) {
            target.append(value == null ? "" : value);
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }
    };
    public static final ValueFormatter MultiStringFormatter = new BasicValueFormatter(null){

        @Override
        public void format(Object value, StringBuilder target) {
            target.append('[');
            Util.asString((Object[])value, ", ", target);
            target.append(']');
        }
    };
    public static final ValueFormatter NumberFormatter = new BasicValueFormatter(null){

        @Override
        public void format(Object value, StringBuilder target) {
            target.append(value == null ? "?" : value);
        }
    };
    public static final ValueFormatter BooleanFormatter = new BasicValueFormatter(null){

        @Override
        public void format(Object value, StringBuilder target) {
            target.append(value == null ? "?" : value);
        }
    };
    public static final ValueFormatter TypeFormatter = new BasicValueFormatter(null){

        @Override
        public void format(Object value, StringBuilder target) {
            target.append(value == null ? "" : ClassUtil.asShortestName((Class)((Class)value)));
        }
    };
    public static final ValueFormatter MultiTypeFormatter = new BasicValueFormatter(null){

        @Override
        public void format(Object value, StringBuilder target) {
            target.append('[');
            Util.asString(MultiTypeEditorFactory.shortNamesFor((Class[])value), ", ", target);
            target.append(']');
        }
    };
    public static final ValueFormatter MethodFormatter = new BasicValueFormatter(null){

        @Override
        public void format(Object value, StringBuilder target) {
            if (value == null) {
                return;
            }
            target.append(Util.signatureFor((Method)value, MethodEditorFactory.UnwantedPrefixes));
        }
    };
    public static final ValueFormatter MultiMethodFormatter = new BasicValueFormatter(null){

        @Override
        public void format(Object value, StringBuilder target) {
            target.append('[');
            Object[] methods = (Object[])value;
            if (methods == null || methods.length == 0) {
                target.append(']');
                return;
            }
            MethodFormatter.format(methods[0], target);
            int i = 1;
            while (i < methods.length) {
                target.append(',');
                MethodFormatter.format(methods[i], target);
                ++i;
            }
            target.append(']');
        }
    };
    public static final ValueFormatter ObjectFormatter = new BasicValueFormatter(null){

        @Override
        public void format(Object value, StringBuilder target) {
            target.append(value == null ? "" : value);
        }
    };
    public static final ValueFormatter ObjectArrayFormatter = new BasicValueFormatter(null){

        @Override
        public void format(Object value, StringBuilder target) {
            target.append('[');
            Util.asString((Object[])value, ", ", target);
            target.append(']');
        }
    };
    public static final ValueFormatter PriorityFormatter = new BasicValueFormatter(null){

        @Override
        public String format(Object value) {
            return UISettings.labelFor((RulePriority)value);
        }
    };
    public static final ValueFormatter LanguageFormatter = new BasicValueFormatter(null){

        @Override
        public String format(Object value) {
            return ((Language)value).getName();
        }
    };
    public static final ValueFormatter LanguageVersionFormatter = new BasicValueFormatter(null){

        @Override
        public String format(Object value) {
            return ((LanguageVersion)value).getName();
        }
    };
    public static final ValueFormatter DateFromLongFormatter = new BasicValueFormatter("Date"){

        @Override
        public String format(Object value) {
            return new Date((Long)value).toString();
        }
    };
    public static final ValueFormatter TimeFromLongFormatter = new BasicValueFormatter("Time"){

        @Override
        public String format(Object value) {
            return new Date((Long)value).toString();
        }
    };
    public static final ValueFormatter[] TimeFormatters = new ValueFormatter[]{DateFromLongFormatter};

    public String format(Object var1);

    public void format(Object var1, StringBuilder var2);
}

