/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Comparator;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.plugin.UISettings;
import net.sourceforge.pmd.eclipse.runtime.writer.IRuleSetWriter;
import net.sourceforge.pmd.eclipse.runtime.writer.WriterException;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleCellModifier;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleDialog;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleLabelProvider;
import net.sourceforge.pmd.eclipse.ui.preferences.RulePropertiesContentProvider;
import net.sourceforge.pmd.eclipse.ui.preferences.RulePropertyCellModifier;
import net.sourceforge.pmd.eclipse.ui.preferences.RulePropertyLabelProvider;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleSetContentProvider;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleSetExcludeIncludePatternCellModifier;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleSetExcludeIncludePatternContentProvider;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleSetExcludeIncludePatternLabelProvider;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleSetSelectionDialog;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleTableViewerSorter;
import net.sourceforge.pmd.util.designer.Designer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PMDPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PROPERTY_LANGUAGE = "language";
    public static final String PROPERTY_RULESET_NAME = "ruleSetname";
    public static final String PROPERTY_RULE_NAME = "ruleName";
    public static final String PROPERTY_SINCE = "since";
    public static final String PROPERTY_PRIORITY = "priority";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_PROPERTY = "property";
    public static final String PROPERTY_VALUE = "value";
    public static final String PROPERTY_PATTERN = "pattern";
    public static PMDPreferencePage activeInstance = null;
    protected TableViewer ruleTableViewer;
    protected TableViewer rulePropertiesTableViewer;
    protected TableViewer excludePatternTableViewer;
    protected TableViewer includePatternTableViewer;
    protected Button addRuleButton;
    protected Button removeRuleButton;
    protected Button editRuleButton;
    protected Button addExcludePatternButton;
    protected Button addIncludePatternButton;
    protected RuleSet ruleSet;
    private boolean modified = false;
    private final RuleTableViewerSorter ruleTableViewerSorter = new RuleTableViewerSorter(RuleTableViewerSorter.RULE_DEFAULT_COMPARATOR);

    public void init(IWorkbench workbench) {
        activeInstance = this;
    }

    protected void performDefaults() {
        this.populateRuleTable();
        this.populateExcludePatternTable();
        this.populateIncludePatternTable();
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.modified) {
            this.updateRuleSet();
            this.rebuildProjects();
        }
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.layoutControls(composite);
        return composite;
    }

    private void layoutControls(Composite parent) {
        Label ruleTableLabel = this.buildLabel(parent, "preference.ruleset.label.ruletable");
        Table ruleTable = this.buildRuleTableViewer(parent);
        Composite ruleTableButtons = this.buildRuleTableButtons(parent);
        Label rulePropertiesTableLabel = this.buildLabel(parent, "preference.ruleset.label.rulepropstable");
        Table rulePropertiesTable = this.buildRulePropertiesTableViewer(parent);
        Composite rulePropertiesTableButton = this.buildRulePropertiesTableButtons(parent);
        Label excludePatternsLabel = this.buildLabel(parent, "preference.ruleset.label.exclude_patterns_table");
        Label includePatternsLabel = this.buildLabel(parent, "preference.ruleset.label.include_patterns_table");
        Table excludePatternTable = this.buildExcludePatternTableViewer(parent);
        Table includePatternTable = this.buildIncludePatternTableViewer(parent);
        Composite excludeIncludePatternTableButtons = this.buildExcludeIncludePatternTableButtons(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        parent.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        ruleTableLabel.setLayoutData((Object)data);
        data = new GridData();
        data.heightHint = 200;
        data.widthHint = 350;
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        ruleTable.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        ruleTableButtons.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 3;
        data.verticalIndent = 5;
        rulePropertiesTableLabel.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 50;
        data.widthHint = 500;
        rulePropertiesTable.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        rulePropertiesTableButton.setLayoutData((Object)data);
        data = new GridData();
        data.verticalIndent = 5;
        data.horizontalSpan = 1;
        excludePatternsLabel.setLayoutData((Object)data);
        data = new GridData();
        data.verticalIndent = 5;
        data.horizontalSpan = 2;
        includePatternsLabel.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.heightHint = 50;
        data.widthHint = 250;
        excludePatternTable.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.heightHint = 50;
        data.widthHint = 250;
        includePatternTable.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        excludeIncludePatternTableButtons.setLayoutData((Object)data);
    }

    private Composite buildRuleTableButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 3;
        composite.setLayout((Layout)gridLayout);
        this.removeRuleButton = this.buildRemoveRuleButton(composite);
        this.editRuleButton = this.buildEditRuleButton(composite);
        this.addRuleButton = this.buildAddRuleButton(composite);
        Button importRuleSetButton = this.buildImportRuleSetButton(composite);
        Button exportRuleSetButton = this.buildExportRuleSetButton(composite);
        Button clearAllButton = this.buildClearAllButton(composite);
        Button ruleDesignerButton = this.buildRuleDesignerButton(composite);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        this.removeRuleButton.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 4;
        this.editRuleButton.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 4;
        this.addRuleButton.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 4;
        importRuleSetButton.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 4;
        exportRuleSetButton.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 4;
        clearAllButton.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 3;
        ruleDesignerButton.setLayoutData((Object)data);
        return composite;
    }

    private Composite buildRulePropertiesTableButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.wrap = false;
        rowLayout.pack = false;
        composite.setLayout((Layout)rowLayout);
        return composite;
    }

    private Label buildLabel(Composite parent, String msgKey) {
        Label label = new Label(parent, 0);
        label.setText(msgKey == null ? "" : this.getMessage(msgKey));
        return label;
    }

    private void addColumnTo(Table table, int alignment, boolean resizable, String text, int width, final Comparator<Rule> comparator) {
        TableColumn newColumn = new TableColumn(table, alignment);
        newColumn.setResizable(resizable);
        newColumn.setText(text);
        newColumn.setWidth(width);
        if (comparator != null) {
            newColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PMDPreferencePage.this.ruleTableViewerSorter.setComparator(comparator);
                    PMDPreferencePage.this.refresh();
                }
            });
        }
    }

    private Table buildRuleTableViewer(Composite parent) {
        int tableStyle = 68356;
        this.ruleTableViewer = new TableViewer(parent, tableStyle);
        Table ruleTable = this.ruleTableViewer.getTable();
        this.addColumnTo(ruleTable, 16384, true, this.getMessage("preference.ruleset.column.language"), 70, RuleTableViewerSorter.RULE_LANGUAGE_COMPARATOR);
        this.addColumnTo(ruleTable, 16384, true, this.getMessage("preference.ruleset.column.ruleset_name"), 110, RuleTableViewerSorter.RULE_RULESET_NAME_COMPARATOR);
        this.addColumnTo(ruleTable, 16384, true, this.getMessage("preference.ruleset.column.rule_name"), 170, RuleTableViewerSorter.RULE_NAME_COMPARATOR);
        this.addColumnTo(ruleTable, 16384, false, this.getMessage("preference.ruleset.column.since"), 40, RuleTableViewerSorter.RULE_SINCE_COMPARATOR);
        this.addColumnTo(ruleTable, 16384, false, this.getMessage("preference.ruleset.column.priority"), 80, RuleTableViewerSorter.RULE_PRIORITY_COMPARATOR);
        this.addColumnTo(ruleTable, 16384, true, this.getMessage("preference.ruleset.column.description"), 300, RuleTableViewerSorter.RULE_DESCRIPTION_COMPARATOR);
        ruleTable.setLinesVisible(true);
        ruleTable.setHeaderVisible(true);
        this.ruleTableViewer.setContentProvider((IContentProvider)new RuleSetContentProvider());
        this.ruleTableViewer.setLabelProvider((IBaseLabelProvider)new RuleLabelProvider());
        this.ruleTableViewer.setSorter((ViewerSorter)this.ruleTableViewerSorter);
        this.ruleTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Rule selectedRule = (Rule)selection.getFirstElement();
                PMDPreferencePage.this.rulePropertiesTableViewer.setInput((Object)selectedRule);
                PMDPreferencePage.this.removeRuleButton.setEnabled(selectedRule != null);
                PMDPreferencePage.this.editRuleButton.setEnabled(selectedRule != null);
            }
        });
        this.ruleTableViewer.setColumnProperties(new String[]{PROPERTY_LANGUAGE, PROPERTY_RULESET_NAME, PROPERTY_RULE_NAME, PROPERTY_SINCE, PROPERTY_PRIORITY, PROPERTY_DESCRIPTION});
        this.ruleTableViewer.setCellModifier((ICellModifier)new RuleCellModifier(this.ruleTableViewer));
        CellEditor[] cellEditorArray = new CellEditor[6];
        cellEditorArray[4] = new ComboBoxCellEditor((Composite)ruleTable, UISettings.getPriorityLabels());
        cellEditorArray[5] = new TextCellEditor((Composite)ruleTable);
        this.ruleTableViewer.setCellEditors(cellEditorArray);
        this.populateRuleTable();
        return ruleTable;
    }

    private Table buildRulePropertiesTableViewer(Composite parent) {
        int tableStyle = 68356;
        this.rulePropertiesTableViewer = new TableViewer(parent, tableStyle);
        Table rulePropertiesTable = this.rulePropertiesTableViewer.getTable();
        TableColumn propertyColumn = new TableColumn(rulePropertiesTable, 16384);
        propertyColumn.setResizable(true);
        propertyColumn.setText(this.getMessage("preference.ruleset.column.property"));
        propertyColumn.setWidth(100);
        TableColumn valueColumn = new TableColumn(rulePropertiesTable, 16384);
        valueColumn.setResizable(true);
        valueColumn.setText(this.getMessage("preference.ruleset.column.value"));
        valueColumn.setWidth(350);
        rulePropertiesTable.setLinesVisible(true);
        rulePropertiesTable.setHeaderVisible(true);
        this.rulePropertiesTableViewer.setContentProvider((IContentProvider)new RulePropertiesContentProvider());
        this.rulePropertiesTableViewer.setLabelProvider((IBaseLabelProvider)new RulePropertyLabelProvider());
        this.rulePropertiesTableViewer.setColumnProperties(new String[]{PROPERTY_PROPERTY, PROPERTY_VALUE});
        this.rulePropertiesTableViewer.setCellModifier((ICellModifier)new RulePropertyCellModifier(this.rulePropertiesTableViewer));
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = new TextCellEditor((Composite)rulePropertiesTable);
        this.rulePropertiesTableViewer.setCellEditors(cellEditorArray);
        return rulePropertiesTable;
    }

    private Button buildRemoveRuleButton(Composite parent) {
        Button button = new Button(parent, 16392);
        button.setText(this.getMessage("preference.ruleset.button.removerule"));
        button.setEnabled(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)PMDPreferencePage.this.ruleTableViewer.getSelection();
                Rule selectedRule = (Rule)selection.getFirstElement();
                PMDPreferencePage.this.ruleSet.getRules().remove(selectedRule);
                PMDPreferencePage.this.setModified(true);
                try {
                    PMDPreferencePage.this.refresh();
                }
                catch (Throwable throwable) {
                    PMDPreferencePage.this.ruleTableViewer.setSelection(null);
                }
            }
        });
        return button;
    }

    private Button buildEditRuleButton(Composite parent) {
        Button button = new Button(parent, 16392);
        button.setText(this.getMessage("preference.ruleset.button.editrule"));
        button.setEnabled(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)PMDPreferencePage.this.ruleTableViewer.getSelection();
                Rule rule = (Rule)selection.getFirstElement();
                RuleDialog dialog = new RuleDialog(PMDPreferencePage.this.getShell(), rule);
                int result = dialog.open();
                if (result == 0) {
                    PMDPreferencePage.this.setModified(true);
                    try {
                        PMDPreferencePage.this.refresh();
                    }
                    catch (Throwable t) {
                        PMDPlugin.getDefault().logError("Exception when refreshing the rule table", t);
                    }
                }
            }
        });
        return button;
    }

    private Button buildAddRuleButton(Composite parent) {
        Button button = new Button(parent, 16392);
        button.setText(this.getMessage("preference.ruleset.button.addrule"));
        button.setEnabled(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RuleDialog dialog = new RuleDialog(PMDPreferencePage.this.getShell());
                int result = dialog.open();
                if (result == 0) {
                    Rule addedRule = dialog.getRule();
                    PMDPreferencePage.this.ruleSet.addRule(addedRule);
                    PMDPreferencePage.this.setModified(true);
                    try {
                        PMDPreferencePage.this.refresh();
                    }
                    catch (Throwable t) {
                        PMDPlugin.getDefault().logError("Exception when refreshing the rule table", t);
                    }
                    PMDPreferencePage.this.setModified(true);
                    try {
                        PMDPreferencePage.this.refresh();
                    }
                    catch (Throwable t) {
                        PMDPlugin.getDefault().logError("Exception when refreshing the rule table", t);
                    }
                }
            }
        });
        return button;
    }

    private Button buildImportRuleSetButton(Composite parent) {
        Button button = new Button(parent, 16392);
        button.setText(this.getMessage("preference.ruleset.button.importruleset"));
        button.setEnabled(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RuleSetSelectionDialog dialog = new RuleSetSelectionDialog(PMDPreferencePage.this.getShell(), "Import rules", null, null);
                dialog.getShell().setSize(new Point(400, 200));
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    try {
                        RuleSet selectedRules = dialog.checkedRules();
                        if (dialog.isImportByReference()) {
                            PMDPreferencePage.this.ruleSet.addRuleSetByReference(selectedRules, false);
                        } else {
                            for (Rule rule : selectedRules.getRules()) {
                                rule.setRuleSetName("pmd-eclipse");
                                PMDPreferencePage.this.ruleSet.addRule(rule);
                            }
                        }
                        PMDPreferencePage.this.setModified(true);
                        try {
                            PMDPreferencePage.this.refresh();
                        }
                        catch (Throwable t) {
                            PMDPlugin.getDefault().logError("Exception when refreshing the rule table", t);
                        }
                    }
                    catch (RuntimeException e) {
                        PMDPlugin.getDefault().showError(PMDPreferencePage.this.getMessage("message.error.importing_ruleset"), e);
                    }
                }
            }
        });
        return button;
    }

    private Button buildExportRuleSetButton(Composite parent) {
        Button button = new Button(parent, 16392);
        button.setText(this.getMessage("preference.ruleset.button.exportruleset"));
        button.setEnabled(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(PMDPreferencePage.this.getShell(), 8192);
                String fileName = dialog.open();
                if (fileName != null) {
                    try {
                        File file = new File(fileName);
                        boolean flContinue = true;
                        if (file.exists()) {
                            flContinue = MessageDialog.openConfirm((Shell)PMDPreferencePage.this.getShell(), (String)PMDPreferencePage.this.getMessage("message.confirm.title"), (String)PMDPreferencePage.this.getMessage("message.confirm.ruleset_exists"));
                        }
                        InputDialog input = null;
                        if (flContinue) {
                            input = new InputDialog(PMDPreferencePage.this.getShell(), PMDPreferencePage.this.getMessage("preference.ruleset.dialog.title"), PMDPreferencePage.this.getMessage("preference.ruleset.dialog.ruleset_description"), PMDPreferencePage.this.ruleSet.getDescription() == null ? "" : PMDPreferencePage.this.ruleSet.getDescription().trim(), null);
                            boolean bl = flContinue = input.open() == 0;
                        }
                        if (flContinue) {
                            PMDPreferencePage.this.ruleSet.setName(PMDPreferencePage.this.getFileNameWithoutExtension(file.getName()));
                            PMDPreferencePage.this.ruleSet.setDescription(input.getValue());
                            FileOutputStream out = new FileOutputStream(fileName);
                            IRuleSetWriter writer = PMDPlugin.getDefault().getRuleSetWriter();
                            writer.write(out, PMDPreferencePage.this.ruleSet);
                            ((OutputStream)out).close();
                            MessageDialog.openInformation((Shell)PMDPreferencePage.this.getShell(), (String)PMDPreferencePage.this.getMessage("message.information.title"), (String)PMDPreferencePage.this.getMessage("message.information.ruleset_exported"));
                        }
                    }
                    catch (IOException e) {
                        PMDPlugin.getDefault().showError(PMDPreferencePage.this.getMessage("message.error.exporting_ruleset"), e);
                    }
                    catch (WriterException e) {
                        PMDPlugin.getDefault().showError(PMDPreferencePage.this.getMessage("message.error.exporting_ruleset"), e);
                    }
                }
            }
        });
        return button;
    }

    private Button buildClearAllButton(Composite parent) {
        Button button = new Button(parent, 16392);
        button.setText(this.getMessage("preference.ruleset.button.clearall"));
        button.setEnabled(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (MessageDialog.openConfirm((Shell)PMDPreferencePage.this.getShell(), (String)PMDPreferencePage.this.getMessage("message.confirm.title"), (String)PMDPreferencePage.this.getMessage("message.confirm.clear_ruleset"))) {
                    PMDPreferencePage.this.ruleSet.getRules().clear();
                    PMDPreferencePage.this.setModified(true);
                    try {
                        PMDPreferencePage.this.refresh();
                    }
                    catch (Throwable t) {
                        PMDPlugin.getDefault().logError("Exception when refreshing the rule table", t);
                    }
                }
            }
        });
        return button;
    }

    private Button buildRuleDesignerButton(Composite parent) {
        Button button = new Button(parent, 16392);
        button.setText(this.getMessage("preference.ruleset.button.ruledesigner"));
        button.setEnabled(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Designer.main((String[])new String[]{"-noexitonclose"});
                    }
                }).start();
            }
        });
        return button;
    }

    private Table buildExcludePatternTableViewer(Composite parent) {
        int tableStyle = 68356;
        this.excludePatternTableViewer = new TableViewer(parent, tableStyle);
        Table excludePatternTable = this.excludePatternTableViewer.getTable();
        TableColumn patternColumn = new TableColumn(excludePatternTable, 16384);
        patternColumn.setResizable(true);
        patternColumn.setText(this.getMessage("preference.ruleset.column.exclude_pattern"));
        patternColumn.setWidth(250);
        excludePatternTable.setLinesVisible(true);
        excludePatternTable.setHeaderVisible(true);
        this.excludePatternTableViewer.setContentProvider((IContentProvider)new RuleSetExcludeIncludePatternContentProvider(true));
        this.excludePatternTableViewer.setLabelProvider((IBaseLabelProvider)new RuleSetExcludeIncludePatternLabelProvider());
        this.excludePatternTableViewer.setColumnProperties(new String[]{PROPERTY_PATTERN});
        this.excludePatternTableViewer.setCellModifier((ICellModifier)new RuleSetExcludeIncludePatternCellModifier(this.excludePatternTableViewer));
        this.excludePatternTableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)excludePatternTable)});
        this.populateExcludePatternTable();
        return excludePatternTable;
    }

    private Table buildIncludePatternTableViewer(Composite parent) {
        int tableStyle = 68356;
        this.includePatternTableViewer = new TableViewer(parent, tableStyle);
        Table includePatternTable = this.includePatternTableViewer.getTable();
        TableColumn patternColumn = new TableColumn(includePatternTable, 16384);
        patternColumn.setResizable(true);
        patternColumn.setText(this.getMessage("preference.ruleset.column.include_pattern"));
        patternColumn.setWidth(250);
        includePatternTable.setLinesVisible(true);
        includePatternTable.setHeaderVisible(true);
        this.includePatternTableViewer.setContentProvider((IContentProvider)new RuleSetExcludeIncludePatternContentProvider(false));
        this.includePatternTableViewer.setLabelProvider((IBaseLabelProvider)new RuleSetExcludeIncludePatternLabelProvider());
        this.includePatternTableViewer.setColumnProperties(new String[]{PROPERTY_PATTERN});
        this.includePatternTableViewer.setCellModifier((ICellModifier)new RuleSetExcludeIncludePatternCellModifier(this.includePatternTableViewer));
        this.includePatternTableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)includePatternTable)});
        this.populateIncludePatternTable();
        return includePatternTable;
    }

    private Composite buildExcludeIncludePatternTableButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.wrap = false;
        rowLayout.pack = false;
        composite.setLayout((Layout)rowLayout);
        this.addExcludePatternButton = this.buildAddExcludePatternButton(composite);
        this.addIncludePatternButton = this.buildAddIncludePatternButton(composite);
        return composite;
    }

    private Button buildAddExcludePatternButton(Composite parent) {
        Button button = new Button(parent, 16392);
        button.setText(this.getMessage("preference.ruleset.button.add_exclude_pattern"));
        button.setEnabled(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PMDPreferencePage.this.ruleSet.addExcludePattern(".*/PATTERN/.*");
                PMDPreferencePage.this.setModified(true);
                PMDPreferencePage.this.excludePatternTableViewer.refresh();
            }
        });
        return button;
    }

    private Button buildAddIncludePatternButton(Composite parent) {
        Button button = new Button(parent, 16392);
        button.setText(this.getMessage("preference.ruleset.button.add_include_pattern"));
        button.setEnabled(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PMDPreferencePage.this.ruleSet.addIncludePattern(".*/PATTERN/.*");
                PMDPreferencePage.this.setModified(true);
                PMDPreferencePage.this.includePatternTableViewer.refresh();
            }
        });
        return button;
    }

    private static String asCleanString(String original) {
        return original == null ? "" : original.trim();
    }

    private void populateRuleTable() {
        RuleSet defaultRuleSet = PMDPlugin.getDefault().getPreferencesManager().getRuleSet();
        this.ruleSet = new RuleSet();
        this.ruleSet.addRuleSet(defaultRuleSet);
        this.ruleSet.setName(defaultRuleSet.getName());
        this.ruleSet.setDescription(PMDPreferencePage.asCleanString(defaultRuleSet.getDescription()));
        this.ruleSet.addExcludePatterns((Collection)defaultRuleSet.getExcludePatterns());
        this.ruleSet.addIncludePatterns((Collection)defaultRuleSet.getIncludePatterns());
        this.ruleTableViewer.setInput((Object)this.ruleSet);
    }

    private void populateExcludePatternTable() {
        this.excludePatternTableViewer.setInput((Object)this.ruleSet);
    }

    private void populateIncludePatternTable() {
        this.includePatternTableViewer.setInput((Object)this.ruleSet);
    }

    protected String getMessage(String key) {
        return PMDPlugin.getDefault().getStringTable().getString(key);
    }

    protected String getFileNameWithoutExtension(String fileName) {
        String name = fileName;
        int index = fileName.lastIndexOf(46);
        if (index != -1) {
            name = fileName.substring(0, index);
        }
        return name;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return PMDPlugin.getDefault().getPreferenceStore();
    }

    public static PMDPreferencePage getActiveInstance() {
        return activeInstance;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean isModified) {
        this.modified = isModified;
    }

    protected void refresh() {
        try {
            try {
                this.ruleTableViewer.getControl().setRedraw(false);
                this.ruleTableViewer.refresh();
                this.rulePropertiesTableViewer.refresh();
                this.excludePatternTableViewer.refresh();
                this.includePatternTableViewer.refresh();
            }
            catch (ClassCastException e) {
                PMDPlugin.getDefault().logError("Ignoring exception while refreshing table", e);
                this.ruleTableViewer.getControl().setRedraw(true);
            }
        }
        finally {
            this.ruleTableViewer.getControl().setRedraw(true);
        }
    }

    private void updateRuleSet() {
        try {
            ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(this.getShell());
            monitorDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    PMDPlugin.getDefault().getPreferencesManager().setRuleSet(PMDPreferencePage.this.ruleSet);
                }
            });
        }
        catch (InterruptedException e) {
            PMDPlugin.getDefault().logError("Exception updating all projects after a preference change", e);
        }
        catch (InvocationTargetException e) {
            PMDPlugin.getDefault().logError("Exception updating all projects after a preference change", e);
        }
    }

    private void rebuildProjects() {
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)this.getMessage("message.question.title"), (String)this.getMessage("message.question.rules_changed"))) {
            try {
                ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(this.getShell());
                monitorDialog.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            ResourcesPlugin.getWorkspace().build(6, monitor);
                        }
                        catch (CoreException e) {
                            PMDPlugin.getDefault().logError("Exception building all projects after a preference change", e);
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                PMDPlugin.getDefault().logError("Exception building all projects after a preference change", e);
            }
            catch (InvocationTargetException e) {
                PMDPlugin.getDefault().logError("Exception building all projects after a preference change", e);
            }
        }
    }

    protected void selectAndShowRule(Rule rule) {
        TableItem[] items;
        Table table = this.ruleTableViewer.getTable();
        TableItem[] tableItemArray = items = table.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            Rule itemRule = (Rule)item.getData();
            if (itemRule.equals(rule)) {
                table.setSelection(table.indexOf(item));
                table.showSelection();
                break;
            }
            ++n2;
        }
    }
}

