/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.filters;

import java.util.Collection;
import java.util.HashSet;
import net.sourceforge.pmd.eclipse.ui.filters.BasicAccessor;

class FilterHolder {
    public String pattern;
    public boolean forPMD;
    public boolean forCPD;
    public boolean isInclude;
    public static final FilterHolder[] EMPTY_HOLDERS = new FilterHolder[0];
    public static final Accessor ExcludeAccessor = new BasicAccessor(){

        @Override
        public boolean boolValueFor(FilterHolder fh) {
            return !fh.isInclude;
        }
    };
    public static final Accessor IncludeAccessor = new BasicAccessor(){

        @Override
        public boolean boolValueFor(FilterHolder fh) {
            return fh.isInclude;
        }
    };
    public static final Accessor PMDAccessor = new BasicAccessor(){

        @Override
        public boolean boolValueFor(FilterHolder fh) {
            return fh.forPMD;
        }
    };
    public static final Accessor CPDAccessor = new BasicAccessor(){

        @Override
        public boolean boolValueFor(FilterHolder fh) {
            return fh.forCPD;
        }
    };
    public static final Accessor PatternAccessor = new BasicAccessor(){

        @Override
        public String textValueFor(FilterHolder fh) {
            return fh.pattern;
        }
    };

    public FilterHolder(String thePattern, boolean pmdFlag, boolean cpdFlag, boolean isIncludeFlag) {
        this.pattern = thePattern;
        this.forPMD = pmdFlag;
        this.forCPD = cpdFlag;
        this.isInclude = isIncludeFlag;
    }

    public static Boolean boolValueOf(Collection<FilterHolder> holders, Accessor boolAccessor) {
        HashSet<Boolean> values = new HashSet<Boolean>();
        for (FilterHolder fh : holders) {
            values.add(boolAccessor.boolValueFor(fh));
        }
        int valueCount = values.size();
        return valueCount == 2 || valueCount == 0 ? null : (Boolean)values.iterator().next();
    }

    public static String textValueOf(Collection<FilterHolder> holders, Accessor textAccessor) {
        HashSet<String> values = new HashSet<String>();
        for (FilterHolder fh : holders) {
            values.add(textAccessor.textValueFor(fh));
        }
        return values.size() == 1 ? (String)values.iterator().next() : "";
    }

    public static interface Accessor {
        public boolean boolValueFor(FilterHolder var1);

        public String textValueFor(FilterHolder var1);
    }
}

