/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.sourceforge.pmd.eclipse.ui.LabelProvider;
import net.sourceforge.pmd.eclipse.ui.Shape;
import net.sourceforge.pmd.eclipse.ui.ShapeDescriptor;
import net.sourceforge.pmd.eclipse.ui.ShapePainter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ShapePicker<T>
extends Canvas
implements ISelectionProvider {
    private T[] items;
    private int itemWidth;
    private int gap = 6;
    private T selectedItem;
    private T highlightItem;
    private Color selectedItemFillColor;
    private LabelProvider tooltipProvider;
    private Map<T, ShapeDescriptor> shapeDescriptorsByItem;
    private List<ISelectionChangedListener> listeners;
    private static Map<RGB, Color> coloursByRGB = new HashMap<RGB, Color>();

    public ShapePicker(Composite parent, int style, int theItemWidth) {
        super(parent, style);
        this.itemWidth = theItemWidth;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent pe) {
                ShapePicker.this.doPaint(pe);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (!ShapePicker.this.getEnabled()) {
                    return;
                }
                Object newItem = ShapePicker.this.itemAt(e.x, e.y);
                if (newItem != ShapePicker.this.highlightItem) {
                    ShapePicker.this.highlightItem = newItem;
                    ShapePicker.this.setToolTipText(ShapePicker.this.tooltipFor(newItem));
                    ShapePicker.this.redraw();
                }
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                ShapePicker.this.forceFocus();
            }

            public void mouseUp(MouseEvent e) {
                if (!ShapePicker.this.getEnabled()) {
                    return;
                }
                Object newItem = ShapePicker.this.itemAt(e.x, e.y);
                if (newItem != ShapePicker.this.selectedItem) {
                    ShapePicker.this.selectedItem = newItem;
                    ShapePicker.this.redraw();
                    ShapePicker.this.selectionChanged();
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ShapePicker.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                ShapePicker.this.redraw();
            }
        });
        this.selectedItemFillColor = this.colorFor(new RGB(200, 200, 200));
    }

    private Color colourFor(int itemIndex) {
        ShapeDescriptor desc = this.shapeDescriptorsByItem.get(this.items[itemIndex]);
        if (desc == null) {
            return Display.getCurrent().getSystemColor(2);
        }
        RGB rgb = desc.rgbColor;
        return this.colorFor(rgb);
    }

    private String tooltipFor(T item) {
        return item == null ? "" : (this.tooltipProvider == null ? item.toString() : this.tooltipProvider.labelFor(item));
    }

    private Color colorFor(RGB rgb) {
        Color color = coloursByRGB.get(rgb);
        if (color != null) {
            return color;
        }
        color = new Color(null, rgb.red, rgb.green, rgb.blue);
        coloursByRGB.put(rgb, color);
        return color;
    }

    private void selectionChanged() {
        if (this.listeners == null) {
            return;
        }
        StructuredSelection selection = new StructuredSelection(new Object[]{this.selectedItem});
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)selection);
        for (ISelectionChangedListener listener : this.listeners) {
            listener.selectionChanged(event);
        }
    }

    public boolean forceFocus() {
        boolean state = super.forceFocus();
        this.redraw();
        return state;
    }

    private Shape shapeFor(int itemIndex) {
        ShapeDescriptor desc = this.shapeDescriptorsByItem.get(this.items[itemIndex]);
        return desc == null ? Shape.circle : desc.shape;
    }

    private T itemAt(int xIn, int yIn) {
        if (this.items == null) {
            return null;
        }
        int width = this.getSize().x;
        int xBoundary = 3;
        int i = 0;
        while (i < this.items.length) {
            int xOffset = 0;
            int step = (this.itemWidth + this.gap) * i;
            switch (16384) {
                case 0x1000000: {
                    xOffset = width / 2 - this.itemWidth / 2 - xBoundary + step;
                    break;
                }
                case 131072: {
                    xOffset = 0 - xBoundary;
                    break;
                }
                case 16384: {
                    xOffset = xBoundary + step;
                }
            }
            if (xIn < xOffset) {
                return this.items[i == 0 ? 0 : i - 1];
            }
            if (xIn < xOffset + this.itemWidth) {
                return this.items[i];
            }
            ++i;
        }
        return null;
    }

    private void doPaint(PaintEvent pe) {
        if (this.items == null) {
            return;
        }
        GC gc = pe.gc;
        int width = this.getSize().x;
        int xBoundary = 3;
        if (this.isFocusControl()) {
            gc.drawFocus(0, 0, this.getSize().x, this.getSize().y);
        }
        int i = 0;
        while (i < this.items.length) {
            gc.setBackground(this.selectedItem == this.items[i] ? this.selectedItemFillColor : this.colourFor(i));
            int xOffset = 0;
            int step = (this.itemWidth + this.gap) * i;
            switch (16384) {
                case 0x1000000: {
                    xOffset = width / 2 - this.itemWidth / 2 - xBoundary + step;
                    break;
                }
                case 131072: {
                    xOffset = 0 - xBoundary;
                    break;
                }
                case 16384: {
                    xOffset = xBoundary + step;
                }
            }
            gc.setLineWidth(this.showHighlightOn(this.items[i]) ? 3 : 1);
            ShapePainter.drawShape(this.itemWidth, this.itemWidth, this.shapeFor(i), gc, pe.x + xOffset, pe.y + this.gap, null);
            ++i;
        }
    }

    private boolean showHighlightOn(T item) {
        return this.isFocusControl() && this.highlightItem == item;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point pt = this.getSize();
        return new Point(pt.x, pt.y);
    }

    public void setSelection(T item) {
        this.selectedItem = item;
        this.redraw();
        this.selectionChanged();
    }

    public void tooltipProvider(LabelProvider provider) {
        this.tooltipProvider = provider;
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.selectedItem);
    }

    public void setGap(int inPixels) {
        this.gap = inPixels;
        this.redraw();
    }

    public void setItems(T[] theItems) {
        this.items = theItems;
        this.redraw();
    }

    public void setItemWidth(int width) {
        this.itemWidth = width;
        this.redraw();
    }

    public void setShapeMap(Map<T, ShapeDescriptor> theShapeMap) {
        this.shapeDescriptorsByItem = theShapeMap;
        this.redraw();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector<ISelectionChangedListener>();
        }
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.setSelection(((StructuredSelection)selection).getFirstElement());
    }
}

