/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.Shape;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ShapePainter {
    private static Map<String, Image> shapes = new HashMap<String, Image>();

    private ShapePainter() {
    }

    public static Image newDrawnImage(Display display, int width, int height, Shape shape, RGB transparentColour, RGB fillColour) {
        int clrIndex;
        String key = String.valueOf(width) + "x" + height + " " + (Object)((Object)shape) + " " + transparentColour + " " + fillColour;
        if (shapes.containsKey(key)) {
            return shapes.get(key);
        }
        Image image = new Image((Device)display, width, height);
        GC gc = new GC((Drawable)image);
        gc.setBackground(PMDPlugin.getDefault().colorFor(transparentColour));
        gc.fillRectangle(0, 0, width, height);
        gc.setForeground(display.getSystemColor(2));
        gc.setBackground(PMDPlugin.getDefault().colorFor(fillColour));
        ShapePainter.drawShape(width - 1, height - 1, shape, gc, 0, 0, null);
        ImageData data = image.getImageData();
        data.transparentPixel = clrIndex = data.palette.getPixel(transparentColour);
        Image newImage = new Image((Device)display, data);
        image.dispose();
        gc.dispose();
        shapes.put(key, newImage);
        return newImage;
    }

    public static void disposeAll() {
        for (Image i : shapes.values()) {
            i.dispose();
        }
        shapes.clear();
    }

    public static void drawShape(int width, int height, Shape shapeId, GC gc, int x, int y, String optionalText) {
        switch (shapeId) {
            case square: {
                gc.fillRectangle(x, y, width, height);
                gc.drawRectangle(x, y, width, height);
                break;
            }
            case circle: {
                gc.fillArc(x, y, width, height, 0, 23040);
                gc.drawArc(x, y, width, height, 0, 23040);
                break;
            }
            case domeLeft: {
                gc.fillArc(x + width / 4, y, width, height, 90, 180);
                gc.drawArc(x + width / 4, y, width, height, 90, 180);
                int threeQuarters = width / 2 + width / 4;
                gc.drawLine(x + threeQuarters, y, x + threeQuarters, y + height);
                break;
            }
            case domeRight: {
                gc.fillArc(x - width / 4, y, width, height, 270, 180);
                gc.drawArc(x - width / 4, y, width, height, 270, 180);
                gc.drawLine(x + width / 4, y, x + width / 4, y + height);
                break;
            }
            case pipe: {
                gc.fillRectangle(x + width / 4, y, width - width / 2, height);
                gc.drawRectangle(x + width / 4, y, width - width / 2, height);
                break;
            }
            case minus: {
                gc.fillRectangle(x, y + height / 4, width, height - height / 2);
                gc.drawRectangle(x, y + height / 4, width, height - height / 2);
                break;
            }
            case triangleDown: {
                gc.fillPolygon(new int[]{x, y, x + width, y, x + width / 2, y + height});
                gc.drawPolygon(new int[]{x, y, x + width, y, x + width / 2, y + height});
                break;
            }
            case triangleUp: {
                gc.fillPolygon(new int[]{x, y + height, x + width, y + height, x + width / 2, y});
                gc.drawPolygon(new int[]{x, y + height, x + width, y + height, x + width / 2, y});
                break;
            }
            case triangleRight: {
                gc.fillPolygon(new int[]{x, y + height, x + width, y + height / 2, x, y});
                gc.drawPolygon(new int[]{x, y + height, x + width, y + height / 2, x, y});
                break;
            }
            case triangleLeft: {
                gc.fillPolygon(new int[]{x, y + height / 2, x + width, y, x + width, y + height});
                gc.drawPolygon(new int[]{x, y + height / 2, x + width, y, x + width, y + height});
                break;
            }
            case triangleNorthEast: {
                gc.fillPolygon(new int[]{x, y, x + width, y, x + width, y + height});
                gc.drawPolygon(new int[]{x, y, x + width, y, x + width, y + height});
                break;
            }
            case triangleNorthWest: {
                gc.fillPolygon(new int[]{x, y, x + width, y, x, y + height});
                gc.drawPolygon(new int[]{x, y, x + width, y, x, y + height});
                break;
            }
            case triangleSouthEast: {
                gc.fillPolygon(new int[]{x, y, x + width, y + height, x, y + height});
                gc.drawPolygon(new int[]{x, y, x + width, y + height, x, y + height});
                break;
            }
            case triangleSouthWest: {
                gc.fillPolygon(new int[]{x, y + height, x + width, y + height, x + width, y});
                gc.drawPolygon(new int[]{x, y + height, x + width, y + height, x + width, y});
                break;
            }
            case roundedRect: {
                gc.fillRoundRectangle(x, y, width, height, width / 2, height / 2);
                gc.drawRoundRectangle(x, y, width, height, width / 2, height / 2);
                break;
            }
            case diamond: {
                gc.fillPolygon(new int[]{x + width / 2, y, x + width, y + height / 2, x + width / 2, y + height, x, y + height / 2});
                gc.drawPolygon(new int[]{x + width / 2, y, x + width, y + height / 2, x + width / 2, y + height, x, y + height / 2});
                break;
            }
            default: {
                int[] points = shapeId.scaledPointsTo(width, height, x, y, false, true);
                if (points.length <= 1) break;
                gc.fillPolygon(points);
                gc.drawPolygon(points);
            }
        }
        if (optionalText != null) {
            gc.drawString(optionalText, x, y);
        }
    }
}

