/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.preferences.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.eclipse.core.IRuleSetManager;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferencesManager;
import net.sourceforge.pmd.eclipse.ui.priority.PriorityDescriptor;
import org.apache.log4j.Level;

class PreferencesImpl
implements IPreferences {
    private Map<String, Boolean> booleansById = new HashMap<String, Boolean>();
    private IPreferencesManager preferencesManager;
    private boolean projectBuildPathEnabled;
    private boolean pmdPerspectiveEnabled;
    private boolean checkAfterSaveEnabled;
    private boolean useCustomPriorityNames;
    private int maxViolationsPerFilePerRule;
    private String reviewAdditionalComment;
    private boolean reviewPmdStyleEnabled;
    private int minTileSize;
    private String logFileName;
    private Level logLevel;
    private boolean globalRuleManagement;
    private Set<String> activeRuleNames = new HashSet<String>();
    private Set<String> inactiveRuleNames = new HashSet<String>();
    private Set<String> activeRendererNames = new HashSet<String>();
    private Set<String> activeExclusionPatterns = new HashSet<String>();
    private Set<String> activeInclusionPatterns = new HashSet<String>();
    private Map<RulePriority, PriorityDescriptor> uiDescriptorsByPriority = new HashMap<RulePriority, PriorityDescriptor>(5);

    public PreferencesImpl(IPreferencesManager preferencesManager) {
        this.preferencesManager = preferencesManager;
    }

    @Override
    public boolean boolFor(String prefId) {
        Boolean value = this.booleansById.get(prefId);
        if (value == null) {
            throw new IllegalArgumentException("Unknown pref id: " + prefId);
        }
        return value;
    }

    @Override
    public void boolFor(String prefId, boolean newValue) {
        this.booleansById.put(prefId, newValue);
    }

    @Override
    public boolean isProjectBuildPathEnabled() {
        return this.projectBuildPathEnabled;
    }

    @Override
    public void setProjectBuildPathEnabled(boolean projectBuildPathEnabled) {
        this.projectBuildPathEnabled = projectBuildPathEnabled;
    }

    @Override
    public boolean isPmdPerspectiveEnabled() {
        return this.pmdPerspectiveEnabled;
    }

    @Override
    public boolean isCheckAfterSaveEnabled() {
        return this.checkAfterSaveEnabled;
    }

    @Override
    public void isCheckAfterSaveEnabled(boolean flag) {
        this.checkAfterSaveEnabled = flag;
    }

    @Override
    public void setPmdPerspectiveEnabled(boolean pmdPerspectiveEnabled) {
        this.pmdPerspectiveEnabled = pmdPerspectiveEnabled;
    }

    @Override
    public int getMaxViolationsPerFilePerRule() {
        return this.maxViolationsPerFilePerRule;
    }

    @Override
    public void setMaxViolationsPerFilePerRule(int maxViolationPerFilePerRule) {
        this.maxViolationsPerFilePerRule = maxViolationPerFilePerRule;
    }

    @Override
    public String getReviewAdditionalComment() {
        return this.reviewAdditionalComment;
    }

    @Override
    public void setReviewAdditionalComment(String reviewAdditionalComment) {
        this.reviewAdditionalComment = reviewAdditionalComment;
    }

    @Override
    public boolean isReviewPmdStyleEnabled() {
        return this.reviewPmdStyleEnabled;
    }

    @Override
    public void setReviewPmdStyleEnabled(boolean reviewPmdStyleEnabled) {
        this.reviewPmdStyleEnabled = reviewPmdStyleEnabled;
    }

    @Override
    public int getMinTileSize() {
        return this.minTileSize;
    }

    @Override
    public void setMinTileSize(int minTileSize) {
        this.minTileSize = minTileSize;
    }

    @Override
    public String getLogFileName() {
        return this.logFileName;
    }

    @Override
    public Level getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogFileName(String logFileName) {
        this.logFileName = logFileName;
    }

    @Override
    public void setLogLevel(Level level) {
        this.logLevel = level;
    }

    @Override
    public void sync() {
        this.preferencesManager.storePreferences(this);
    }

    @Override
    public boolean getGlobalRuleManagement() {
        return this.globalRuleManagement;
    }

    @Override
    public void setGlobalRuleManagement(boolean b) {
        this.globalRuleManagement = b;
    }

    @Override
    public boolean isActive(String ruleName) {
        return this.activeRuleNames.contains(ruleName);
    }

    @Override
    public boolean isActiveRenderer(String rendererName) {
        return this.activeRendererNames.contains(rendererName);
    }

    @Override
    public void isActive(String ruleName, boolean isActive) {
        if (isActive) {
            this.activeRuleNames.add(ruleName);
            this.inactiveRuleNames.remove(ruleName);
        } else {
            this.activeRuleNames.remove(ruleName);
            this.inactiveRuleNames.add(ruleName);
        }
    }

    @Override
    public Set<String> getActiveRuleNames() {
        return this.activeRuleNames;
    }

    @Override
    public Set<String> getInactiveRuleNames() {
        return this.inactiveRuleNames;
    }

    @Override
    public String getDefaultActiveRules() {
        StringBuilder rules = new StringBuilder();
        IRuleSetManager ruleSetManager = PMDPlugin.getDefault().getRuleSetManager();
        for (RuleSet ruleSet : ruleSetManager.getDefaultRuleSets()) {
            for (Rule rule : ruleSet.getRules()) {
                if (rules.length() > 0) {
                    rules.append(',');
                }
                rules.append(rule.getName());
            }
        }
        return rules.toString();
    }

    @Override
    public void setInactiveRuleNames(Set<String> ruleNames) {
        this.inactiveRuleNames = ruleNames;
    }

    @Override
    public void setActiveRuleNames(Set<String> ruleNames) {
        this.activeRuleNames = ruleNames;
    }

    @Override
    public Set<String> activeExclusionPatterns() {
        return this.activeExclusionPatterns;
    }

    @Override
    public void activeExclusionPatterns(Set<String> patterns) {
        this.activeExclusionPatterns = patterns;
    }

    @Override
    public Set<String> activeInclusionPatterns() {
        return this.activeInclusionPatterns;
    }

    @Override
    public void activeInclusionPatterns(Set<String> patterns) {
        this.activeInclusionPatterns = patterns;
    }

    @Override
    public void setPriorityDescriptor(RulePriority priority, PriorityDescriptor pd) {
        this.uiDescriptorsByPriority.put(priority, pd);
    }

    @Override
    public PriorityDescriptor getPriorityDescriptor(RulePriority priority) {
        return this.uiDescriptorsByPriority.get(priority);
    }

    @Override
    public boolean useCustomPriorityNames() {
        return this.useCustomPriorityNames;
    }

    @Override
    public void useCustomPriorityNames(boolean flag) {
        this.useCustomPriorityNames = flag;
    }

    @Override
    public Set<String> activeReportRenderers() {
        return this.activeRendererNames;
    }

    @Override
    public void activeReportRenderers(Set<String> names) {
        this.activeRendererNames = names;
    }
}

