/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.core.rulesets.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.eclipse.core.PMDCoreException;
import net.sourceforge.pmd.eclipse.core.rulesets.IRuleSetsManager;
import net.sourceforge.pmd.eclipse.core.rulesets.vo.RuleSet;
import net.sourceforge.pmd.eclipse.core.rulesets.vo.RuleSets;
import net.sourceforge.pmd.eclipse.util.IOUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;

public class RuleSetsManagerImpl
implements IRuleSetsManager {
    private static final Log LOG = LogFactory.getLog(RuleSetsManagerImpl.class);
    private static final String RULESETS_MAPPING = "/net/sourceforge/pmd/eclipse/core/rulesets/impl/mapping.xml";

    @Override
    public RuleSets readFromXml(InputStream input) throws PMDCoreException {
        return null;
    }

    @Override
    public RuleSet valueOf(String[] ruleSetUrls) throws PMDCoreException {
        LOG.debug((Object)"Compting value of a collection of rule set urls");
        if (ruleSetUrls == null) {
            throw new IllegalArgumentException("ruleSetUrls cannot be null");
        }
        if (ruleSetUrls.length == 0) {
            throw new IllegalArgumentException("ruleSetsUrls cannot be empty");
        }
        try {
            RuleSet ruleSet = new RuleSet();
            String[] stringArray = ruleSetUrls;
            int n = ruleSetUrls.length;
            int n2 = 0;
            while (n2 < n) {
                String ruleSetUrl = stringArray[n2];
                RuleSetFactory factory = new RuleSetFactory();
                Collection rules = factory.createRuleSet(ruleSetUrl).getRules();
                for (Rule pmdRule : rules) {
                    net.sourceforge.pmd.eclipse.core.rulesets.vo.Rule rule = new net.sourceforge.pmd.eclipse.core.rulesets.vo.Rule();
                    rule.setRef(String.valueOf(ruleSetUrl) + '/' + pmdRule.getName());
                    rule.setPmdRule(pmdRule);
                    ruleSet.addRule(rule);
                }
                ++n2;
            }
            return ruleSet;
        }
        catch (RuleSetNotFoundException e) {
            LOG.error((Object)"A RuleSetsNotFound Exception was thrown.");
            throw new PMDCoreException("A RuleSetsNotFound Exception was thrown.", e);
        }
    }

    @Override
    public void writeToXml(RuleSets ruleSets, OutputStream output) throws PMDCoreException {
        LOG.debug((Object)"Storing plug-in rulesets");
        StringWriter writer = null;
        try {
            try {
                LocalConfiguration.getInstance().getProperties().setProperty("org.exolab.castor.indent", "true");
                Mapping mapping = new Mapping(this.getClass().getClassLoader());
                URL mappingSpecUrl = this.getClass().getResource(RULESETS_MAPPING);
                mapping.loadMapping(mappingSpecUrl);
                writer = new StringWriter();
                Marshaller marshaller = new Marshaller((Writer)writer);
                marshaller.setMapping(mapping);
                marshaller.marshal((Object)ruleSets);
                writer.flush();
                output.write(writer.getBuffer().toString().getBytes());
                output.flush();
            }
            catch (MarshalException e) {
                LOG.error((Object)"A Marshal Exception was thrown.");
                throw new PMDCoreException("A Marshal Exception was thrown.", e);
            }
            catch (ValidationException e) {
                LOG.error((Object)"A Validation Exception was thrown.");
                throw new PMDCoreException("A Validation Exception was thrown.", e);
            }
            catch (MappingException e) {
                LOG.error((Object)"A Mapping Exception was thrown.");
                throw new PMDCoreException("A Mapping Exception was thrown.", e);
            }
            catch (IOException e) {
                LOG.error((Object)"A IO Exception was thrown.");
                throw new PMDCoreException("A IO Exception was thrown.", e);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(writer);
            throw throwable;
        }
        IOUtil.closeQuietly(writer);
    }
}

