/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.NewClassCreationWizard;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.core.BeansCoreUtils;
import org.springframework.ide.eclipse.config.core.contentassist.XmlBackedContentProposalAdapter;
import org.springframework.ide.eclipse.config.core.contentassist.XmlBackedContentProposalProvider;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.core.StringUtils;
import org.springframework.ide.eclipse.wizard.Messages;
import org.springframework.ide.eclipse.wizard.core.WizardBeanReferenceContentProposalProvider;
import org.springframework.ide.eclipse.wizard.core.WizardClassContentProposalProvider;
import org.springframework.ide.eclipse.wizard.core.WizardContentAssistConverter;
import org.springframework.ide.eclipse.wizard.ui.AbstractBeanWizardPage;
import org.springframework.ide.eclipse.wizard.ui.BeanFileSelectionDialog;
import org.springframework.ide.eclipse.wizard.ui.BeanWizard;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

public class BeanWizardPage
extends AbstractBeanWizardPage {
    private Label idLabel;
    private Label nameLabel;
    private Label parentLabel;
    private Hyperlink classLink;
    private Text idText;
    private Text nameText;
    private Text classText;
    private Text parentText;
    private Text fileText;
    private Button ignoreErrorButton;
    private Button fileBrowseButton;
    private static final String DEFAULT_MESSAGE = Messages.getString("NewBeanWizardPage.TITLE_DESCRIPTION");
    private String fileErrorMessage;
    private String classErrorMessage;
    private String parentErrorMessage;
    private final Set<XmlBackedContentProposalAdapter> contentProposalAdapters;
    private WizardClassContentProposalProvider classProposalProvider;
    private WizardBeanReferenceContentProposalProvider parentProposalProvider;
    private final boolean fileBrowsingEnabled;

    public BeanWizardPage(String pageName, BeanWizard wizard, boolean fileBrowsingEnabled) {
        super(pageName, wizard);
        this.setTitle(Messages.getString("NewBeanWizardPage.TITLE"));
        if (wizard.getBeanFile() == null) {
            this.setDescription(Messages.getString("NewBeanWizardPage.ENTER_BEAN_FILE"));
        } else {
            this.setDescription(DEFAULT_MESSAGE);
        }
        this.wizard = wizard;
        this.fileBrowsingEnabled = fileBrowsingEnabled;
        this.contentProposalAdapters = new HashSet<XmlBackedContentProposalAdapter>();
    }

    private void addListener(final Text text, final String attributeName) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BeanWizardPage.this.updateAttribute(attributeName, text.getText());
            }
        });
    }

    public boolean canFlipToNextPage() {
        return this.wizard.getBeanFile() != null && (BeanWizard.getIgnoreError() || this.classText.getText().length() > 0 || this.parentText.getText().length() > 0);
    }

    private void createAttribute(String attributeName, Hyperlink link, Text text) {
        link.setText(String.valueOf(this.getDisplayText(attributeName)) + ":");
        link.setUnderlined(true);
        link.setLayoutData((Object)new GridData());
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                block10: {
                    IProject project = BeanWizardPage.this.wizard.getBeanFile().getProject();
                    String className = BeanWizardPage.this.classText.getText();
                    try {
                        if (!project.hasNature("org.eclipse.jdt.core.javanature")) break block10;
                        IJavaProject javaProject = JavaCore.create((IProject)project);
                        IType result = null;
                        if (className.length() > 0) {
                            result = javaProject.findType(className);
                        }
                        if (result != null) {
                            JavaUI.openInEditor((IJavaElement)result);
                            return;
                        }
                        NewClassWizardPage page = new NewClassWizardPage();
                        int index = className.lastIndexOf(".");
                        if (index > 0) {
                            IPackageFragment[] packageFragments;
                            String packageName = className.substring(0, index);
                            className = className.substring(index + 1);
                            IPackageFragment[] iPackageFragmentArray = packageFragments = javaProject.getPackageFragments();
                            int n = packageFragments.length;
                            int n2 = 0;
                            block2: while (n2 < n) {
                                IPackageFragment packageFragment = iPackageFragmentArray[n2];
                                if (packageFragment.getElementName().equals(packageName)) {
                                    IPackageFragmentRoot[] packageFragmentRoots;
                                    page.setPackageFragment(packageFragment, true);
                                    IPackageFragmentRoot[] iPackageFragmentRootArray = packageFragmentRoots = javaProject.getAllPackageFragmentRoots();
                                    int n3 = packageFragmentRoots.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n4];
                                        if (packageFragmentRoot.getPath().isPrefixOf(packageFragment.getPath())) {
                                            page.setPackageFragmentRoot(packageFragmentRoot, true);
                                            break block2;
                                        }
                                        ++n4;
                                    }
                                    break;
                                }
                                ++n2;
                            }
                        }
                        page.setTypeName(className, false);
                        NewClassCreationWizard wizard = new NewClassCreationWizard(page, true);
                        IWorkbench workbench = PlatformUI.getWorkbench();
                        wizard.init(workbench, null);
                        Shell shell = workbench.getActiveWorkbenchWindow().getShell();
                        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                        dialog.create();
                        dialog.getShell().setText("New Class");
                        dialog.setBlockOnOpen(true);
                        if (dialog.open() == 0) {
                            BeanWizardPage.this.validateAttribute(BeansSchemaConstants.ATTR_CLASS, className);
                        }
                    }
                    catch (CoreException coreException) {}
                }
            }
        });
        this.createAttrbute(attributeName, text);
    }

    private void createAttribute(String attributeName, Label label, Text text) {
        label.setText(String.valueOf(this.getDisplayText(attributeName)) + ":");
        label.setLayoutData((Object)new GridData());
        this.createAttrbute(attributeName, text);
    }

    private void createAttrbute(String attributeName, Text text) {
        text.setEditable(true);
        text.setLayoutData((Object)new GridData(4, 4, true, false));
        IDOMElement newBean = this.wizard.getNewBean();
        String attributeValue = null;
        if (newBean != null) {
            attributeValue = newBean.getAttribute(attributeName);
        }
        if (attributeValue != null) {
            text.setText(attributeValue);
        }
        Object proposalProvider = null;
        IFile beanFile = this.wizard.getBeanFile();
        IDOMDocument originalDocument = this.wizard.getOriginalDocument();
        if (attributeName.equals(BeansSchemaConstants.ATTR_CLASS)) {
            proposalProvider = this.classProposalProvider = new WizardClassContentProposalProvider(newBean, attributeName, beanFile, (Document)originalDocument);
        } else if (attributeName.equals(BeansSchemaConstants.ATTR_PARENT)) {
            this.parentProposalProvider = new WizardBeanReferenceContentProposalProvider(newBean, attributeName, beanFile, (Document)originalDocument);
            proposalProvider = this.parentProposalProvider;
        }
        if (proposalProvider != null) {
            this.contentProposalAdapters.add(new XmlBackedContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter(), (XmlBackedContentProposalProvider)proposalProvider));
        }
        this.addListener(text, attributeName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createFileComposite(composite);
        Composite container = new Composite(composite, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        container.setLayout((Layout)layout);
        this.idLabel = new Label(container, 0);
        this.idText = new Text(container, 2048);
        this.createAttribute(BeansSchemaConstants.ATTR_ID, this.idLabel, this.idText);
        this.nameLabel = new Label(container, 0);
        this.nameText = new Text(container, 2048);
        this.createAttribute(BeansSchemaConstants.ATTR_NAME, this.nameLabel, this.nameText);
        this.classLink = new Hyperlink(container, 4);
        Composite classContainer = new Composite(container, 0);
        GridLayout classContainerLayout = new GridLayout(2, false);
        classContainer.setLayout((Layout)classContainerLayout);
        classContainerLayout.marginHeight = 0;
        classContainerLayout.marginWidth = 0;
        classContainer.setLayoutData((Object)new GridData(4, 4, true, false));
        this.classText = new Text(classContainer, 2048);
        this.createAttribute(BeansSchemaConstants.ATTR_CLASS, this.classLink, this.classText);
        Button browseButton = new Button(classContainer, 0);
        browseButton.setText(Messages.getString("NewBeanWizardPage.BROWSE_BUTTON_LABEL"));
        browseButton.setLayoutData((Object)new GridData());
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filter = BeanWizardPage.this.classText.getText();
                if (filter == null) {
                    filter = "";
                }
                filter = filter.replace('$', '.');
                try {
                    int scope = 2;
                    SelectionDialog dialog = JavaUI.createTypeDialog((Shell)BeanWizardPage.this.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), null, (int)scope, (boolean)false, (String)filter);
                    dialog.setTitle(Messages.getString("NewBeanWizardPage.SELECT_TYPE_DIALOG_TITLE"));
                    if (dialog.open() == 0) {
                        IType type = (IType)dialog.getResult()[0];
                        String newValue = type.getFullyQualifiedName('$');
                        BeanWizardPage.this.classText.setText(newValue);
                        BeanWizardPage.this.updateAttribute(BeansSchemaConstants.ATTR_CLASS, newValue);
                    }
                }
                catch (JavaModelException ex) {
                    StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Failed to select type.", (Throwable)ex));
                }
            }
        });
        this.parentLabel = new Label(container, 0);
        this.parentText = new Text(container, 2048);
        this.createAttribute(BeansSchemaConstants.ATTR_PARENT, this.parentLabel, this.parentText);
        Composite buttonComposite = new Composite(container, 0);
        GridLayout buttonCompositeLayout = new GridLayout();
        buttonCompositeLayout.marginWidth = 0;
        buttonCompositeLayout.marginHeight = 0;
        buttonComposite.setLayout((Layout)buttonCompositeLayout);
        GridData buttonCompositeData = new GridData(4, 4, true, false);
        buttonCompositeData.horizontalSpan = 2;
        buttonComposite.setLayoutData((Object)buttonCompositeData);
        this.ignoreErrorButton = this.wizard.createIgnoreErrorButton(buttonComposite, this);
        this.ignoreErrorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BeanWizardPage.this.getWizard().getContainer().updateButtons();
                BeanWizardPage.this.updateMessage();
            }
        });
        this.updateFieldsEnablement();
        this.setControl((Control)composite);
    }

    private void createFileComposite(Composite parent) {
        Composite fileComposite = new Composite(parent, 0);
        fileComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout compositeLayout = new GridLayout(2, false);
        compositeLayout.marginBottom = 10;
        fileComposite.setLayout((Layout)compositeLayout);
        Label fileLabel = new Label(fileComposite, 0);
        fileLabel.setText(Messages.getString("NewBeanWizardPage.BEAN_FILE_LABEL"));
        GridData labelData = new GridData(4, 4, false, false);
        labelData.horizontalSpan = 2;
        fileLabel.setLayoutData((Object)labelData);
        this.fileText = new Text(fileComposite, 2048);
        this.fileText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fileText.setEditable(true);
        IFile beanFile = this.wizard.getBeanFile();
        if (beanFile != null) {
            this.fileText.setText(beanFile.getFullPath().toOSString());
        }
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String filePath = BeanWizardPage.this.fileText.getText();
                if (filePath.length() == 0) {
                    BeanWizardPage.this.fileErrorMessage = Messages.getString("NewBeanWizardPage.EMPTY_BEAN_FILE");
                } else {
                    IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(filePath));
                    BeanWizardPage.this.validateFile(resource);
                }
            }
        });
        this.fileBrowseButton = new Button(fileComposite, 8);
        this.fileBrowseButton.setText(Messages.getString("NewBeanWizardPage.BROWSE_BEAN_FILE"));
        this.fileBrowseButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.fileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selection;
                BeanFileSelectionDialog dialog = new BeanFileSelectionDialog(BeanWizardPage.this.getShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
                dialog.setTitle(Messages.getString("NewBeanWizardPage.BEAN_SELECTION_DIALOG_TITLE"));
                int status = dialog.open();
                if (status == 0 && (selection = dialog.getFirstResult()) != null && selection instanceof IFile) {
                    IFile beanFile = (IFile)selection;
                    BeanWizardPage.this.fileText.setText(beanFile.getFullPath().toOSString());
                    BeanWizardPage.this.validateFile((IResource)beanFile);
                }
            }
        });
        this.fileText.setEnabled(this.fileBrowsingEnabled);
        this.fileBrowseButton.setEnabled(this.fileBrowsingEnabled);
    }

    public String getClassName() {
        return this.getInputText(this.classText);
    }

    private String getDisplayText(String attributeName) {
        return StringUtils.capitalize((String)attributeName);
    }

    public String getId() {
        return this.getInputText(this.idText);
    }

    private String getInputText(Text text) {
        String inputText;
        if (text != null && (inputText = text.getText()) != null) {
            return inputText;
        }
        return "";
    }

    public String getName() {
        return this.getInputText(this.nameText);
    }

    public boolean isPageComplete() {
        if (this.wizard.getBeanFile() == null) {
            return false;
        }
        if (this.getErrorMessage() != null && !BeanWizard.getIgnoreError()) {
            return false;
        }
        return super.isPageComplete();
    }

    private void updateAttribute(String attributeName, String value) {
        IDOMElement newBean = this.wizard.getNewBean();
        if (value.length() > 0) {
            if (newBean.getAttributeNode(attributeName) != null) {
                newBean.setAttribute(attributeName, value);
            } else {
                ArrayList<Attr> attributes = new ArrayList<Attr>();
                boolean found = false;
                String[] stringArray = BeanWizard.ATTRIBUTES;
                int n = BeanWizard.ATTRIBUTES.length;
                int n2 = 0;
                while (n2 < n) {
                    Attr attributeNode;
                    String currAttributeName = stringArray[n2];
                    if (currAttributeName == attributeName) {
                        found = true;
                    } else if (found && (attributeNode = newBean.getAttributeNode(currAttributeName)) != null) {
                        attributes.add(attributeNode);
                        newBean.removeAttributeNode(attributeNode);
                    }
                    ++n2;
                }
                newBean.setAttribute(attributeName, value);
                for (Attr attribute : attributes) {
                    newBean.setAttributeNode(attribute);
                }
            }
        } else {
            newBean.removeAttribute(attributeName);
        }
        this.validateAttribute(attributeName, value);
    }

    private void updateFieldsEnablement() {
        boolean enabled = this.fileErrorMessage == null && this.wizard.getBeanFile() != null;
        this.idText.setEnabled(enabled);
        this.nameText.setEnabled(enabled);
        this.classText.setEnabled(enabled);
        this.parentText.setEnabled(enabled);
        this.ignoreErrorButton.setEnabled(enabled);
    }

    public void updateMessage() {
        if (this.fileErrorMessage != null) {
            this.setDialogMessage(this.fileErrorMessage, false);
        } else if (this.classErrorMessage != null) {
            this.setDialogMessage(this.classErrorMessage, true);
        } else if (this.parentErrorMessage != null) {
            this.setDialogMessage(this.parentErrorMessage, true);
        } else {
            this.setMessage(DEFAULT_MESSAGE);
        }
        this.getWizard().getContainer().updateButtons();
    }

    private void validateAttribute(String attributeName, String value) {
        IDOMElement newBean = this.wizard.getNewBean();
        WizardContentAssistConverter contentAssistConverter = new WizardContentAssistConverter((IDOMNode)newBean, newBean.getAttributeNode(attributeName), this.wizard.getBeanFile(), this.wizard.getOriginalDocument());
        if (attributeName.equals(BeansSchemaConstants.ATTR_CLASS)) {
            Set classAttributeProposals;
            this.classErrorMessage = value.length() > 0 ? ((classAttributeProposals = contentAssistConverter.getClassAttributeProposals(value, true)).isEmpty() ? Messages.getString("NewBeanWizardPage.UNKNOW_CLASS_MESSAGE") : null) : null;
        } else if (attributeName.equals(BeansSchemaConstants.ATTR_PARENT)) {
            Set referenceableBeanDescriptions;
            this.parentErrorMessage = value.length() > 0 ? ((referenceableBeanDescriptions = contentAssistConverter.getReferenceableBeanDescriptions(value, true)).isEmpty() ? Messages.getString("NewBeanWizardPage.UNKNOWN_PARENT_MESSAGE") : null) : null;
        }
        this.updateMessage();
    }

    private void validateFields() {
        this.validateAttribute(BeansSchemaConstants.ATTR_CLASS, this.classText.getText());
        this.validateAttribute(BeansSchemaConstants.ATTR_PARENT, this.parentText.getText());
    }

    private void validateFile(IResource beanFile) {
        if (beanFile != null && BeansCoreUtils.isBeansConfig((IResource)beanFile)) {
            this.wizard.setBeanFile((IFile)beanFile);
            this.fileErrorMessage = null;
            this.validateFields();
            this.classProposalProvider.setFile((IFile)beanFile);
            this.parentProposalProvider.setFile((IFile)beanFile);
            this.classProposalProvider.setDocument((Document)this.wizard.getOriginalDocument());
            this.parentProposalProvider.setDocument((Document)this.wizard.getOriginalDocument());
            for (XmlBackedContentProposalAdapter contentProposalAdapter : this.contentProposalAdapters) {
                contentProposalAdapter.update(this.wizard.getNewBean());
            }
        } else {
            this.fileErrorMessage = Messages.getString("NewBeanWizardPage.BEAN_FILE_ERROR");
        }
        this.updateMessage();
        this.updateFieldsEnablement();
    }
}

