/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template.infrastructure.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.ide.eclipse.wizard.template.infrastructure.ui.WizardUIInfoElement;
import org.springframework.ide.eclipse.wizard.template.infrastructure.ui.WizardUIInfoPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WizardUIInfo {
    private static final String PROJECT_NAME = "projectName";
    private ArrayList<WizardUIInfoElement> elements;
    private ArrayList<WizardUIInfoPage> pages;
    private String topLevelPackage;
    private String projectName;

    public List<WizardUIInfoElement> getElementsForPage(int page) {
        ArrayList<WizardUIInfoElement> pageElements = new ArrayList<WizardUIInfoElement>();
        if (this.elements != null) {
            for (WizardUIInfoElement element : this.elements) {
                if (element.getPage() != page) continue;
                pageElements.add(element);
            }
        }
        Collections.sort(pageElements, new OrderComparator());
        return pageElements;
    }

    public WizardUIInfoPage getPage(int order) {
        for (WizardUIInfoPage page : this.pages) {
            if (page.getOrder() != order) continue;
            return page;
        }
        WizardUIInfoPage defaultPage = WizardUIInfoPage.getDefaultPage(order);
        this.pages.add(defaultPage);
        return defaultPage;
    }

    public int getPageCount() {
        if (this.elements == null || this.elements.size() == 0) {
            return 1;
        }
        WizardUIInfoElement element = Collections.max(this.elements, new PageComparator());
        return element.getPage() + 1;
    }

    public String getProjectNameToken() {
        if (this.projectName == null) {
            return PROJECT_NAME;
        }
        return this.projectName;
    }

    public String[] getTopLevelPackageTokens() {
        if (this.topLevelPackage != null) {
            return this.topLevelPackage.split("\\.");
        }
        return new String[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OrderComparator
    implements Comparator<WizardUIInfoElement> {
        OrderComparator() {
        }

        @Override
        public int compare(WizardUIInfoElement o1, WizardUIInfoElement o2) {
            return o1.getOrder() - o2.getOrder();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PageComparator
    implements Comparator<WizardUIInfoElement> {
        PageComparator() {
        }

        @Override
        public int compare(WizardUIInfoElement o1, WizardUIInfoElement o2) {
            return o1.getPage() - o2.getPage();
        }
    }
}

