/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.PlatformUI;
import org.springframework.ide.eclipse.wizard.template.ErrorUtils;
import org.springframework.ide.eclipse.wizard.template.ITemplateWizardPage;
import org.springframework.ide.eclipse.wizard.template.NewSpringProjectWizard;
import org.springframework.ide.eclipse.wizard.template.NewTemplateWizardPage;
import org.springframework.ide.eclipse.wizard.template.ProjectConfiguration;
import org.springframework.ide.eclipse.wizard.template.ProjectWizardDescriptor;
import org.springframework.ide.eclipse.wizard.template.SimpleProject;
import org.springframework.ide.eclipse.wizard.template.SpringProjectWizardSection;
import org.springframework.ide.eclipse.wizard.template.TemplateDataUIJob;
import org.springframework.ide.eclipse.wizard.template.TemplateInputCollector;
import org.springframework.ide.eclipse.wizard.template.TemplateProjectConfiguration;
import org.springframework.ide.eclipse.wizard.template.TemplateProjectConfigurationDescriptor;
import org.springframework.ide.eclipse.wizard.template.TemplateUtils;
import org.springframework.ide.eclipse.wizard.template.infrastructure.Template;
import org.springframework.ide.eclipse.wizard.template.infrastructure.ui.WizardUIInfo;
import org.springframework.ide.eclipse.wizard.template.infrastructure.ui.WizardUIInfoElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateWizardSection
extends SpringProjectWizardSection {
    protected ITemplateWizardPage firstTemplatePage = null;

    public TemplateWizardSection(NewSpringProjectWizard wizard) {
        super(wizard);
    }

    @Override
    public boolean canProvide(ProjectWizardDescriptor descriptor) {
        return descriptor != null && descriptor.getTemplate() != null && !"org.springframework.templates.simple.java".equals(descriptor.getTemplate().getItem().getId());
    }

    public List<TemplateInputCollector> getTemplateInputHandlers() {
        ArrayList<TemplateInputCollector> handlers = new ArrayList<TemplateInputCollector>();
        ITemplateWizardPage page = this.firstTemplatePage;
        while (page != null) {
            TemplateInputCollector handler;
            if (page instanceof NewTemplateWizardPage && (handler = ((NewTemplateWizardPage)page).getInputHandler()) != null) {
                handlers.add(handler);
            }
            page = page.getNextPage();
        }
        return handlers;
    }

    @Override
    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.getWizard().getMainPage()) {
            WizardUIInfo info;
            final Template template = (Template)this.getWizard().getModel().selectedTemplate.getValue();
            this.firstTemplatePage = null;
            if (template == null) {
                return null;
            }
            if (template instanceof SimpleProject && !((SimpleProject)template).hasWizardPages()) {
                return null;
            }
            if (!TemplateUtils.hasBeenDownloaded(template)) {
                final IStatus[] errors = new IStatus[1];
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        try {
                            TemplateWizardSection.this.getWizard().getContainer().run(true, true, (IRunnableWithProgress)new TemplateDataUIJob(template, TemplateWizardSection.this.getWizard().getShell()));
                        }
                        catch (InvocationTargetException ce) {
                            String errorMessage = ErrorUtils.getErrorMessage(ce);
                            errors[0] = new Status(4, "org.springframework.ide.eclipse.wizard", errorMessage, (Throwable)ce);
                        }
                        catch (InterruptedException interruptedException) {
                            errors[0] = new Status(4, "org.springframework.ide.eclipse.wizard", "Interrupt exception while downloading data for " + template.getName());
                        }
                    }
                });
                if (errors[0] != null && !errors[0].isOK()) {
                    this.handleError(errors[0]);
                    return null;
                }
                this.getWizard().getMainPage().refreshTemplateInUI();
            }
            if ((info = this.getUIInfo(template)) == null || !this.hasTemplateWizardPages()) {
                this.getWizard().getContainer().updateButtons();
                return null;
            }
            NewTemplateWizardPage previousPage = null;
            NewTemplateWizardPage templatePage = null;
            NewTemplateWizardPage firstPage = null;
            try {
                int i = 0;
                while (i < info.getPageCount()) {
                    List<WizardUIInfoElement> pageElements = info.getElementsForPage(i);
                    if (pageElements != null && !pageElements.isEmpty()) {
                        templatePage = new NewTemplateWizardPage(info.getPage(i).getDescription(), template, new TemplateInputCollector(pageElements));
                        templatePage.setWizard((IWizard)this.getWizard());
                        if (firstPage == null) {
                            firstPage = templatePage;
                        }
                        if (previousPage != null) {
                            previousPage.setNextPage(templatePage);
                        }
                        previousPage = templatePage;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                String error = ErrorUtils.getErrorMessage("Failed to load wizard page for project template for " + template.getName(), e);
                this.handleError((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", error, (Throwable)e));
            }
            this.firstTemplatePage = firstPage;
            return this.firstTemplatePage;
        }
        return null;
    }

    @Override
    public boolean canFinish() {
        Template template;
        boolean canFinish = super.canFinish();
        if (canFinish && !((template = (Template)this.getWizard().getModel().selectedTemplate.getValue()) instanceof SimpleProject)) {
            WizardUIInfo info;
            canFinish = TemplateUtils.hasBeenDownloaded(template) ? ((info = this.getUIInfo(template)) == null ? false : info.getPageCount() == 0 || info.getElementsForPage(0) == null || info.getElementsForPage(0).isEmpty() || this.firstTemplatePage != null && this.firstTemplatePage.isPageComplete()) : false;
        }
        return canFinish;
    }

    @Override
    public boolean hasNextPage(IWizardPage currentPage) {
        if (currentPage == this.getWizard().getMainPage()) {
            Template template = (Template)this.getWizard().getModel().selectedTemplate.getValue();
            if (template == null) {
                return false;
            }
            if (template instanceof SimpleProject) {
                return ((SimpleProject)template).hasWizardPages();
            }
            return this.hasTemplateWizardPages();
        }
        return false;
    }

    protected boolean hasTemplateWizardPages() {
        Template template = (Template)this.getWizard().getModel().selectedTemplate.getValue();
        if (template == null || template instanceof SimpleProject) {
            return false;
        }
        if (TemplateUtils.hasBeenDownloaded(template)) {
            WizardUIInfo info = this.getUIInfo(template);
            return info != null && info.getPageCount() > 0 && info.getElementsForPage(0) != null && !info.getElementsForPage(0).isEmpty();
        }
        return true;
    }

    @Override
    public ProjectConfiguration getProjectConfiguration() throws CoreException {
        Template template = (Template)this.getWizard().getModel().selectedTemplate.getValue();
        WizardUIInfo uiInfo = this.getUIInfo(template);
        if (uiInfo == null) {
            throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Failed to read template wizard UI info file for template: " + template.getName() + ". Check the template installation location and verify that the files are accessible."));
        }
        String projectName = (String)this.getWizard().getModel().projectName.getValue();
        String uriValue = (String)this.getWizard().getModel().projectLocation.getValue();
        URI uri = uriValue != null ? new File(uriValue).toURI() : null;
        TemplateProjectConfigurationDescriptor descriptor = new TemplateProjectConfigurationDescriptor(uiInfo.getProjectNameToken(), projectName, uiInfo.getTopLevelPackageTokens(), template, uri, this.getTemplateInputHandlers(), this.getWizard().getMainPage().getVersion());
        return new TemplateProjectConfiguration(descriptor, this.getWizard().getShell());
    }
}

