/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageTwo;
import org.eclipse.jface.wizard.IWizardPage;
import org.springframework.ide.eclipse.wizard.template.JavaProjectConfiguration;
import org.springframework.ide.eclipse.wizard.template.JavaProjectConfigurationDescriptor;
import org.springframework.ide.eclipse.wizard.template.NewSpringProjectCreationPage;
import org.springframework.ide.eclipse.wizard.template.NewSpringProjectWizard;
import org.springframework.ide.eclipse.wizard.template.ProjectConfiguration;
import org.springframework.ide.eclipse.wizard.template.ProjectWizardDescriptor;
import org.springframework.ide.eclipse.wizard.template.SpringProjectWizardSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaWizardSection
extends SpringProjectWizardSection {
    private NewJavaProjectWizardPageTwo javaPageTwo;
    private NewSpringProjectCreationPage springCreationPage;

    public JavaWizardSection(NewSpringProjectWizard wizard) {
        super(wizard);
    }

    @Override
    public List<IWizardPage> loadPages() {
        ArrayList<IWizardPage> pages = new ArrayList<IWizardPage>();
        this.springCreationPage = new NewSpringProjectCreationPage();
        pages.add((IWizardPage)this.springCreationPage);
        this.javaPageTwo = new NewJavaProjectWizardPageTwo((NewJavaProjectWizardPageOne)this.springCreationPage);
        pages.add((IWizardPage)this.javaPageTwo);
        return pages;
    }

    public IJavaElement getCreatedElement() {
        return this.javaPageTwo.getJavaProject();
    }

    protected void refreshProjectValues() {
        if (this.springCreationPage != null) {
            String projectName = (String)this.getWizard().getModel().projectName.getValue();
            String uriValue = (String)this.getWizard().getModel().projectLocation.getValue();
            URI projectLocationURI = uriValue != null ? new File(uriValue).toURI() : null;
            String projectNameInSpringPage = this.springCreationPage.getProjectName();
            URI projectLocationInSpringURI = this.springCreationPage.getProjectLocationURI();
            if (!this.areEqual(projectLocationURI, projectLocationInSpringURI, projectName, projectNameInSpringPage)) {
                this.springCreationPage.setProjectLocationURI(projectLocationURI);
                this.springCreationPage.setProjectName(projectName);
            }
        }
    }

    protected boolean areEqual(URI actualURI, URI uriInSpringPage, String actualName, String inSpringPageName) {
        boolean equals = false;
        if (actualName == inSpringPageName) {
            equals = true;
        } else {
            boolean bl = equals = actualName != null ? actualName.equals(inSpringPageName) : false;
        }
        if (equals) {
            equals = actualURI == uriInSpringPage ? true : (actualURI != null ? actualURI.equals(uriInSpringPage) : false);
        }
        return equals;
    }

    @Override
    public boolean canProvide(ProjectWizardDescriptor descriptor) {
        return descriptor != null && descriptor.getTemplate() != null && "org.springframework.templates.simple.java".equals(descriptor.getTemplate().getItem().getId());
    }

    @Override
    public boolean hasNextPage(IWizardPage currentPage) {
        return currentPage == this.getWizard().getMainPage() || currentPage == this.springCreationPage;
    }

    @Override
    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.springCreationPage) {
            return this.javaPageTwo;
        }
        if (page == this.getWizard().getMainPage()) {
            this.springCreationPage.refreshProjectValues();
            return this.springCreationPage;
        }
        return null;
    }

    @Override
    public void cancel() {
        this.javaPageTwo.performCancel();
    }

    @Override
    public ProjectConfiguration getProjectConfiguration() throws CoreException {
        if (this.springCreationPage != null) {
            JavaProjectConfigurationDescriptor javaDescriptor = new JavaProjectConfigurationDescriptor(this.springCreationPage.getConfigSuffixes(), this.springCreationPage.enableImports(), this.springCreationPage.enableProjectFacets(), this.springCreationPage.ignoreMissingNamespaceHandlers(), this.springCreationPage.disableNamespaceCaching(), this.springCreationPage.useHighestXsdVersion(), this.springCreationPage.useProjectSettings(), this.springCreationPage.loadHandlerFromClasspath());
            return new JavaProjectConfiguration(javaDescriptor){

                protected IProject create(IProgressMonitor monitor) throws CoreException {
                    try {
                        JavaWizardSection.this.springCreationPage.performFinish();
                        JavaWizardSection.this.javaPageTwo.performFinish(monitor);
                    }
                    catch (InterruptedException e) {
                        throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", e.getMessage(), (Throwable)e));
                    }
                    return ((IJavaProject)JavaWizardSection.this.getCreatedElement()).getProject();
                }
            };
        }
        return null;
    }
}

