/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.guides;

import java.util.HashMap;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.misc.StringMatcher;
import org.springframework.ide.eclipse.wizard.WizardPlugin;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.ContentManager;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.ContentType;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.Describable;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.DisplayNameable;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.GSContent;
import org.springframework.ide.eclipse.wizard.gettingstarted.guides.SelectionModel;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChooseTypedContentSection
extends WizardPageSection {
    private static final LabelProvider labelProvider = new LabelProvider(){

        public String getText(Object element) {
            if (element instanceof DisplayNameable) {
                DisplayNameable item = (DisplayNameable)element;
                return item.getDisplayName();
            }
            if (element instanceof Throwable) {
                return ExceptionUtil.getMessage((Throwable)((Throwable)element));
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof Throwable) {
                return JFaceResources.getImage((String)"dialog_message_error_image");
            }
            return null;
        }
    };
    private String sectionLabel;
    private final SelectionModel<GSContent> selection;
    private Text searchBox;
    private ChoicesFilter filter;
    private final ContentManager content;
    private final ContentProvider contentProvider;
    private final LiveVariable<Object> rawSelection;
    private TreeViewer treeviewer;
    private String initialFilterText;
    private String category;

    public ChooseTypedContentSection(IPageWithSections owner, SelectionModel<GSContent> selection, LiveVariable<Object> rawSelection, ContentManager content) {
        super(owner);
        this.selection = selection;
        this.rawSelection = rawSelection;
        this.content = content;
        this.contentProvider = new ContentProvider(content);
    }

    public LiveExpression<ValidationResult> getValidator() {
        return this.selection.validator;
    }

    public void createContents(Composite page) {
        Composite field = new Composite(page, 0);
        int cols = this.sectionLabel == null ? 1 : 2;
        GridLayout layout = GridLayoutFactory.fillDefaults().numColumns(cols).create();
        field.setLayout((Layout)layout);
        this.searchBox = new Text(field, 2436);
        this.searchBox.setMessage("Type pattern to match");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.searchBox);
        Label fieldNameLabel = null;
        if (this.sectionLabel != null) {
            fieldNameLabel = new Label(field, 0);
            fieldNameLabel.setText(this.sectionLabel);
        }
        this.treeviewer = new TreeViewer(field, 2564);
        this.filter = new ChoicesFilter();
        this.treeviewer.addFilter((ViewerFilter)this.filter);
        this.treeviewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeviewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeviewer.setInput((Object)this.content);
        this.treeviewer.expandAll();
        if (fieldNameLabel != null) {
            GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)fieldNameLabel);
        }
        GridDataFactory grab = GridDataFactory.fillDefaults().grab(true, true).hint(-1, 150);
        grab.applyTo((Control)field);
        grab.applyTo(this.treeviewer.getControl());
        this.whenVisible(this.treeviewer.getControl(), new Runnable(){

            public void run() {
                GSContent preSelect = (GSContent)((ChooseTypedContentSection)ChooseTypedContentSection.this).selection.selection.getValue();
                if (preSelect != null) {
                    ChooseTypedContentSection.this.treeviewer.setSelection((ISelection)new StructuredSelection((Object)preSelect), true);
                } else {
                    ChooseTypedContentSection.this.treeviewer.setSelection((ISelection)StructuredSelection.EMPTY, true);
                }
                if (ChooseTypedContentSection.this.initialFilterText != null) {
                    ChooseTypedContentSection.this.searchBox.setText(ChooseTypedContentSection.this.initialFilterText);
                    ChooseTypedContentSection.this.updateFilter();
                }
                if (ChooseTypedContentSection.this.category != null) {
                    ContentType<?>[] contentTypes;
                    ContentType<?> expand = null;
                    ContentType<?>[] contentTypeArray = contentTypes = ChooseTypedContentSection.this.content.getTypes();
                    int n = contentTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ContentType<?> contentType = contentTypeArray[n2];
                        if (contentType.getDisplayName().equals(ChooseTypedContentSection.this.category)) {
                            expand = contentType;
                            break;
                        }
                        ++n2;
                    }
                    if (expand != null) {
                        ChooseTypedContentSection.this.treeviewer.setExpandedElements(new Object[]{expand});
                    }
                }
            }
        });
        this.treeviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = ChooseTypedContentSection.this.treeviewer.getSelection();
                if (sel.isEmpty()) {
                    this.setSelection(null);
                } else if (sel instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)sel;
                    this.setSelection(ss.getFirstElement());
                }
            }

            private void setSelection(Object e) {
                if (e == null) {
                    ((ChooseTypedContentSection)ChooseTypedContentSection.this).selection.selection.setValue(null);
                    ChooseTypedContentSection.this.rawSelection.setValue(null);
                } else {
                    ChooseTypedContentSection.this.rawSelection.setValue(e);
                    if (e instanceof GSContent) {
                        ((ChooseTypedContentSection)ChooseTypedContentSection.this).selection.selection.setValue((Object)((GSContent)e));
                    }
                }
            }
        });
        this.searchBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChooseTypedContentSection.this.updateFilter();
            }
        });
    }

    private void whenVisible(final Control control, final Runnable runnable) {
        PaintListener l = new PaintListener(){

            public void paintControl(PaintEvent e) {
                runnable.run();
                control.removePaintListener((PaintListener)this);
            }
        };
        control.addPaintListener(l);
    }

    public void setFilterText(String text) {
        if (this.searchBox != null) {
            this.searchBox.setText(text);
            this.updateFilter();
        } else {
            this.initialFilterText = text;
        }
    }

    public void setCategory(String category) {
        this.category = category;
    }

    private void updateFilter() {
        this.filter.setSearchTerm(this.searchBox.getText());
        this.treeviewer.refresh();
        this.treeviewer.expandAll();
    }

    private class ChoicesFilter
    extends ViewerFilter {
        private StringMatcher matcher = null;
        private final HashMap<Object, Boolean> cache = new HashMap();

        public ChoicesFilter() {
            if (ChooseTypedContentSection.this.searchBox != null) {
                this.setSearchTerm(ChooseTypedContentSection.this.searchBox.getText());
            }
        }

        public void setSearchTerm(String text) {
            this.matcher = new StringMatcher(text, true, false);
            this.cache.clear();
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.matcher == null) {
                return true;
            }
            Boolean v = this.cache.get(element);
            if (v == null) {
                v = this.compute(viewer, parentElement, element);
                this.cache.put(element, v);
            }
            return v;
        }

        public boolean compute(Viewer viewer, Object parentElement, Object e) {
            String label = labelProvider.getText(e);
            if (e instanceof ContentType) {
                return this.matchChildren(viewer, e);
            }
            if (this.match(label)) {
                return true;
            }
            return e instanceof Describable && this.match(((Describable)e).getDescription());
        }

        private boolean matchChildren(Viewer viewer, Object e) {
            Object[] children = ChooseTypedContentSection.this.contentProvider.getChildren(e);
            if (children != null) {
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object c = objectArray[n2];
                    if (this.select(viewer, e, c)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        private boolean match(String text) {
            if (this.matcher == null) {
                return true;
            }
            if (text == null) {
                return false;
            }
            StringMatcher.Position x = this.matcher.find(text, 0, text.length());
            return x != null;
        }
    }

    private static class ContentProvider
    implements ITreeContentProvider {
        private final ContentManager content;

        public ContentProvider(ContentManager content) {
            this.content = content;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object e) {
            Object[] types;
            if (e == this.content && (types = this.content.getTypes()) != null) {
                if (types.length == 1) {
                    return this.getChildren(types[0]);
                }
                return types;
            }
            return null;
        }

        public Object[] getChildren(Object e) {
            try {
                if (e instanceof ContentType) {
                    return this.content.get((ContentType)e);
                }
                return null;
            }
            catch (Throwable error) {
                WizardPlugin.log(error);
                return new Object[]{error};
            }
        }

        public Object getParent(Object e) {
            if (e instanceof GSContent) {
                return e.getClass();
            }
            if (e instanceof Class) {
                return this.content;
            }
            return null;
        }

        public boolean hasChildren(Object e) {
            Object[] c = this.getChildren(e);
            return c != null && c.length > 0;
        }
    }
}

