/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.content;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.springframework.ide.eclipse.wizard.WizardPlugin;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.CodeSet;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.DownloadableItem;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.UIThreadDownloadDisallowed;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFileCodeSet
extends CodeSet {
    private static final boolean DEBUG = false;
    private final DownloadableItem zipDownload;
    private final IPath root;
    private Map<String, CodeSet.CodeSetEntry> entries = null;

    private void debug(String msg) {
    }

    private synchronized void ensureEntryCache() throws Exception, UIThreadDownloadDisallowed {
        if (this.entries == null) {
            this.debug(">>> caching codeset entries " + this);
            final HashMap<String, CodeSet.CodeSetEntry> newEntries = new HashMap<String, CodeSet.CodeSetEntry>(1024);
            this.each(new CodeSet.Processor<Void>(){

                @Override
                public Void doit(CodeSet.CodeSetEntry e) throws Exception {
                    ZipFileCodeSet.this.debug(e.getPath().toString());
                    newEntries.put(e.getPath().toString(), e);
                    return null;
                }
            });
            this.entries = newEntries;
            this.debug("<<< cached codeset entries " + this.entries.size());
        }
    }

    ZipFileCodeSet(String name, DownloadableItem zip, IPath root) {
        super(name);
        this.zipDownload = zip;
        this.root = root.makeRelative();
    }

    public String toString() {
        return "ZipCodeSet(" + this.name + ", " + this.zipDownload.getURL() + "@" + this.root + ")";
    }

    @Override
    public boolean exists() throws Exception {
        this.ensureEntryCache();
        return !this.entries.isEmpty();
    }

    @Override
    public boolean hasFile(IPath path) throws UIThreadDownloadDisallowed {
        try {
            this.ensureEntryCache();
            return this.entries.containsKey(this.fileKey(path));
        }
        catch (UIThreadDownloadDisallowed e) {
            throw e;
        }
        catch (Exception e) {
            WizardPlugin.log(e);
            return false;
        }
    }

    @Override
    public boolean hasFolder(IPath path) {
        try {
            this.ensureEntryCache();
            return this.entries.containsKey(this.folderKey(path));
        }
        catch (Exception e) {
            WizardPlugin.log(e);
            return false;
        }
    }

    private String folderKey(IPath _path) {
        String path = this.fileKey(_path);
        if (!path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        return path;
    }

    private String fileKey(IPath path) {
        path = path.makeRelative();
        return path.toString();
    }

    /*
     * Exception decompiling
     */
    @Override
    public <T> T each(CodeSet.Processor<T> processor) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public <T> T readFileEntry(String path, CodeSet.Processor<T> processor) throws Exception {
        T t;
        ZipFile zip = new ZipFile(this.zipDownload.getFile());
        try {
            String entryName = this.root.append(path).toString();
            ZipEntry entry = zip.getEntry(entryName);
            t = processor.doit(entry == null ? null : this.csEntry(zip, entry));
        }
        catch (Throwable throwable) {
            try {
                zip.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            zip.close();
        }
        catch (IOException iOException) {}
        return t;
    }

    private CodeSet.CodeSetEntry csEntry(final ZipFile zip, final ZipEntry e) {
        Path zipPath = new Path(e.getName());
        Assert.isTrue((boolean)this.root.isPrefixOf((IPath)zipPath));
        final IPath csPath = zipPath.removeFirstSegments(this.root.segmentCount());
        return new CodeSet.CodeSetEntry(this){

            public IPath getPath() {
                return csPath;
            }

            public String toString() {
                return this.getPath() + " in " + ZipFileCodeSet.this.zipDownload;
            }

            public boolean isDirectory() {
                return e.isDirectory();
            }

            public InputStream getData() throws IOException {
                return zip.getInputStream(e);
            }
        };
    }
}

