/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectImportResult;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.SpringCorePreferences;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.maven.internal.core.MavenClasspathUpdateJob;

public class MavenCorePlugin
extends AbstractUIPlugin {
    private static final String M2ECLIPSE_CLASS = "org.eclipse.m2e.core.MavenPlugin";
    private static final String M2ECLIPSE_LEGACY_CLASS = "org.maven.ide.eclipse.MavenPlugin";
    public static final boolean IS_M2ECLIPSE_PRESENT = MavenCorePlugin.isPresent("org.eclipse.m2e.core.MavenPlugin");
    public static final boolean IS_LEGACY_M2ECLIPSE_PRESENT = MavenCorePlugin.isPresent("org.maven.ide.eclipse.MavenPlugin");
    public static final String PLUGIN_ID = "org.springframework.ide.eclipse.maven";
    public static final String AUTOMATICALLY_UPDATE_DEPENDENCIES_KEY = "maven.automatically.update";
    public static final boolean AUTOMATICALLY_UPDATE_DEPENDENCIES_DEFAULT = false;
    public static final String M2ECLIPSE_NATURE = "org.eclipse.m2e.core.maven2Nature";
    public static final String M2ECLIPSE_LEGACY_NATURE = "org.maven.ide.eclipse.maven2Nature";
    private static MavenCorePlugin plugin;
    private IResourceChangeListener resourceChangeListener;

    private static boolean isPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        if (IS_M2ECLIPSE_PRESENT || IS_LEGACY_M2ECLIPSE_PRESENT) {
            this.resourceChangeListener = new PomResourceChangeListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        if (this.resourceChangeListener != null && (IS_M2ECLIPSE_PRESENT || IS_LEGACY_M2ECLIPSE_PRESENT)) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        }
    }

    public static MavenCorePlugin getDefault() {
        return plugin;
    }

    public void scheduleClasspathUpdateJob(IProject project) {
        if (IS_M2ECLIPSE_PRESENT) {
            MavenClasspathUpdateJob.scheduleClasspathContainerUpdateJob(project);
        }
    }

    public static void createEclipseProjectFromExistingMavenProject(File pomFile, IProgressMonitor monitor) throws CoreException {
        Model model = MavenPlugin.getMavenModelManager().readMavenModel(pomFile);
        String derivedProjectName = model.getName();
        if (derivedProjectName == null) {
            derivedProjectName = model.getArtifactId();
        }
        if (derivedProjectName == null) {
            String[] groupPieces = model.getGroupId().split("\\.");
            int lastIndex = groupPieces.length - 1;
            if (lastIndex >= 0) {
                derivedProjectName = groupPieces[lastIndex];
            } else {
                String message = NLS.bind((String)"Bad pom.xml: no name, artifactId, or groupId.", null);
                throw new CoreException((IStatus)new Status(4, PLUGIN_ID, message));
            }
        }
        MavenProjectInfo parent = null;
        MavenProjectInfo projectInfo = new MavenProjectInfo(derivedProjectName, pomFile, model, parent);
        ArrayList<MavenProjectInfo> projectInfos = new ArrayList<MavenProjectInfo>();
        projectInfos.add(projectInfo);
        ResolverConfiguration resolverConfiguration = new ResolverConfiguration();
        String activeProfiles = "pom.xml";
        resolverConfiguration.setActiveProfiles(activeProfiles);
        ProjectImportConfiguration configuration = new ProjectImportConfiguration(resolverConfiguration);
        List importResults = MavenPlugin.getProjectConfigurationManager().importProjects(projectInfos, configuration, monitor);
        for (IMavenProjectImportResult importResult : importResults) {
            if (importResult.getProject() == null) continue;
            MavenPlugin.getProjectConfigurationManager().updateProjectConfiguration(importResult.getProject(), monitor);
        }
    }

    class PomResourceChangeListener
    implements IResourceChangeListener {
        public static final int LISTENER_FLAGS = 14;
        private static final int VISITOR_FLAGS = 7;

        PomResourceChangeListener() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getSource() instanceof IWorkspace) {
                int eventType = event.getType();
                switch (eventType) {
                    case 1: {
                        IResourceDelta delta = event.getDelta();
                        if (delta == null) return;
                        try {
                            delta.accept(this.getVisitor(eventType), 7);
                            return;
                        }
                        catch (CoreException e) {
                            SpringCore.log((String)"Error while traversing resource change delta", (Throwable)e);
                        }
                    }
                    default: {
                        return;
                    }
                }
            } else {
                if (!(event.getSource() instanceof IProject)) return;
                int eventType = event.getType();
                switch (eventType) {
                    case 1: {
                        IResourceDelta delta = event.getDelta();
                        if (delta == null) return;
                        try {
                            delta.accept(this.getVisitor(eventType), 7);
                            return;
                        }
                        catch (CoreException e) {
                            SpringCore.log((String)"Error while traversing resource change delta", (Throwable)e);
                        }
                    }
                }
            }
        }

        protected IResourceDeltaVisitor getVisitor(int eventType) {
            return new PomResourceVisitor(eventType);
        }

        protected class PomResourceVisitor
        implements IResourceDeltaVisitor {
            protected int eventType;

            public PomResourceVisitor(int eventType) {
                this.eventType = eventType;
            }

            public final boolean visit(IResourceDelta delta) throws CoreException {
                IResource resource = delta.getResource();
                switch (delta.getKind()) {
                    case 1: {
                        return this.resourceAdded(resource);
                    }
                    case 16384: {
                        return this.resourceOpened(resource);
                    }
                    case 4: {
                        return this.resourceChanged(resource, delta.getFlags());
                    }
                    case 2: {
                        return this.resourceRemoved(resource);
                    }
                }
                return true;
            }

            protected boolean resourceAdded(IResource resource) {
                if (resource instanceof IFile) {
                    this.updateDependenciesIfPom(resource);
                    return false;
                }
                return true;
            }

            protected boolean resourceChanged(IResource resource, int flags) {
                if (resource instanceof IFile) {
                    if ((flags & 0x100) != 0) {
                        this.updateDependenciesIfPom(resource);
                    }
                    return false;
                }
                return true;
            }

            protected boolean resourceOpened(IResource resource) {
                return true;
            }

            protected boolean resourceRemoved(IResource resource) {
                return true;
            }

            private void updateDependenciesIfPom(IResource resource) {
                if (resource.getName().equals("pom.xml") && SpringCorePreferences.getProjectPreferences((IProject)resource.getProject(), (String)MavenCorePlugin.PLUGIN_ID).getBoolean(MavenCorePlugin.AUTOMATICALLY_UPDATE_DEPENDENCIES_KEY, false) && !SpringCoreUtils.hasNature((IResource)resource, (String)MavenCorePlugin.M2ECLIPSE_NATURE)) {
                    MavenClasspathUpdateJob.scheduleClasspathContainerUpdateJob(resource.getProject());
                }
            }
        }
    }
}

