/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.model;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.ui.internal.properties.XMLPropertySource;
import org.springframework.ide.eclipse.config.core.ConfigCoreUtils;
import org.springframework.ide.eclipse.config.core.formatting.ShallowFormatProcessorXML;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.config.graph.model.AbstractConfigGraphDiagram;
import org.springframework.ide.eclipse.config.graph.model.AbstractGefGraphModelElement;
import org.springframework.ide.eclipse.config.graph.model.Activity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigGraphModelElement
extends AbstractGefGraphModelElement
implements IAdaptable {
    private IDOMElement input;
    private AbstractConfigGraphDiagram diagram;
    protected ShallowFormatProcessorXML formatter = new ShallowFormatProcessorXML();
    private Rectangle bounds;
    private String name = "node";
    private String shortName;
    private String displayLabel;
    private String namespaceUri;
    private boolean hasManualBounds = false;

    public AbstractConfigGraphModelElement() {
    }

    public AbstractConfigGraphModelElement(IDOMElement input, AbstractConfigGraphDiagram diagram) {
        this();
        this.input = input;
        this.diagram = diagram;
        this.internalSetName();
    }

    protected void createInput(String uri) {
        if (this.input == null) {
            this.namespaceUri = uri == null ? this.getDiagram().getNamespaceUri() : uri;
            IDOMDocument document = this.getDiagram().getDomDocument();
            this.input = (IDOMElement)document.createElement(this.getInputName());
            this.input.setPrefix(ConfigCoreUtils.getPrefixForNamespaceUri((IDOMDocument)document, (String)this.namespaceUri));
            this.internalSetName();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractConfigGraphModelElement)) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractConfigGraphModelElement other = (AbstractConfigGraphModelElement)obj;
        return !(this.input == null ? other.input != null : !this.input.equals(other.input));
    }

    public Object getAdapter(Class adapter) {
        if (IPropertySource.class == adapter) {
            IPropertySource propertySource = (IPropertySource)this.input.getAdapterFor(IPropertySource.class);
            if (propertySource == null) {
                propertySource = new XMLPropertySource((INodeNotifier)this.input);
            }
            return propertySource;
        }
        return null;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public AbstractConfigGraphDiagram getDiagram() {
        return this.diagram;
    }

    public String getDisplayLabel() {
        return this.displayLabel;
    }

    public IDOMElement getInput() {
        return this.input;
    }

    public abstract String getInputName();

    public List<Activity> getModelRegistry() {
        return this.getDiagram().getModelRegistry();
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.input == null ? 0 : this.input.hashCode());
        return result;
    }

    public boolean hasManualBounds() {
        return this.hasManualBounds;
    }

    protected void internalSetName() {
        String id = this.getInput().getAttribute(BeansSchemaConstants.ATTR_ID);
        if (id != null && !id.trim().equals("")) {
            this.shortName = this.name = id;
        } else {
            this.name = this.getInput().getLocalName();
            this.shortName = "";
        }
        this.displayLabel = this.shortName;
    }

    public void modifyBounds(Rectangle bounds) {
        Rectangle oldBounds = this.bounds;
        if (!bounds.equals((Object)oldBounds)) {
            this.bounds = bounds;
            this.hasManualBounds = true;
            this.firePropertyChange("bounds", null, bounds);
        }
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public void setDiagram(AbstractConfigGraphDiagram diagram) {
        this.diagram = diagram;
    }

    public void setDisplayLabel(String label) {
        this.displayLabel = label;
    }

    public void setHasManualBounds(boolean hasManualBounds) {
        if (hasManualBounds) {
            this.hasManualBounds = hasManualBounds;
        }
    }

    public void setInput(IDOMElement input) {
        this.input = input;
    }

    public void setName(String s) {
        this.name = s;
        this.displayLabel = this.shortName = s;
        this.firePropertyChange("name", null, s);
    }

    public String toString() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        return String.valueOf(className) + "(" + this.name + ")";
    }
}

