/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.springframework.ide.eclipse.beans.ui.graph.figures.ShadowedLineBorder;
import org.springframework.ide.eclipse.config.graph.figures.SubgraphFigure;

public class ListContainerFigure
extends SubgraphFigure {
    protected boolean selected;
    private final Color containerBlue = new Color(null, 198, 220, 235);

    public ListContainerFigure(int direction) {
        super((IFigure)new Label(""), (IFigure)new Label(""), direction);
        this.setBorder((Border)new ShadowedLineBorder());
        this.setOpaque(true);
    }

    protected void paintFigure(Graphics g) {
        super.paintFigure(g);
        Rectangle r = super.getBounds();
        g.setAntialias(1);
        g.setBackgroundColor(this.containerBlue);
        if (this.selected) {
            g.setBackgroundColor(ColorConstants.menuBackgroundSelected);
            g.setForegroundColor(ColorConstants.menuForegroundSelected);
        }
        g.fillRectangle(r.x, r.y, 5, r.height - 5);
        g.fillRectangle(r.right() - 9, r.y, 5, r.height - 5);
        g.fillRectangle(r.x, r.bottom() - 9, r.width - 5, 5);
        if (this.getHeader().getPreferredSize().height < 20) {
            g.fillRectangle(r.x, r.y, r.width - 5, 20);
        } else {
            g.fillRectangle(r.x, r.y, r.width - 5, 29);
        }
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
        this.footer.setLocation(new Point(0, 0));
        this.footer.setSize(0, 0);
    }

    public void setSelected(boolean selected) {
        if (this.selected == selected) {
            return;
        }
        this.selected = selected;
        if (!selected) {
            this.getHeader().setForegroundColor(null);
            this.getFooter().setForegroundColor(null);
        } else {
            this.getHeader().setForegroundColor(ColorConstants.menuForegroundSelected);
            this.getFooter().setForegroundColor(ColorConstants.menuForegroundSelected);
        }
        this.repaint();
    }
}

