/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.figures;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.geometry.Rectangle;
import org.springframework.ide.eclipse.config.graph.figures.BidirectionalConnectorBorder;
import org.springframework.ide.eclipse.config.graph.figures.BorderedActivityLabel;
import org.springframework.ide.eclipse.config.graph.figures.ConnectorBorder;
import org.springframework.ide.eclipse.config.graph.parts.FixedConnectionAnchor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BidirectionalBorderedActivityLabel
extends BorderedActivityLabel {
    private final boolean leftSide;
    private final boolean incomingOnTop;

    public BidirectionalBorderedActivityLabel(int direction, List<String> inputs, List<String> outputs, boolean leftSide) {
        this(direction, inputs, outputs, leftSide, true);
    }

    public BidirectionalBorderedActivityLabel(int direction, List<String> inputs, List<String> outputs, boolean leftSide, boolean incomingOnTop) {
        super(direction, inputs, outputs);
        this.leftSide = leftSide;
        this.incomingOnTop = incomingOnTop;
        this.border = this.createConnectorBorder();
        this.setBorder((Border)this.border);
        this.createConnectionAnchors();
    }

    @Override
    protected ConnectorBorder createConnectorBorder() {
        return new BidirectionalConnectorBorder(this.direction, this.inputs.size(), this.outputs.size(), this.leftSide);
    }

    @Override
    protected void layoutConnectionAnchors() {
        List bottomItems;
        List topItems;
        Rectangle rect = this.getBounds();
        int capacity = this.inputs.size() + this.outputs.size();
        if (this.incomingOnTop) {
            topItems = this.inputs;
            bottomItems = this.outputs;
        } else {
            topItems = this.outputs;
            bottomItems = this.inputs;
        }
        if (this.direction == 16) {
            int height = rect.height;
            int i = 0;
            while (i < topItems.size()) {
                FixedConnectionAnchor in = (FixedConnectionAnchor)this.getConnectionAnchor((String)topItems.get(i));
                in.offsetV = (2 * i + 1) * height / (capacity * 2);
                in.leftToRight = this.leftSide;
                ++i;
            }
            i = 0;
            while (i < bottomItems.size()) {
                int j = topItems.size() + i;
                FixedConnectionAnchor out = (FixedConnectionAnchor)this.getConnectionAnchor((String)bottomItems.get(i));
                out.offsetV = (2 * j + 1) * height / (capacity * 2);
                out.leftToRight = this.leftSide;
                ++i;
            }
        } else {
            int width = rect.width;
            int i = 0;
            while (i < topItems.size()) {
                FixedConnectionAnchor in = (FixedConnectionAnchor)this.getConnectionAnchor((String)topItems.get(i));
                in.offsetV = (2 * i + 1) * width / (capacity * 2);
                in.topDown = this.leftSide;
                ++i;
            }
            i = 0;
            while (i < bottomItems.size()) {
                int j = topItems.size() + i;
                FixedConnectionAnchor out = (FixedConnectionAnchor)this.getConnectionAnchor((String)bottomItems.get(i));
                out.offsetV = (2 * j + 1) * width / (capacity * 2);
                out.topDown = this.leftSide;
                ++i;
            }
        }
    }
}

