/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.wizards;

import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.config.core.schemas.OsgiSchemaConstants;
import org.springframework.ide.eclipse.config.ui.wizards.AbstractConfigWizard;
import org.springframework.ide.eclipse.config.ui.wizards.Messages;
import org.springframework.ide.eclipse.config.ui.wizards.OsgiServiceWizardPage;
import org.w3c.dom.Node;

public class OsgiServiceWizard
extends AbstractConfigWizard {
    private OsgiServiceWizardPage page;
    private final FormatProcessorXML deepFormatter = new FormatProcessorXML();

    public OsgiServiceWizard() {
        this.setWindowTitle(Messages.getString("OsgiServiceWizard.WINDOW_TITLE"));
    }

    public void addPages() {
        this.page = new OsgiServiceWizardPage(this);
        this.addPage((IWizardPage)this.page);
    }

    protected void createInput(IDOMDocument copiedDocument) {
        if (copiedDocument != null) {
            String prefix = this.getPrefixForNamespaceUri();
            String name = prefix != null && prefix.length() > 0 ? String.valueOf(prefix) + ":" + OsgiSchemaConstants.ELEM_SERVICE : OsgiSchemaConstants.ELEM_SERVICE;
            this.input = (IDOMElement)copiedDocument.createElement(name);
            this.input.setAttribute(OsgiSchemaConstants.ATTR_ID, "");
            this.input.setAttribute(OsgiSchemaConstants.ATTR_REF, "");
        }
    }

    public boolean performFinish() {
        String refStr = this.page.getRef();
        String idStr = this.page.getId();
        Node parent = this.getRootNode();
        if (parent != null && this.input != null) {
            IDOMModel model = this.domDocument.getModel();
            model.beginRecording((Object)this);
            this.newElement = (IDOMElement)this.domDocument.importNode((Node)this.input, true);
            parent.appendChild((Node)this.newElement);
            this.newElement.setAttribute(OsgiSchemaConstants.ATTR_ID, idStr);
            this.newElement.setAttribute(OsgiSchemaConstants.ATTR_REF, refStr);
            List<Object> interfaces = this.page.getInterfaces();
            if (interfaces.size() == 1 && interfaces.get(0) instanceof IType) {
                String interfaceStr = ((IType)interfaces.get(0)).getFullyQualifiedName();
                this.newElement.setAttribute(OsgiSchemaConstants.ATTR_INTERFACE, interfaceStr);
            } else if (interfaces.size() > 1) {
                for (Object obj : interfaces) {
                    if (!(obj instanceof IType)) continue;
                    String interfaceStr = ((IType)obj).getFullyQualifiedName();
                    String prefix = this.getPrefixForNamespaceUri();
                    String name = prefix != null && prefix.length() > 0 ? String.valueOf(this.getPrefixForNamespaceUri()) + ":" + OsgiSchemaConstants.ELEM_INTERFACES : OsgiSchemaConstants.ELEM_INTERFACES;
                    IDOMElement interfaceElem = (IDOMElement)this.domDocument.createElement(name);
                    interfaceElem.setAttribute(BeansSchemaConstants.ATTR_VALUE_TYPE, interfaceStr);
                    this.newElement.appendChild((Node)interfaceElem);
                }
            }
            this.deepFormatter.formatNode((Node)this.newElement);
            this.formatter.formatNode(this.newElement.getParentNode());
            model.endRecording((Object)this);
        }
        return true;
    }
}

