/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors.webflow.graph.model;

import java.util.List;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.springframework.ide.eclipse.config.core.schemas.WebFlowSchemaConstants;
import org.springframework.ide.eclipse.config.graph.model.AbstractConfigGraphDiagram;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.model.ParallelActivity;
import org.springframework.ide.eclipse.config.graph.model.Transition;
import org.springframework.ide.eclipse.config.ui.editors.webflow.graph.model.WebFlowTransition;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStateModelElement
extends Activity {
    public AbstractStateModelElement() {
    }

    public AbstractStateModelElement(IDOMElement input, AbstractConfigGraphDiagram diagram) {
        super(input, diagram);
    }

    protected List<Transition> getOutgoingTransitionsFromXml() {
        List list = super.getOutgoingTransitionsFromXml();
        List registry = this.getDiagram().getModelRegistry();
        NodeList transitions = this.getInput().getChildNodes();
        int i = 0;
        while (i < transitions.getLength()) {
            Node node = transitions.item(i);
            if (node instanceof IDOMElement && node.getLocalName().equals(WebFlowSchemaConstants.ELEM_TRANSITION)) {
                IDOMElement transition = (IDOMElement)node;
                String state = transition.getAttribute(WebFlowSchemaConstants.ATTR_TO);
                if (state != null && state.trim().length() > 0) {
                    Node stateRef = this.getDiagram().getReferencedNode(state);
                    if (stateRef instanceof IDOMElement) {
                        for (Activity activity : registry) {
                            if (activity instanceof ParallelActivity || !activity.getInput().equals(stateRef)) continue;
                            WebFlowTransition trans = new WebFlowTransition(this, activity, transition);
                            list.add(trans);
                        }
                    }
                } else {
                    WebFlowTransition trans = new WebFlowTransition(this, this, transition);
                    list.add(trans);
                }
            }
            ++i;
        }
        return list;
    }
}

