/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors.integration.graph;

import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.springframework.ide.eclipse.config.core.ConfigCoreUtils;
import org.springframework.ide.eclipse.config.core.formatting.ShallowFormatProcessorXML;
import org.springframework.ide.eclipse.config.core.schemas.IntegrationSchemaConstants;
import org.springframework.ide.eclipse.config.graph.model.commands.AbstractConnectionCreateCommand;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WireTapConnectionCreateCommand
extends AbstractConnectionCreateCommand {
    private final ShallowFormatProcessorXML formatter = new ShallowFormatProcessorXML();
    protected String oldTargetId;
    protected String targetId;

    public WireTapConnectionCreateCommand(ITextEditor textEditor) {
        super(textEditor, 2);
    }

    public boolean canExecute() {
        if (super.canExecute()) {
            this.oldTargetId = this.sourceElement.getAttribute(IntegrationSchemaConstants.ATTR_CHANNEL);
            this.targetId = this.targetElement.getAttribute(IntegrationSchemaConstants.ATTR_ID);
            if (this.targetId != null && this.targetId.trim().length() != 0) {
                return true;
            }
        }
        return false;
    }

    public void execute() {
        IDOMElement interceptor = null;
        NodeList iNodes = this.sourceElement.getChildNodes();
        int i = 0;
        while (i < iNodes.getLength()) {
            Node iNode = iNodes.item(i);
            if (iNode instanceof IDOMElement && iNode.getLocalName().equals(IntegrationSchemaConstants.ELEM_INTERCEPTORS)) {
                interceptor = (IDOMElement)iNode;
                break;
            }
            ++i;
        }
        IDOMDocument document = (IDOMDocument)this.sourceElement.getOwnerDocument();
        IDOMModel model = document.getModel();
        if (model != null) {
            model.beginRecording((Object)this);
            if (interceptor == null) {
                interceptor = (IDOMElement)document.createElement(IntegrationSchemaConstants.ELEM_INTERCEPTORS);
                interceptor.setPrefix(ConfigCoreUtils.getPrefixForNamespaceUri((IDOMDocument)document, (String)IntegrationSchemaConstants.URI));
                this.sourceElement.appendChild((Node)interceptor);
                this.processor.insertDefaultAttributes(interceptor);
                this.formatter.formatNode((Node)interceptor);
                this.formatter.formatNode((Node)this.sourceElement);
            }
            IDOMElement wiretap = (IDOMElement)document.createElement(IntegrationSchemaConstants.ELEM_WIRE_TAP);
            wiretap.setPrefix(ConfigCoreUtils.getPrefixForNamespaceUri((IDOMDocument)document, (String)IntegrationSchemaConstants.URI));
            interceptor.appendChild((Node)wiretap);
            this.processor.insertDefaultAttributes(wiretap);
            this.formatter.formatNode((Node)wiretap);
            this.formatter.formatNode((Node)interceptor);
            wiretap.setAttribute(IntegrationSchemaConstants.ATTR_CHANNEL, this.targetId);
            model.endRecording((Object)this);
        }
    }
}

