/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.livegraph.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.ide.eclipse.beans.ui.livegraph.model.LiveBean;
import org.springframework.ide.eclipse.beans.ui.livegraph.model.LiveBeansGroup;
import org.springframework.ide.eclipse.beans.ui.livegraph.model.LiveBeansSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveBeansModel
implements Comparable<LiveBeansModel> {
    private final List<LiveBean> beans = new ArrayList<LiveBean>();
    private final List<LiveBeansGroup> contexts = new ArrayList<LiveBeansGroup>();
    private final List<LiveBeansGroup> resources = new ArrayList<LiveBeansGroup>();
    private final LiveBeansSession session;

    public LiveBeansModel(LiveBeansSession session) {
        this.session = session;
    }

    public void addBeans(Collection<LiveBean> beansToAdd) {
        this.beans.addAll(beansToAdd);
    }

    public void addContexts(Collection<? extends LiveBeansGroup> contextsToAdd) {
        this.contexts.addAll(contextsToAdd);
    }

    public void addResources(Collection<? extends LiveBeansGroup> resourcesToAdd) {
        this.resources.addAll(resourcesToAdd);
    }

    @Override
    public int compareTo(LiveBeansModel o) {
        return this.getApplicationName().compareTo(o.getApplicationName());
    }

    public String getApplicationName() {
        if (this.session != null) {
            return this.session.getApplicationName();
        }
        return "";
    }

    public List<LiveBean> getBeans() {
        return this.beans;
    }

    public List<LiveBeansGroup> getBeansByContext() {
        return this.contexts;
    }

    public List<LiveBeansGroup> getBeansByResource() {
        return this.resources;
    }

    public LiveBeansSession getSession() {
        return this.session;
    }
}

