/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.livegraph.model;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.ide.eclipse.beans.ui.livegraph.model.AbstractLiveBeansModelElement;
import org.springframework.ide.eclipse.beans.ui.livegraph.model.LiveBeansSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveBean
extends AbstractLiveBeansModelElement {
    public static final String ATTR_BEAN = "bean";
    public static final String ATTR_SCOPE = "scope";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_RESOURCE = "resource";
    public static final String ATTR_DEPENDENCIES = "dependencies";
    public static final String ATTR_APPLICATION = "application name";
    private final LiveBeansSession session;
    private final String beanId;
    private String displayName;
    private final Set<LiveBean> dependencies;
    private final Set<LiveBean> injectedInto;
    private final boolean innerBean;

    public LiveBean(LiveBeansSession session, String id) {
        this(session, id, false);
    }

    public LiveBean(LiveBeansSession session, String id, boolean innerBean) {
        this.session = session;
        this.beanId = id;
        this.innerBean = innerBean;
        this.dependencies = new HashSet<LiveBean>();
        this.injectedInto = new HashSet<LiveBean>();
        this.attributes.put(ATTR_BEAN, id);
    }

    public void addDependency(LiveBean dependency) {
        this.dependencies.add(dependency);
        dependency.injectInto(this);
    }

    public String getApplicationName() {
        return (String)this.attributes.get(ATTR_APPLICATION);
    }

    public String getBeanType() {
        return (String)this.attributes.get(ATTR_TYPE);
    }

    public Set<LiveBean> getDependencies() {
        return this.dependencies;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            int index;
            if ((this.getBeanType() != null && this.beanId.contains(this.getBeanType()) || StringUtils.countMatches((String)this.beanId, (String)".") > 1) && (index = this.beanId.lastIndexOf(46)) >= 0) {
                this.displayName = this.beanId.substring(index + 1, this.beanId.length());
            }
            if (this.displayName == null) {
                this.displayName = this.beanId;
            }
        }
        return this.displayName;
    }

    public String getId() {
        return this.beanId;
    }

    public Set<LiveBean> getInjectedInto() {
        return this.injectedInto;
    }

    public String getResource() {
        return (String)this.attributes.get(ATTR_RESOURCE);
    }

    public String getScope() {
        return (String)this.attributes.get(ATTR_SCOPE);
    }

    private void injectInto(LiveBean bean) {
        this.injectedInto.add(bean);
    }

    public boolean isInnerBean() {
        return this.innerBean;
    }

    public LiveBeansSession getSession() {
        return this.session;
    }
}

