/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.data.internal.validation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.java.JavaModelSourceLocation;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.data.internal.validation.CompilationUnit;
import org.springframework.ide.eclipse.data.internal.validation.SpringDataValidationContext;
import org.springframework.ide.eclipse.data.jdt.core.RepositoryInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidDerivedQueryRule
implements IValidationRule<CompilationUnit, SpringDataValidationContext> {
    public boolean supports(IModelElement element, IValidationContext context) {
        if (!(context instanceof SpringDataValidationContext)) {
            return false;
        }
        if (element instanceof CompilationUnit) {
            CompilationUnit cue = (CompilationUnit)element;
            return this.supports(cue.getTypeRoot());
        }
        return false;
    }

    private boolean supports(ITypeRoot typeRoot) {
        if (typeRoot == null) {
            return false;
        }
        IType type = typeRoot.findPrimaryType();
        try {
            if (type == null || !type.isInterface() || type.isAnnotation()) {
                return false;
            }
        }
        catch (JavaModelException e) {
            SpringCore.log((Throwable)e);
            return false;
        }
        if (!RepositoryInformation.isSpringDataRepository(type)) {
            return false;
        }
        RepositoryInformation information = new RepositoryInformation(type);
        Class<?> domainClass = information.getManagedDomainClass();
        return domainClass != null;
    }

    public void validate(CompilationUnit element, SpringDataValidationContext context, IProgressMonitor monitor) {
        try {
            ITypeRoot typeRoot = element.getTypeRoot();
            IType type = typeRoot.findPrimaryType();
            if (!this.supports(typeRoot)) {
                return;
            }
            RepositoryInformation information = new RepositoryInformation(type);
            Class<?> domainClass = information.getManagedDomainClass();
            if (domainClass == null) {
                return;
            }
            for (IMethod method : information.getMethodsToValidate()) {
                String methodName = method.getElementName();
                try {
                    new PartTree(methodName, domainClass);
                }
                catch (PropertyReferenceException e) {
                    element.setElementSourceLocation((IModelSourceLocation)new JavaModelSourceLocation((IJavaElement)method));
                    ValidationProblemAttribute start = new ValidationProblemAttribute("charStart", (Object)method.getNameRange().getOffset());
                    ValidationProblemAttribute end = new ValidationProblemAttribute("charEnd", (Object)(method.getSourceRange().getOffset() + method.getSourceRange().getLength()));
                    context.error((IResourceModelElement)element, "INVALID_DERIVED_QUERY", "Invalid derived query! " + e.getMessage(), new ValidationProblemAttribute[]{start, end});
                }
            }
        }
        catch (JavaModelException e) {
            SpringCore.log((Throwable)e);
        }
        catch (Exception e) {
            SpringCore.log((Throwable)e);
        }
        catch (Error e) {
            SpringCore.log((Throwable)e);
        }
    }
}

