/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.data.beans.ui.editor;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.springframework.ide.eclipse.beans.ui.editor.namespaces.DefaultReferenceableElementsLocator;
import org.springframework.ide.eclipse.data.SpringDataUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoriesReferenceableElementLocator
extends DefaultReferenceableElementsLocator {
    public Map<String, Set<Node>> getReferenceableElements(Document document, IFile file) {
        Map result = super.getReferenceableElements(document, file);
        NodeList childNodes = document.getDocumentElement().getChildNodes();
        Node springDataElement = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (SpringDataUtils.isSpringDataElement(node)) {
                springDataElement = node;
                break;
            }
            ++i;
        }
        if (file != null && file.exists()) {
            for (String name : SpringDataUtils.getRepositoryBeanIds(file.getProject())) {
                HashSet<Node> nodes = (HashSet<Node>)result.get(name);
                if (nodes == null) {
                    nodes = new HashSet<Node>();
                    result.put(name, nodes);
                }
                nodes.add(springDataElement);
            }
        }
        return result;
    }
}

