/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.internal.core.net;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.WebLocation;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.osgi.util.NLS;
import org.springsource.ide.eclipse.commons.internal.core.net.ITransportService;

public class HttpClientTransportService
implements ITransportService {
    private static final int BUFFER_SIZE = 4096;

    @Override
    public void download(URI uri, OutputStream out, IProgressMonitor progressMonitor) throws CoreException {
        block19: {
            WebLocation location = new WebLocation(uri.toString());
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor);
            monitor.subTask(NLS.bind((String)"Fetching {0}", (Object)location.getUrl()));
            try {
                try {
                    HttpClient client = new HttpClient();
                    WebUtil.configureHttpClient((HttpClient)client, (String)"");
                    GetMethod method = new GetMethod(location.getUrl());
                    try {
                        HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)client, (AbstractWebLocation)location, (IProgressMonitor)monitor);
                        int result = WebUtil.execute((HttpClient)client, (HostConfiguration)hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
                        if (result == 200) {
                            long total = method.getResponseContentLength();
                            if (total != -1L) {
                                monitor.setWorkRemaining((int)total);
                            }
                            InputStream in = WebUtil.getResponseBodyAsStream((HttpMethodBase)method, (IProgressMonitor)monitor);
                            try {
                                try {
                                    int len;
                                    in = new BufferedInputStream(in);
                                    byte[] buffer = new byte[4096];
                                    while ((len = in.read(buffer)) != -1) {
                                        out.write(buffer, 0, len);
                                        if (total != -1L) {
                                            monitor.worked(len);
                                        } else {
                                            monitor.worked(1);
                                            monitor.setWorkRemaining(10000);
                                        }
                                        if (!monitor.isCanceled()) continue;
                                        throw new OperationCanceledException();
                                    }
                                    break block19;
                                }
                                catch (OperationCanceledException operationCanceledException) {
                                    throw this.toException(location, result);
                                }
                                catch (IOException iOException) {
                                    throw this.toException(location, 500);
                                }
                            }
                            finally {
                                in.close();
                            }
                        }
                        throw this.toException(location, result);
                    }
                    finally {
                        method.releaseConnection();
                    }
                }
                catch (IOException e) {
                    throw this.toException(location, e);
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getLastModified(URI uri, IProgressMonitor progressMonitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public InputStream stream(URI uri, IProgressMonitor progressMonitor) throws CoreException {
        WebLocation location = new WebLocation(uri.toString());
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor);
        monitor.subTask(NLS.bind((String)"Fetching {0}", (Object)location.getUrl()));
        try {
            HttpClient client = new HttpClient();
            WebUtil.configureHttpClient((HttpClient)client, (String)"");
            boolean success = false;
            GetMethod method = new GetMethod(location.getUrl());
            try {
                HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)client, (AbstractWebLocation)location, (IProgressMonitor)monitor);
                int result = WebUtil.execute((HttpClient)client, (HostConfiguration)hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
                if (result == 200) {
                    InputStream in = WebUtil.getResponseBodyAsStream((HttpMethodBase)method, (IProgressMonitor)monitor);
                    success = true;
                    InputStream inputStream = in;
                    return inputStream;
                }
                try {
                    throw this.toException(location, result);
                }
                catch (IOException e) {
                    throw this.toException(location, e);
                }
            }
            finally {
                if (!success) {
                    method.releaseConnection();
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private CoreException toException(WebLocation location, int result) {
        return new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.core", NLS.bind((String)"Download of {0} failed: Unexpected HTTP response {1}", (Object)location.getUrl(), (Object)result)));
    }

    private CoreException toException(WebLocation location, IOException e) throws CoreException {
        String message = e.getMessage() != null ? e.getMessage() : "Unexpected error";
        return new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.core", NLS.bind((String)"Download of {0} failed: {1}", (Object)location.getUrl(), (Object)message), (Throwable)e));
    }
}

