/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.actions;

import com.collabnet.subversion.merge.MergeResult;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.editors.MergeConflictsCompareInput;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbenchPage;
import org.osgi.service.prefs.BackingStoreException;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.WorkspaceAction;
import org.tigris.subversion.subclipse.ui.conflicts.MergeFileAssociation;
import org.tigris.subversion.svnclientadapter.SVNConflictDescriptor;
import org.tigris.subversion.svnclientadapter.utils.Command;

public class MergeEditConflictsAction
extends WorkspaceAction {
    private File conflictNewFile;
    private File conflictOldFile;
    private File conflictWorkingFile;
    private File mergedFile;
    private MergeConflictsCompareInput mergeConflictsCompareInput;
    private String fileName;
    private MergeResult mergeResult;
    private SVNConflictDescriptor conflictDescriptor;

    public MergeEditConflictsAction(File conflictNewFile, File conflictOldFile, File conflictWorkingFile, File mergedFile, String fileName, SVNConflictDescriptor conflictDescriptor) {
        this.conflictNewFile = conflictNewFile;
        this.conflictOldFile = conflictOldFile;
        this.conflictWorkingFile = conflictWorkingFile;
        this.mergedFile = mergedFile;
        this.fileName = fileName;
        this.conflictDescriptor = conflictDescriptor;
    }

    private void editConflictsInternal() throws InvocationTargetException, InterruptedException {
        CompareConfiguration cc = new CompareConfiguration();
        cc.setLeftEditable(true);
        this.mergeConflictsCompareInput = new MergeConflictsCompareInput(cc, this.conflictDescriptor);
        this.mergeConflictsCompareInput.setMergeResult(this.mergeResult);
        this.mergeConflictsCompareInput.setResources(this.conflictOldFile, this.conflictWorkingFile, this.conflictNewFile, this.mergedFile, this.fileName);
        CompareUI.openCompareEditorOnPage((CompareEditorInput)this.mergeConflictsCompareInput, (IWorkbenchPage)this.getTargetPage());
    }

    private void editConflictsExternal(String mergeProgramLocation, String mergeProgramParameters) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            this.mergeConflictsCompareInput = new MergeConflictsCompareInput(new CompareConfiguration(), this.conflictDescriptor);
            this.mergeConflictsCompareInput.setMergeResult(this.mergeResult);
            if (mergeProgramLocation.equals("")) {
                throw new SVNException(Messages.MergeEditConflictsAction_noProgram);
            }
            File mergeProgramFile = new File(mergeProgramLocation);
            if (!mergeProgramFile.exists()) {
                throw new SVNException(Messages.MergeEditConflictsAction_programDoesNotExist);
            }
            Command command = new Command(mergeProgramLocation);
            String[] parameters = mergeProgramParameters.split(" ");
            int i = 0;
            while (i < parameters.length) {
                parameters[i] = this.replaceParameter(parameters[i], "${theirs}", this.conflictNewFile.getAbsolutePath());
                parameters[i] = this.replaceParameter(parameters[i], "${yours}", this.conflictWorkingFile.getAbsolutePath());
                parameters[i] = this.replaceParameter(parameters[i], "${base}", this.conflictOldFile.getAbsolutePath());
                parameters[i] = this.replaceParameter(parameters[i], "${merged}", this.mergedFile.getAbsolutePath());
                ++i;
            }
            command.setParameters(parameters);
            command.exec();
            command.waitFor();
            this.mergeConflictsCompareInput.handleExternalDispose();
        }
        catch (IOException e) {
            throw new SVNException(String.valueOf(Messages.MergeEditConflictsAction_0) + e.getMessage(), (Throwable)e);
        }
    }

    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        try {
            MergeFileAssociation mergeFileAssociation = null;
            try {
                mergeFileAssociation = SVNUIPlugin.getPlugin().getMergeFileAssociation(this.fileName);
            }
            catch (BackingStoreException backingStoreException) {
                mergeFileAssociation = new MergeFileAssociation();
            }
            if (mergeFileAssociation.getType() == 0) {
                this.editConflictsInternal();
            } else if (mergeFileAssociation.getType() == 1) {
                IPreferenceStore preferenceStore = SVNUIPlugin.getPlugin().getPreferenceStore();
                String mergeProgramLocation = preferenceStore.getString("pref_merge_program_location");
                String mergeProgramParameters = preferenceStore.getString("pref_merge_program_parameters");
                this.editConflictsExternal(mergeProgramLocation, mergeProgramParameters);
            } else {
                this.editConflictsExternal(mergeFileAssociation.getMergeProgram(), mergeFileAssociation.getParameters());
            }
        }
        catch (Exception e) {
            if (this.mergeConflictsCompareInput == null) {
                this.mergeConflictsCompareInput = new MergeConflictsCompareInput(new CompareConfiguration(), this.conflictDescriptor);
            }
            this.mergeConflictsCompareInput.setFinished(true);
            throw new InvocationTargetException(e);
        }
    }

    protected String getErrorTitle() {
        return Messages.MergeEditConflictsAction_title;
    }

    protected boolean isEnabledForSVNResource(ISVNLocalResource svnResource) {
        try {
            return this.conflictWorkingFile != null && svnResource.getStatus().isTextConflicted();
        }
        catch (SVNException sVNException) {
            return false;
        }
    }

    protected boolean isEnabledForMultipleResources() {
        return false;
    }

    private String replaceParameter(String input, String pattern, String value) {
        StringBuffer result = new StringBuffer();
        int startIdx = 0;
        int idxOld = 0;
        while ((idxOld = input.indexOf(pattern, startIdx)) >= 0) {
            result.append(input.substring(startIdx, idxOld));
            result.append(value);
            startIdx = idxOld + pattern.length();
        }
        result.append(input.substring(startIdx));
        return result.toString();
    }

    protected String getImageId() {
        return "Menu Edit Conflicts";
    }

    public MergeConflictsCompareInput getMergeConflictsCompareInput() {
        return this.mergeConflictsCompareInput;
    }

    public void setMergeResult(MergeResult mergeResult) {
        this.mergeResult = mergeResult;
    }
}

