/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.search.jdt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jdt.ui.search.PatternQuerySpecification;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.PartInitException;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.beans.ui.search.internal.BeansSearchLabelProvider;
import org.springframework.ide.eclipse.beans.ui.search.internal.BeansSearchResult;
import org.springframework.ide.eclipse.beans.ui.search.internal.BeansSearchScope;
import org.springframework.ide.eclipse.beans.ui.search.internal.queries.AbstractBeansQuery;
import org.springframework.ide.eclipse.beans.ui.search.internal.queries.BeanClassQuery;
import org.springframework.ide.eclipse.beans.ui.search.internal.queries.BeanPropertyQuery;
import org.springframework.ide.eclipse.beans.ui.search.internal.queries.BeanReferenceQuery;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansJavaSearchParticipant
implements IQueryParticipant,
IMatchPresentation {
    private static final int SEARCH_FOR_TYPES = 0;
    private static final int SEARCH_FOR_FIELDS = 1;
    private static final int LIMIT_TO_REF = 2;
    private static final int LIMIT_TO_ALL = 3;
    private int searchFor = -1;

    public int estimateTicks(QuerySpecification specification) {
        return 100;
    }

    public IMatchPresentation getUIParticipant() {
        return this;
    }

    public void search(ISearchRequestor requestor, QuerySpecification querySpecification, IProgressMonitor monitor) {
        if (querySpecification.getLimitTo() != 2 && querySpecification.getLimitTo() != 3) {
            return;
        }
        String search = null;
        ArrayList<String> requiredTypeNames = new ArrayList<String>();
        IJavaProject project = null;
        if (querySpecification instanceof ElementQuerySpecification) {
            ElementQuerySpecification elementQuerySpecification = (ElementQuerySpecification)querySpecification;
            if (elementQuerySpecification.getElement() instanceof IType) {
                search = ((IType)elementQuerySpecification.getElement()).getFullyQualifiedName();
                project = ((IType)elementQuerySpecification.getElement()).getJavaProject();
            } else if (elementQuerySpecification.getElement() instanceof IField) {
                IField field = (IField)elementQuerySpecification.getElement();
                search = field.getElementName();
                this.getTypeHierachy(monitor, requiredTypeNames, field.getDeclaringType());
                project = field.getJavaProject();
            } else if (elementQuerySpecification.getElement() instanceof IMethod) {
                IMethod method = (IMethod)elementQuerySpecification.getElement();
                search = method.getElementName();
                if (search.startsWith("set")) {
                    search = StringUtils.uncapitalize((String)search.substring(3));
                }
                this.getTypeHierachy(monitor, requiredTypeNames, method.getDeclaringType());
                project = method.getJavaProject();
            } else {
                search = elementQuerySpecification.getElement().getElementName();
            }
            int type = ((ElementQuerySpecification)querySpecification).getElement().getElementType();
            if (type == 7) {
                this.searchFor = 0;
            } else if (type == 8 || type == 9) {
                this.searchFor = 1;
            }
        } else {
            this.searchFor = ((PatternQuerySpecification)querySpecification).getSearchFor();
            search = ((PatternQuerySpecification)querySpecification).getPattern();
        }
        ArrayList<AbstractBeansQuery> queries = new ArrayList<AbstractBeansQuery>();
        BeansSearchScope scope = BeansSearchScope.newSearchScope();
        if (this.searchFor == 0) {
            queries.add(new BeanClassQuery(scope, search, true, false));
        } else if (this.searchFor == 1) {
            queries.add(new BeanPropertyQuery(scope, search, true, false));
            queries.add(new BeanReferenceQuery(scope, search, true, false));
        }
        for (ISearchQuery iSearchQuery : queries) {
            iSearchQuery.run(monitor);
            BeansSearchResult searchResult = (BeansSearchResult)iSearchQuery.getSearchResult();
            Object[] objectArray = searchResult.getElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                Match[] matches = searchResult.getMatches(obj);
                if (matches != null && matches.length > 0) {
                    Match[] matchArray = matches;
                    int n3 = matches.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Match match = matchArray[n4];
                        if (match.getElement() instanceof IBean) {
                            IBean bean = (IBean)match.getElement();
                            IType type = JdtUtils.getJavaType((IProject)bean.getElementResource().getProject(), (String)bean.getClassName());
                            if (project == null || type != null && project.isOnClasspath((IJavaElement)type)) {
                                if (this.searchFor == 1) {
                                    String beanClass = BeansModelUtils.getBeanClass((IBean)bean, null);
                                    if (requiredTypeNames.contains(beanClass)) {
                                        requestor.reportMatch(match);
                                    }
                                } else {
                                    requestor.reportMatch(match);
                                }
                            }
                        } else {
                            requestor.reportMatch(match);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private void getTypeHierachy(IProgressMonitor monitor, List<String> requiredTypeNames, IType baseType) {
        try {
            IType[] types = baseType.newTypeHierarchy(monitor).getAllSubtypes(baseType);
            requiredTypeNames.add(baseType.getFullyQualifiedName());
            IType[] iTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                requiredTypeNames.add(type.getFullyQualifiedName());
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public ILabelProvider createLabelProvider() {
        return new BeansSearchLabelProvider(true);
    }

    public void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        if (match.getElement() instanceof IResourceModelElement) {
            BeansUIUtils.openInEditor((IResourceModelElement)((IResourceModelElement)match.getElement()), (boolean)activate);
        }
    }
}

