/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class GetStatusCommand
implements ISVNCommand {
    private ISVNRepositoryLocation repository;
    private IResource resource;
    private boolean descend = true;
    private boolean getAll = true;
    private ISVNStatus[] svnStatuses;
    private boolean checkForReadOnly = SVNProviderPlugin.getPlugin().getPluginPreferences().getBoolean("show_read_only");

    public GetStatusCommand(ISVNLocalResource svnResource, boolean descend, boolean getAll) {
        this.repository = svnResource.getRepository();
        this.resource = svnResource.getIResource();
        this.descend = descend;
        this.getAll = getAll;
    }

    public GetStatusCommand(ISVNRepositoryLocation repository, IResource resource, boolean descend, boolean getAll) {
        this.repository = repository;
        this.resource = resource;
        this.descend = descend;
        this.getAll = getAll;
    }

    public void run(IProgressMonitor monitor) throws SVNException {
        ISVNClientAdapter svnClient = this.repository.getSVNClient();
        try {
            try {
                this.svnStatuses = svnClient.getStatus(this.resource.getLocation().toFile(), this.descend, this.getAll);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        finally {
            this.repository.returnSVNClient(svnClient);
        }
    }

    private LocalResourceStatus[] convert(ISVNStatus[] statuses) {
        LocalResourceStatus[] localStatuses = new LocalResourceStatus[statuses.length];
        int i = 0;
        while (i < statuses.length) {
            localStatuses[i] = new LocalResourceStatus(statuses[i], this.getURL(statuses[i]), this.checkForReadOnly);
            ++i;
        }
        return localStatuses;
    }

    private String getURL(ISVNStatus status) {
        ISVNClientAdapter svnClient = null;
        String url = status.getUrlString();
        if (url == null && status.getTextStatus() != SVNStatusKind.UNVERSIONED) {
            try {
                try {
                    svnClient = this.repository.getSVNClient();
                    ISVNInfo info = svnClient.getInfoFromWorkingCopy(status.getFile());
                    SVNUrl svnurl = info.getUrl();
                    url = svnurl != null ? svnurl.toString() : null;
                }
                catch (SVNException sVNException) {
                }
                catch (SVNClientException sVNClientException) {}
            }
            finally {
                this.repository.returnSVNClient(svnClient);
            }
        }
        return url;
    }

    public ISVNStatus[] getStatuses() {
        return this.svnStatuses;
    }

    public LocalResourceStatus[] getLocalResourceStatuses() {
        return this.convert(this.svnStatuses);
    }
}

