/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class GetInfoCommand
implements ISVNCommand {
    private ISVNInfo info = null;
    private ISVNLocalResource resource = null;

    public GetInfoCommand(ISVNLocalResource resource) {
        this.resource = resource;
    }

    public void run(IProgressMonitor monitor) throws SVNException {
        ISVNClientAdapter svnClient = this.resource.getRepository().getSVNClient();
        try {
            try {
                if (monitor != null) {
                    monitor.beginTask(null, 100);
                }
                this.info = svnClient.getInfoFromWorkingCopy(this.resource.getFile());
                if (monitor != null) {
                    monitor.worked(100);
                }
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        finally {
            this.resource.getRepository().returnSVNClient(svnClient);
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public ISVNInfo getInfo() {
        return this.info;
    }
}

