/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.TestNGPluginConstants;
import org.testng.eclipse.launch.TestNGLaunchConfigurationConstants;
import org.testng.eclipse.ui.RunInfo;
import org.testng.eclipse.ui.util.Utils;
import org.testng.eclipse.util.StringUtils;
import org.testng.eclipse.util.SuiteGenerator;
import org.testng.remote.RemoteTestNG;
import org.testng.xml.LaunchSuite;

public class ConfigurationHelper {
    public static int getLogLevel(ILaunchConfiguration config) {
        String stringResult = ConfigurationHelper.getStringAttribute(config, TestNGLaunchConfigurationConstants.LOG_LEVEL);
        if (stringResult == null) {
            return 2;
        }
        return Integer.parseInt(stringResult);
    }

    public static String getSourcePath(ILaunchConfiguration config) {
        return ConfigurationHelper.getStringAttribute(config, TestNGLaunchConfigurationConstants.DIRECTORY_TEST_LIST);
    }

    public static List<String> getGroups(ILaunchConfiguration config) {
        return ConfigurationHelper.getListAttribute(config, TestNGLaunchConfigurationConstants.GROUP_LIST);
    }

    public static List<String> getGroupClasses(ILaunchConfiguration config) {
        return ConfigurationHelper.getListAttribute(config, TestNGLaunchConfigurationConstants.GROUP_CLASS_LIST);
    }

    public static List<String> getClasses(ILaunchConfiguration config) {
        return ConfigurationHelper.getListAttribute(config, TestNGLaunchConfigurationConstants.CLASS_TEST_LIST);
    }

    public static List<String> getPackages(ILaunchConfiguration config) {
        return ConfigurationHelper.getListAttribute(config, TestNGLaunchConfigurationConstants.PACKAGE_TEST_LIST);
    }

    public static List<String> getSuites(ILaunchConfiguration config) {
        return ConfigurationHelper.getListAttribute(config, TestNGLaunchConfigurationConstants.SUITE_TEST_LIST);
    }

    public static List<String> getSources(ILaunchConfiguration config) {
        return ConfigurationHelper.getListAttribute(config, TestNGLaunchConfigurationConstants.SOURCE_TEST_LIST);
    }

    public static String getProjectName(ILaunchConfiguration config) {
        return ConfigurationHelper.getStringAttribute(config, IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME);
    }

    public static String getMain(ILaunchConfiguration configuration) {
        return ConfigurationHelper.getStringAttribute(configuration, IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME);
    }

    public static List<String> getMethods(ILaunchConfiguration configuration) {
        return ConfigurationHelper.getListAttribute(configuration, TestNGLaunchConfigurationConstants.METHOD_TEST_LIST);
    }

    private static String getProjectJvmArgs() {
        IPreferenceStore store = TestNGPlugin.getDefault().getPreferenceStore();
        String result = store.getString("jvmArgs");
        return result;
    }

    public static String getJvmArgs(ILaunchConfiguration configuration) {
        String result = ConfigurationHelper.getProjectJvmArgs();
        if (configuration != null) {
            try {
                result = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, result);
                result = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(result);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static ILaunchConfigurationWorkingCopy setJvmArgs(ILaunchConfigurationWorkingCopy configuration, String args) {
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, args);
        return configuration;
    }

    public static TestNGLaunchConfigurationConstants.LaunchType getType(ILaunchConfiguration configuration) {
        int result = ConfigurationHelper.getIntAttribute(configuration, TestNGLaunchConfigurationConstants.TYPE);
        return TestNGLaunchConfigurationConstants.LaunchType.fromInt(result);
    }

    public static String getProjectName(ILaunch launch) {
        return launch.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME);
    }

    public static int getPort(ILaunch launch) {
        try {
            return Integer.parseInt(launch.getAttribute(TestNGLaunchConfigurationConstants.PORT));
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public static String getSubName(ILaunch launch) {
        return launch.getAttribute(TestNGLaunchConfigurationConstants.TESTNG_RUN_NAME_ATTR);
    }

    private static Map<String, String> getMapAttribute(ILaunchConfiguration config, String attr) {
        Map result = null;
        try {
            result = config.getAttribute(attr, result);
        }
        catch (CoreException cex) {
            TestNGPlugin.log(cex);
        }
        return result;
    }

    private static List<String> getListAttribute(ILaunchConfiguration config, String attr) {
        List result = null;
        try {
            result = config.getAttribute(attr, result);
        }
        catch (CoreException e) {
            TestNGPlugin.log(e);
        }
        return result;
    }

    private static String getStringAttribute(ILaunchConfiguration config, String attr) {
        String result = null;
        try {
            result = config.getAttribute(attr, result);
        }
        catch (CoreException e) {
            TestNGPlugin.log(e);
        }
        return result;
    }

    private static int getIntAttribute(ILaunchConfiguration config, String attr) {
        int result = 0;
        try {
            result = config.getAttribute(attr, result);
        }
        catch (CoreException e) {
            TestNGPlugin.log(e);
        }
        return result;
    }

    public static ILaunchConfigurationWorkingCopy createBasicConfiguration(ILaunchManager launchManager, IProject project, String confName) {
        ILaunchConfigurationWorkingCopy wConf = null;
        try {
            ILaunchConfigurationType configurationType = launchManager.getLaunchConfigurationType("org.testng.eclipse.launchconfig");
            wConf = configurationType.newInstance(null, confName);
            wConf.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, RemoteTestNG.class.getName());
            wConf.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
        }
        catch (CoreException ce) {
            TestNGPlugin.log(ce);
        }
        return wConf;
    }

    public static void createBasicConfiguration(IJavaProject javaProject, ILaunchConfigurationWorkingCopy config) {
        String projectName = javaProject == null ? "" : javaProject.getElementName();
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, projectName);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, RemoteTestNG.class.getName());
        config.setAttribute(TestNGLaunchConfigurationConstants.TYPE, TestNGLaunchConfigurationConstants.LaunchType.CLASS.ordinal());
        config.setAttribute(TestNGLaunchConfigurationConstants.LOG_LEVEL, "2");
    }

    private static String computeRelativePath(String rootPath, String sourcePath) {
        File rootFile = new File(rootPath);
        String rootRelativeName = rootFile.getName();
        int idx = sourcePath.indexOf(rootPath);
        return String.valueOf(File.separator) + rootRelativeName + sourcePath.substring(idx + rootPath.length());
    }

    public static List<LaunchSuite> getLaunchSuites(IJavaProject ijp, ILaunchConfiguration configuration) {
        TestNGLaunchConfigurationConstants.LaunchType type = ConfigurationHelper.getType(configuration);
        List<String> packages = null;
        List<String> testClasses = null;
        List<String> groups = null;
        Map<String, List<String>> classMethods = null;
        Map<String, String> parameters = null;
        parameters = ConfigurationHelper.getMapAttribute(configuration, TestNGLaunchConfigurationConstants.PARAMS);
        if (type == TestNGLaunchConfigurationConstants.LaunchType.SUITE) {
            return ConfigurationHelper.createLaunchSuites(ijp.getProject(), ConfigurationHelper.getSuites(configuration));
        }
        if (type == TestNGLaunchConfigurationConstants.LaunchType.GROUP) {
            groups = ConfigurationHelper.getGroups(configuration);
            testClasses = ConfigurationHelper.getGroupClasses(configuration);
            packages = ConfigurationHelper.getListAttribute(configuration, TestNGLaunchConfigurationConstants.PACKAGE_TEST_LIST);
        } else if (type == TestNGLaunchConfigurationConstants.LaunchType.CLASS) {
            testClasses = ConfigurationHelper.getClasses(configuration);
        } else if (type == TestNGLaunchConfigurationConstants.LaunchType.METHOD) {
            classMethods = ConfigurationHelper.getClassMethods(configuration);
        } else if (type == TestNGLaunchConfigurationConstants.LaunchType.PACKAGE) {
            packages = ConfigurationHelper.getListAttribute(configuration, TestNGLaunchConfigurationConstants.PACKAGE_TEST_LIST);
        }
        return ConfigurationHelper.createLaunchSuites(ijp.getProject().getName(), packages, testClasses, classMethods, groups, parameters, ConfigurationHelper.getLogLevel(configuration));
    }

    public static Map<String, List<String>> getClassMethods(ILaunchConfiguration configuration) {
        Map<String, String> confResult = ConfigurationHelper.getMapAttribute(configuration, TestNGLaunchConfigurationConstants.ALL_METHODS_LIST);
        if (confResult == null) {
            return null;
        }
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : confResult.entrySet()) {
            String className = entry.getKey();
            String methodNames = entry.getValue();
            results.put(className, Arrays.asList(methodNames.split(";")));
        }
        return results;
    }

    private static List<LaunchSuite> createLaunchSuites(IProject project, List<String> suites) {
        ArrayList result = Lists.newArrayList();
        for (String suitePath : suites) {
            File suiteFile = new File(suitePath);
            if (!suiteFile.exists() || !suiteFile.isFile()) {
                suiteFile = project.getFile(suitePath).getLocation().toFile();
            }
            result.add(SuiteGenerator.createProxiedXmlSuite(suiteFile));
        }
        return result;
    }

    private static List<LaunchSuite> createLaunchSuites(String projectName, List<String> packages, List<String> classNames, Map<String, List<String>> classMethods, List<String> groupNames, Map<String, String> parameters, int logLevel) {
        return Arrays.asList(SuiteGenerator.createCustomizedSuite(projectName, packages, classNames, classMethods, groupNames, parameters, logLevel));
    }

    public static ILaunchConfiguration findConfiguration(ILaunchManager launchManager, IProject project, String confName, RunInfo runInfo) {
        ILaunchConfiguration resultConf = null;
        try {
            ILaunchConfigurationType confType = launchManager.getLaunchConfigurationType("org.testng.eclipse.launchconfig");
            ILaunchConfiguration[] availConfs = launchManager.getLaunchConfigurations(confType);
            String projectName = project.getName();
            String mainRunner = TestNGPluginConstants.MAIN_RUNNER;
            ILaunchConfiguration[] iLaunchConfigurationArray = availConfs;
            int n = availConfs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration availConf = iLaunchConfigurationArray[n2];
                String confProjectName = ConfigurationHelper.getProjectName(availConf);
                String confMainName = ConfigurationHelper.getMain(availConf);
                if (projectName.equals(confProjectName) && mainRunner.equals(confMainName)) {
                    if (confName != null && confName.equals(availConf.getName())) {
                        resultConf = availConf;
                        break;
                    }
                    if (runInfo != null) {
                        String available;
                        List<String> methods;
                        String className;
                        List<String> o;
                        Map<String, List<String>> availableClassMethods = ConfigurationHelper.getClassMethods(availConf);
                        String method = runInfo.getMethodName();
                        if (method != null && availableClassMethods != null && (o = availableClassMethods.get(className = runInfo.getClassName())) != null && o instanceof List && (methods = o).size() == 1 && method.equalsIgnoreCase(available = methods.get(0))) {
                            resultConf = availConf;
                            break;
                        }
                    }
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return resultConf;
    }

    public static Map<String, String> toClassMethodsMap(Map<String, Collection<String>> classMethods) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, Collection<String>> entry : classMethods.entrySet()) {
            String clsName = entry.getKey();
            Collection<String> methods = entry.getValue();
            StringBuffer strMethods = new StringBuffer();
            int i = 0;
            for (String method : methods) {
                if (i++ > 0) {
                    strMethods.append(";");
                }
                strMethods.append(method);
            }
            result.put(clsName, strMethods.toString());
        }
        return result;
    }

    public static void updateLaunchConfiguration(ILaunchConfigurationWorkingCopy configuration, LaunchInfo launchInfo) {
        Collection classes;
        HashMap classMethods = Maps.newHashMap();
        if (launchInfo.m_groupMap != null && (classes = launchInfo.m_groupMap.values()) != null) {
            for (List classList : classes) {
                for (String c : classList) {
                    classMethods.put(c, Collections.emptyList());
                }
            }
        }
        Collection classNames = launchInfo.m_classNames;
        ArrayList<String> classNamesList = new ArrayList<String>();
        if (classNames != null && !classNames.isEmpty()) {
            for (String cls : classNames) {
                classMethods.put(cls, Collections.emptyList());
                classNamesList.add(cls);
            }
        }
        ArrayList packageList = new ArrayList();
        if (launchInfo.m_packageNames != null) {
            packageList.addAll(launchInfo.m_packageNames);
        }
        if (launchInfo.m_classMethods != null) {
            classMethods.putAll(launchInfo.m_classMethods);
        }
        configuration.setAttribute(TestNGLaunchConfigurationConstants.TYPE, launchInfo.m_launchType.ordinal());
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, launchInfo.m_projectName);
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, RemoteTestNG.class.getName());
        configuration.setAttribute(TestNGLaunchConfigurationConstants.CLASS_TEST_LIST, classNamesList);
        configuration.setAttribute(TestNGLaunchConfigurationConstants.PACKAGE_TEST_LIST, packageList);
        configuration.setAttribute(TestNGLaunchConfigurationConstants.GROUP_LIST, new ArrayList(launchInfo.m_groupMap.keySet()));
        configuration.setAttribute(TestNGLaunchConfigurationConstants.GROUP_CLASS_LIST, Utils.uniqueMergeList(launchInfo.m_groupMap.values()));
        configuration.setAttribute(TestNGLaunchConfigurationConstants.SUITE_TEST_LIST, StringUtils.stringToNullList(launchInfo.m_suiteName));
        configuration.setAttribute(TestNGLaunchConfigurationConstants.ALL_METHODS_LIST, ConfigurationHelper.toClassMethodsMap(classMethods));
        configuration.setAttribute(TestNGLaunchConfigurationConstants.LOG_LEVEL, launchInfo.m_logLevel);
    }

    public static class LaunchInfo {
        private String m_projectName;
        private TestNGLaunchConfigurationConstants.LaunchType m_launchType;
        private Collection<String> m_classNames;
        private Collection<String> m_packageNames;
        private Map<String, List<String>> m_classMethods;
        private String m_suiteName;
        private Map<String, List<String>> m_groupMap = Maps.newHashMap();
        private String m_complianceLevel;
        private String m_logLevel;

        public LaunchInfo(String projectName, TestNGLaunchConfigurationConstants.LaunchType launchType, Collection<String> classNames, Collection<String> packageNames, Map<String, List<String>> classMethodsMap, Map<String, List<String>> groupMap, String suiteName, String complianceLevel, String logLevel) {
            this.m_projectName = projectName;
            this.m_launchType = launchType;
            this.m_classNames = classNames;
            this.m_classMethods = classMethodsMap;
            this.m_groupMap = groupMap;
            this.m_suiteName = suiteName.trim();
            this.m_complianceLevel = complianceLevel;
            this.m_logLevel = logLevel;
            this.m_packageNames = packageNames;
        }
    }
}

