/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.ui;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.springsource.ide.eclipse.commons.livexp.core.CompositeValidator;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.PageSection;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;

public abstract class WizardPageWithSections
extends WizardPage
implements IPageWithSections,
ValueListener<ValidationResult> {
    private static final long MESSAGE_DELAY = 250L;
    private List<WizardPageSection> sections = null;
    private CompositeValidator validator;
    private UIJob updateJob;

    protected WizardPageWithSections(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 12;
        layout.marginWidth = 12;
        page.setLayout((Layout)layout);
        this.validator = new CompositeValidator();
        for (PageSection pageSection : this.getSections()) {
            pageSection.createContents(page);
            this.validator.addChild(pageSection.getValidator());
        }
        this.validator.addListener(this);
        this.setControl((Control)page);
        page.pack(true);
        if (this.getContainer().getCurrentPage() != null) {
            this.getContainer().updateButtons();
            this.getContainer().updateMessage();
        }
    }

    protected synchronized List<WizardPageSection> getSections() {
        if (this.sections == null) {
            this.sections = this.createSections();
        }
        return this.sections;
    }

    protected abstract List<WizardPageSection> createSections();

    @Override
    public void gotValue(LiveExpression<ValidationResult> exp, ValidationResult status) {
        this.scheduleUpdateJob();
    }

    private synchronized void scheduleUpdateJob() {
        Shell shell = this.getShell();
        if (shell != null) {
            if (this.updateJob == null) {
                this.updateJob = new UIJob("Update Wizard message"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        ValidationResult status = (ValidationResult)WizardPageWithSections.this.validator.getValue();
                        WizardPageWithSections.this.setErrorMessage(null);
                        WizardPageWithSections.this.setMessage(null);
                        if (!status.isOk()) {
                            if (status.status == 4) {
                                WizardPageWithSections.this.setErrorMessage(status.msg);
                            } else if (status.status == 2) {
                                WizardPageWithSections.this.setMessage(status.msg, 2);
                            } else if (status.status == 1) {
                                WizardPageWithSections.this.setMessage(status.msg, 1);
                            } else {
                                WizardPageWithSections.this.setMessage(status.msg, 0);
                            }
                        }
                        WizardPageWithSections.this.setPageComplete(status.isOk());
                        return Status.OK_STATUS;
                    }
                };
                this.updateJob.setSystem(true);
            }
            this.updateJob.schedule(250L);
        }
    }

    public void dispose() {
        for (WizardPageSection s : this.sections) {
            s.dispose();
        }
    }
}

