/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.core.validators;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;

public class NewProjectNameValidator
extends Validator
implements ValueListener<String> {
    private final LiveExpression<String> projectNameField;

    public NewProjectNameValidator(LiveExpression<String> projectNameField) {
        this.projectNameField = projectNameField;
        projectNameField.addListener(this);
    }

    private boolean isAllowedChar(char c) {
        return Character.isLetterOrDigit(c) || "-_.".indexOf(c) >= 0;
    }

    @Override
    protected ValidationResult compute() {
        String projectName = this.projectNameField.getValue();
        if (projectName == null) {
            return ValidationResult.error("Project name is undefined");
        }
        if ("".equals(projectName)) {
            return ValidationResult.error("Project name is empty");
        }
        if (projectName.indexOf(32) >= 0) {
            return ValidationResult.error("Project name contains spaces");
        }
        if (this.existsInWorkspace(projectName)) {
            return ValidationResult.error("A project with name '" + projectName + "' already exists in the workspace.");
        }
        int i = 0;
        while (i < projectName.length()) {
            char c = projectName.charAt(i);
            if (!this.isAllowedChar(c)) {
                return ValidationResult.error("Project name contains forbidden character '" + c + "'");
            }
            ++i;
        }
        return ValidationResult.OK;
    }

    private boolean existsInWorkspace(String projectName) {
        IProject[] eclipseProjects;
        IProject[] iProjectArray = eclipseProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = eclipseProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (p.getName().equals(projectName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void gotValue(LiveExpression<String> exp, String value) {
        Assert.isLegal((exp == this.projectNameField ? 1 : 0) != 0);
        this.refresh();
    }
}

