/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;

public class LiveSet<T>
extends LiveExpression<Set<T>> {
    private boolean dirty = false;

    public LiveSet() {
        this(new HashSet());
    }

    public LiveSet(Set<T> intialBackingCollection) {
        this.value = intialBackingCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        boolean wasDirty;
        LiveSet liveSet = this;
        synchronized (liveSet) {
            wasDirty = this.dirty;
            this.dirty = false;
        }
        if (wasDirty) {
            this.changed();
        }
    }

    @Override
    protected Set<T> compute() {
        throw new Error("Shouldn't be reachable because refresh is overridden");
    }

    public boolean contains(T name) {
        return ((Set)this.value).contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T name) {
        LiveSet liveSet = this;
        synchronized (liveSet) {
            if (((Set)this.value).contains(name)) {
                return;
            }
            ((Set)this.value).add(name);
            this.dirty = true;
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(T name) {
        LiveSet liveSet = this;
        synchronized (liveSet) {
            if (!((Set)this.value).contains(name)) {
                return;
            }
            ((Set)this.value).remove(name);
            this.dirty = true;
        }
        this.refresh();
    }

    public synchronized List<T> getValues() {
        ArrayList l = new ArrayList(((Set)this.value).size());
        l.addAll((Collection)this.value);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(T[] elements) {
        LiveSet liveSet = this;
        synchronized (liveSet) {
            T[] TArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                T e = TArray[n2];
                this.dirty = ((Set)this.value).add(e) || this.dirty;
                ++n2;
            }
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection<T> elements) {
        LiveSet liveSet = this;
        synchronized (liveSet) {
            for (T e : elements) {
                boolean bl = this.dirty = ((Set)this.value).add(e) || this.dirty;
            }
        }
        this.refresh();
    }
}

